
/*
 * Licensed Materials - Property of IBM
 *
 * trousers - An open source TCG Software Stack
 *
 * (C) Copyright International Business Machines Corp. 2004
 *
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <pthread.h>

#include "trousers/tss.h"
#include "trousers_types.h"
#include "tsplog.h"
#include "hosttable.h"
#include "obj.h"
#include "tcsd.h"

static struct host_table *ht = NULL;

TSS_RESULT
host_table_init()
{
	ht = calloc(1, sizeof(struct host_table));
	if (ht == NULL) {
		LogError("malloc of %zd bytes failed.", sizeof(struct host_table));
		return TSPERR(TSS_E_OUTOFMEMORY);
	}

	pthread_mutex_init(&ht->lock, NULL);

	return TSS_SUCCESS;
}

void __attribute__ ((constructor)) my_init(void)
{
	host_table_init();
	obj_list_init();
}

#if 0
void
host_table_final()
{
	struct host_table_entry *hte, *next = NULL;

	pthread_mutex_lock(&(ht->lock));

	for (hte = ht->entries; hte; hte = next) {
		if (hte)
			next = hte->next;
		free(hte);
	}

	pthread_mutex_unlock(&(ht->lock));

	free(ht);
	ht = NULL;
}

void __attribute__ ((destructor)) my_fini(void)
{
	host_table_final();
}
#endif

TSS_RESULT
add_table_entry(TSS_HCONTEXT tspContext, BYTE *host, int type, struct host_table_entry **ret)
{
        struct host_table_entry *entry, *tmp;

        if ((entry = calloc(1, sizeof(struct host_table_entry))) == NULL) {
                LogError("malloc of %zd bytes failed.", sizeof(struct host_table_entry));
                return TSPERR(TSS_E_OUTOFMEMORY);
        }

        entry->tspContext = tspContext;
        entry->hostname = host;
        entry->type = type;
        entry->comm.buf_size = TCSD_INIT_TXBUF_SIZE;
        entry->comm.buf = calloc(1, entry->comm.buf_size);
        if (entry->comm.buf == NULL) {
                LogError("malloc of %u bytes failed.", entry->comm.buf_size);
                free(entry);
                return TSPERR(TSS_E_OUTOFMEMORY);
        }
        pthread_mutex_init(&entry->lock, NULL);

	pthread_mutex_lock(&ht->lock);

	for (tmp = ht->entries; tmp; tmp = tmp->next) {
		if (tmp->tspContext == entry->tspContext) {
			LogError("Tspi_Context_Connect attempted on an already connected context!");
			pthread_mutex_unlock(&ht->lock);
			return TSPERR(TSS_E_CONNECTION_FAILED);
		}
	}

	if( ht->entries == NULL ) {
		ht->entries = entry;
	} else {
		for (tmp = ht->entries; tmp->next; tmp = tmp->next)
			;
		tmp->next = entry;
	}

	pthread_mutex_unlock(&ht->lock);

	*ret = entry;

	return TSS_SUCCESS;
}

void
remove_table_entry(TSS_HCONTEXT tspContext)
{
	struct host_table_entry *hte, *prev = NULL;

	pthread_mutex_lock(&(ht->lock));

	for (hte = ht->entries; hte; prev = hte, hte = hte->next) {
		if (hte->tspContext == tspContext) {
			if (prev != NULL)
				prev->next = hte->next;
			else
				ht->entries = hte->next;
			free(hte->comm.buf);
			free(hte);
			break;
		}
	}

	pthread_mutex_unlock(&(ht->lock));
}

struct host_table_entry *
get_table_entry(TSS_HCONTEXT tspContext)
{
	struct host_table_entry *index = NULL;

	pthread_mutex_lock(&(ht->lock));

	for (index = ht->entries; index; index = index->next) {
		if (index->tspContext == tspContext)
			break;
	}

	if (index)
		pthread_mutex_lock(&(index->lock));

	pthread_mutex_unlock(&(ht->lock));

	return index;
}

void
put_table_entry(struct host_table_entry *entry)
{
	if (entry)
		pthread_mutex_unlock(&(entry->lock));
}

