# -*- coding: utf-8 -*-
#
# Copyright 2015 Zuza Software Foundation
#
# This file is part of translate.
#
# translate is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# translate is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.

"""This module represents the Assamese language.

.. seealso:: https://en.wikipedia.org/wiki/Assamese_language
"""

from translate.lang import common


class code_as(common.Common):
    """This class represents Assamese."""

    numbertuple = (
        (u"0", u"০"),  # U+09E6 Bengali digit zero.
        (u"1", u"১"),  # U+09E7 Bengali digit one.
        (u"2", u"২"),  # U+09E8 Bengali digit two.
        (u"3", u"৩"),  # U+09E9 Bengali digit three.
        (u"4", u"৪"),  # U+09EA Bengali digit four.
        (u"5", u"৫"),  # U+09EB Bengali digit five.
        (u"6", u"৬"),  # U+09EC Bengali digit six.
        (u"7", u"৭"),  # U+09ED Bengali digit seven.
        (u"8", u"৮"),  # U+09EE Bengali digit eight.
        (u"9", u"৯"),  # U+09EF Bengali digit nine.
    )
