typedef long long vlong;
typedef unsigned long long uvlong;
typedef unsigned short Rune;
typedef unsigned char uchar;

#include "../libunix/unix.h"

typedef uint32_t u32int;
typedef struct Label Label;

/* set/gotolabel account for delay slot a la SunOS set/longjmp */
#define LABELDPC 0

// XXX: 32-bit sparc v8 only; 386 and sparc64 (sparc v9) later
#if defined(__sparcv8) || defined(__sparcv9)
struct Label
{
	ulong	pad;
	ulong	sp;	/* o6 */
	ulong	pc;	/* o7 */
	ulong	fp;	/* i6 */
	ulong	i7;
};

#elif defined(i386)
struct Label
{
	ulong bx; /* ia32/x86 */
	ulong bp;
	ulong si;
	ulong di;
}
#else
#error "Unknown or unsupported architecture"
#endif
