#include "tra.h"

int
syscreateexcl(char *name)
{
	/* BUG: put DMEXCL back and add a lock tickler */
	return create(name, ORDWR|OEXCL, /*DMEXCL|*/0666);
}

char*
mktemp(char *as)
{
	char *s;
	unsigned pid;
	int i, j, k;
	char err[ERRMAX];

	pid = getpid();
	s = as;
	while(*s++)
		;
	s--;
	while(*--s == 'X') {
		*s = pid % 10 + '0';
		pid = pid/10;
	}
	s++;
	for(i='a'; i<='z'; i++)
	for(j='a'; j<='z'; j++)
	for(k='a'; k<='z'; k++){
		s[0] = i;
		s[1] = j;
		s[2] = k;
		if(access(as, 0) == -1){
			err[0] = '\0';
			errstr(err, sizeof err);	/* clear the error */
			return as;
		}
	}
	return "/";
}
static int
opentemp(char *template)
{
	int fd, i;
	char *p;

	p = estrdup(template);
	fd = -1;
	for(i=0; i<256; i++){
		mktemp(p);
		if((fd=create(p, ORDWR|OEXCL|ORCLOSE, 0000)) >= 0)
			break;
		strcpy(p, template);
	}
	if(fd < 0)
		return -1;
	free(p);
	return fd;
}

int
sysclose(Fid *fid)
{
	close(fid->fd);
	fid->fd = -1;
	return 0;
}

int
syscommit(Fid *fid)
{
	int n, wfd;
	char *buf;
	Dir d;

	if((wfd = create(fid->tpath, OWRITE, 0666)) < 0)
		return -1;

	buf = emalloc(IOCHUNK);
	if(seek(fid->fd, 0, 0) < 0)
		abort();
	while((n = read(fid->fd, buf, IOCHUNK)) > 0){
		if(write(wfd, buf, n) != n)
			abort();	/* BUG: handle this better */
	}
	if(fid->omode[0] != ~0){
		nulldir(&d);
		d.mode = fid->omode[0];
		dirfwstat(wfd, &d);
	}
	close(wfd);
	close(fid->fd);
	fid->fd = -1;
	return 0;
}

int
syskids(char *tpath, char ***pk)
{
	Dir *d;
	char **k;
	int fd, i, n;

	*pk = nil;
	if((fd = open(tpath, OREAD)) < 0)
		return -1;
	if((d = dirfstat(fd)) == nil){
		close(fd);
		return -1;
	}
	if(!(d->mode&DMDIR)){
		free(d);
		close(fd);
		return -1;
	}
	n = dirreadall(fd, &d);
	close(fd);
	if(n < 0)
		return -1;
	k = emalloc(sizeof(k[0])*n);
	for(i=0; i<n; i++)
		k[i] = estrdup(d[i].name);
	free(d);
	*pk = k;
	return n;
}

int
sysmkdir(char *tpath, Stat *s)
{
	int fd;

	USED(s);
	fd = create(tpath, OREAD, DMDIR|0777);
	if(fd < 0)
		return -1;
	close(fd);
	return 0;
}

int
sysopen(Fid *fid, char *file, int mode)
{
	int fd;

	switch(mode){
	default:
		abort();
	case 'r':
		if((fd = open(file, OREAD)) < 0)
			return -1;
		fid->fd = fd;
		break;
	case 'w':
		fid->omode[0] = ~0;
		if(access(file, AEXIST) >= 0 && access(file, AWRITE) < 0)
			if(!config("mkwriteable") || tramkwriteable(fid, file) < 0)
				return -1;
		if((fd = opentemp("/tmp/traXXXXXXXXX")) < 0)
			return -1;
		fid->fd = fd;
		break;
	}
	return 0;
}

int
sysread(Fid *fid, void *a, int n)
{
	return read(fid->fd, a, n);
}

int
sysseek(Fid *fid, vlong off)
{
	return seek(fid->fd, off, 0) == off ? 0 : -1;
}

int
sysremove(char *tpath)
{
	return remove(tpath);
}

enum
{
	DMMASK = DMAPPEND | DMEXCL | DMRWXBITS
};
Datum
mksig(Qid q)
{
	uchar *p;
	Datum d;

	d.a = emalloc(8+4+1);
	p = d.a;
	*p++ = q.path>>56;
	*p++ = q.path>>48;
	*p++ = q.path>>40;
	*p++ = q.path>>32;
	*p++ = q.path>>24;
	*p++ = q.path>>16;
	*p++ = q.path>>8;
	*p++ = q.path;
	*p++ = q.vers>>24;
	*p++ = q.vers>>16;
	*p++ = q.vers>>8;
	*p++ = q.vers;
	*p = q.type;
	d.n = 8+4+1;
	return d;
}

int
shafile(uchar *d, char *file)
{
	int fd, n;
	uchar *buf;
	DigestState *s;

	memset(d, 0, 20);

	if((fd = open(file, OREAD)) < 0)
		return -1;

	buf = emalloc(IOCHUNK);
	s = nil;
	while((n = read(fd, buf, IOCHUNK)) > 0)
		s = sha1(buf, n, nil, s);
	close(fd);
	free(buf);
	if(s)
		sha1(nil, 0, d, s);
	return 0;
}

/*
 * Update stat structure s with information about path.
 * Return true if the exported info changes.
 * If recordchanges==0, don't touch the exported info;
 * just update the local stuff.  s->state always changes
 * for consistency.
 */
int
sysstat(char *tpath, Stat *s, int recordchanges)
{
	int changed, contentschanged, nstate;
	ulong p;
	uchar sha[20];
	Dir *d;
	Datum dqid;

	d = dirstat(tpath);
	if(d == nil){
		if(s->state != SNonexistent){
			if(!recordchanges)
				abort();
			sysstatnotedelete(s);
			return 1;
		}
		return 0;
	}

	changed = 0;
	if(d->mode&DMDIR)
		nstate = SDir;
	else
		nstate = SFile;

	if(s->state != nstate){
		s->state = nstate;
		changed = 1;
	}

	/*
	 * metadata changed?
	 *
	 * the general form of these is:
	 *	if(s->localfoo != s->foo){
	 *		s->localfoo = s->foo;	
	 *		if(config("setfoo")){
	 *			s->foo = s->localfoo;
	 *			changed = 1;
	 *		}
	 *	}
	 *
	 * The localfoo variables aren't strictly necessary,
	 * but they're an attempt to deal gracefully with the
	 * case where the configuration changes between syncs.
	 * That is, if we weren't setting uids and then decide to
	 * start setting them, having the localuids keeps us from
	 * thinking that they've all changed all of a sudden.
	 */

	p = s->localmode;
	if(p == ~0)
		p = 0;
	p = (p&~DMMASK) | (d->mode&DMMASK);
	if(s->localmode != p){
		s->localmode = p;
		if(s->mode == ~0)
			s->mode = p;
		if(recordchanges && config("setmode")){
			s->mode = s->localmode;
			changed = 1;
		}
	}

	if(s->localuid==nil || strcmp(s->localuid, d->uid) != 0){
		free(s->localuid);
		s->localuid = estrdup(d->uid);
		if(recordchanges && config("setuid")){
			free(s->uid);
			s->uid = estrdup(s->localuid);
			changed = 1;
		}
	}

	if(s->localgid==nil || strcmp(s->localgid, d->gid) != 0){
		free(s->localgid);
		s->localgid = estrdup(d->gid);
		if(recordchanges && config("setgid")){
			free(s->gid);
			s->gid = estrdup(s->localgid);
			changed = 1;
		}
	}

	contentschanged = 0;
	if(!(d->mode & DMDIR)){
		if(s->localsysmtime != d->mtime){
			s->localsysmtime = d->mtime;
			if(recordchanges && config("setmtime")){
				s->sysmtime = s->localsysmtime;
				changed = 1;
			}
		}
	
		dqid = mksig(d->qid);
		if(s->length != d->length /* || config("paranoid") */
		|| datumcmp(&dqid, &s->localsig) != 0){
			free(s->localsig.a);
			s->localsig = dqid;
			dqid.a = nil;
			shafile(sha, tpath);
			if(s->length != d->length || memcmp(s->sha1, sha, 20) != 0){
				memmove(s->sha1, sha, 20);
				s->length = d->length;
				changed = 1;
				contentschanged = 1;
			}
		}
		free(dqid.a);
	}

	/*
	 * watch muid, but it doesn't cause a file change.
	 * (there should be an associated contents change.)
	 * we even watch the muid on systems without muids:
	 * if we don't know who made the change, we still need
	 * to record that fact.
	 */

	if(contentschanged){
		free(s->muid);
		s->muid = estrdup(d->muid);
	}

	free(d);
	return changed;
}

int
syswrite(Fid *fid, void *a, int n)
{
	return write(fid->fd, a, n);
}

/*
 * Incorporate the stat info in t into s,
 * making changes to the underlying file system
 * metadata as appropriate.
 */
int
syswstat(char *tpath, Stat *s, Stat *t)
{
	int changed, contentschanged;
	ulong p;
	Dir nd;

	changed = 0;
	if(s->state != t->state){
		werrstr("cannot change from state %d to %d", s->state, t->state);
		return -1;
	}

	/* mode changed? */
	p = t->mode;
	if(s->mode != p){
		if(config("setmode")){
			nulldir(&nd);
			nd.mode = (p&DMMASK);
			if(dirwstat(tpath, &nd) >= 0)
				s->localmode = p;
		}
		s->mode = p;
		changed = 1;
	}

	/* uid changed? */
	if(nilstrcmp(s->uid, t->uid) != 0){
		if(config("setuid")){
			nulldir(&nd);
			nd.uid = t->uid;
			if(dirwstat(tpath, &nd) >= 0){
				free(s->localuid);
				s->localuid = estrdup(t->uid);
			}
		}
		free(s->uid);
		s->uid = estrdup(t->uid);
		changed = 1;
	}

	/* gid changed? */
	if(nilstrcmp(s->gid, t->gid) != 0){
		if(config("setgid")){
			nulldir(&nd);
			nd.gid = t->gid;
			if(dirwstat(tpath, &nd) >= 0){
				free(s->localgid);
				s->localgid = estrdup(t->gid);
			}
		}
		free(s->gid);
		s->gid = estrdup(t->gid);
		changed = 1;
	}

	/* mtime changed? */
	if(s->sysmtime != t->sysmtime){
		if(config("setmtime")){
			nulldir(&nd);
			nd.mtime = t->sysmtime;
			if(dirwstat(tpath, &nd) >= 0)
				s->localsysmtime = t->sysmtime;
		}
		s->sysmtime = t->sysmtime;
		changed = 1;
	}

	/* length changed? (could verify this) */
	contentschanged = 0;
	if(s->length != t->length){
		s->length = t->length;
		contentschanged = 1;
		changed = 1;
	}

	/* sha1 changed? (could verify this) */
	if(memcmp(s->sha1, t->sha1, 20) != 0){
		memmove(s->sha1, t->sha1, 20);
		contentschanged = 1;
		changed = 1;
	}

	if(contentschanged){
		free(s->muid);
		s->muid = estrdup(t->muid);
	}

	return changed;
}

int
tramkwriteable(Fid *fid, char *tpath)
{
	Dir *d;

	if((d = dirstat(tpath)) == nil)
		return -1;

	fid->omode[0] = d->mode;
	d->mode |= 0222;
	if(dirwstat(tpath, d) < 0){
		free(d);
		return -1;
	}
	free(d);
	return 0;
}

