#include "os.h"
#include <time.h>

ulong
fastrand(void)
{
	ulong seed;
	struct timeval tv;
	static int first = 1;

	if(first){
		gettimeofday(&tv, nil);
		seed = tv.tv_sec ^ tv.tv_usec ^ (getpid()<<8);
		srandom(seed);
		first = 0;
	}
	return (random()&0xFFFF)|(random()<<16);
}
