typedef struct Pool Pool;
typedef struct Traverse Traverse;
struct Pool {
	char*	name;
	ulong	maxsize;

	ulong	cursize;
	ulong	curfree;
	ulong	curalloc;

	ulong	minarena;	/* smallest size of new arena */
	ulong	quantum;	/* allocated blocks should be multiple of */
	ulong	minblock;	/* smallest newly allocated block */

	void*	freeroot;	/* actually Free* */
	void*	arenalist;	/* actually Arena* */

	void*	(*alloc)(ulong);
	int		(*merge)(void*, void*);
	void		(*move)(void* from, void* to);

	int		flags;
	int		nfree;
	int		lastcompact;

	void		(*lock)(Pool*);
	void		(*unlock)(Pool*);
	void		(*print)(Pool*, char*, ...);
	void		(*panic)(Pool*, char*, ...);
	void		(*logstack)(Pool*);

	void*	private;
};

struct Traverse
{
	int	(*visit)(void*, ulong);
	int	maxvisit;

	/* internal use only */
	void		*a;
	void		*b;
	void		*prev;
};

extern void*	poolalloc(Pool*, ulong);
extern void	poolfree(Pool*, void*);
extern ulong	poolmsize(Pool*, void*);
extern void*	poolrealloc(Pool*, void*, ulong);
extern void	poolcheck(Pool*);
extern int		poolcompact(Pool*);
extern void	poolblockcheck(Pool*, void*);
extern int		pooltraverse(Pool*, Traverse*);

extern Pool*	pm_mainmem;
extern Pool*	pm_imagmem;

enum {	/* flags */
	POOL_ANTAGONISM	= 1<<0,
	POOL_PARANOIA		= 1<<1,
	POOL_VERBOSITY		= 1<<2,
	POOL_DEBUGGING		= 1<<3,
	POOL_LOGGING		= 1<<4,
	POOL_TOLERANCE		= 1<<5
};

#ifndef NODEFINE
#undef  mainmem
#define mainmem			pm_mainmem
#undef  imagmem
#define imagmem			pm_imagmem
#endif
