/*
 *  The Mana World
 *  Copyright (C) 2004  The Mana World Development Team
 *
 *  This file is part of The Mana World.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _SHOPITEM_H
#define _SHOPITEM_H

#include "item.h"

/**
 * Represents an item in a shop inventory.
 */
class ShopItem : public Item
{
    public:
        /**
         * Constructor.
         */
        ShopItem(int id, int quantity, int price);

        /**
         * Gets the price of the item.
         */
        int getPrice() const
        { return mPrice; }

        /**
         * Gets the display name for in the shop list.
         */
        const std::string& getDisplayName() const
        { return mDisplayName; }

    protected:
        int mPrice;
        int mIndex;
        std::string mDisplayName;
};

#endif
