/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: load.cpp 1.2 Sat, 13 Sep 1997 12:04:11 -0600 maccabe $";

//----------------------------------------------------------------------
// Load Instructions - see p163 of SPARC Architecture Manual, Version 8
//----------------------------------------------------------------------

#include "sizedefs.h"
#include "globals.h"
#include "Instruct.h"
#include "MMU.h"
#include "sys_bus.h"
#include "RegBlock.h"
#include "IU.h"
#include "FPU.h"


void IntegerUnit::load(const Instruction& inst) {
    UInt32 address, addr_space;

    switch (inst.op3()) {
    case Instruction::LDD:
    case Instruction::LD:
    case Instruction::LDSH:
    case Instruction::LDUH:
    case Instruction::LDSB:
    case Instruction::LDUB:
    case Instruction::LDDF:
    case Instruction::LDF:
    case Instruction::LDFSR:
    case Instruction::LDDC:
    case Instruction::LDC:
    case Instruction::LDCSR:
	address = reg[inst.rs1()] +
		  ((inst.i() == 0) ? reg[inst.rs2()] : inst.simm13());
	addr_space = (IU_S == 0) ? USER_DATA : SUPERVISOR_DATA;
	break;

    case Instruction::LDDA:
    case Instruction::LDA:
    case Instruction::LDSHA:
    case Instruction::LDUHA:
    case Instruction::LDSBA:
    case Instruction::LDUBA:
	if (IU_S == 0) {
	    trap = 1;
	    trapFlag[privileged_instruction] = 1;
            // Init address and addr_space to shut up gcc
            address = ~0;
            addr_space = USER_DATA;
	}
	else if (inst.i() == 1) {
	    trap = 1;
	    trapFlag[illegal_instruction] = 1;
            // Init address and addr_space to shut up gcc
            address = ~0;
            addr_space = USER_DATA;
	}
	else {
	    address = reg[inst.rs1()] + reg[inst.rs2()];
	    addr_space = inst.asi();
	}
    	break;
    default:
	Assert(0, "Bad Load: PLEASE EMAIL isem@cs.unm.edu with this error!");
    }
    // next


    if (trap == 0) {
	switch (inst.op3()) {
	case Instruction::LDDF:
	case Instruction::LDF:
	case Instruction::LDFSR:
	    if ( sbus.bp_FPU_present() == 0 ) {
		trap = 1;
		trapFlag[fp_disabled] = 1;
	    }
	    break;

	case Instruction::LDDC:
	case Instruction::LDC:
	case Instruction::LDCSR:
	    trap = 1;			// no coprocessor support
	    trapFlag[cp_disabled] = 1;
	    break;
	default:
          // See 'Sun Jan 14 02:22:19 2001 Ackley' note in store.cpp
          // Assert(0, "Bad load");
          break;
	}
    }

    if (trap == 0) {
	switch (inst.op3()) {
	case Instruction::LDD:
	case Instruction::LDDA:
	case Instruction::LDDF:
	case Instruction::LDDC:
	    if (address & 7) {
		trap = 1;
		trapFlag[mem_address_not_aligned] = 1;
	    }
	    else if ( inst.op3() == Instruction::LDD  &&  inst.rd() & 1 ) {
		trap = 1;
		trapFlag[fp_exception] = 1;
#ifdef NOT_YET
		fpu->ftt( invalid_fp_register );
#endif
	    }
	    break;

	case Instruction::LD:
	case Instruction::LDA:
	case Instruction::LDF:
	case Instruction::LDFSR:
	case Instruction::LDC:
	case Instruction::LDCSR:
	    if (address & 3) {
		trap = 1;
		trapFlag[mem_address_not_aligned] = 1;
	    }
	    break;

	case Instruction::LDSH:
	case Instruction::LDSHA:
	case Instruction::LDUH:
	case Instruction::LDUHA:
	    if (address & 1) {
		trap = 1;
		trapFlag[mem_address_not_aligned] = 1;
	    }
	    break;

	default:
          // See 'Sun Jan 14 02:22:19 2001 Ackley' note in store.cpp
          // Assert(0, "Bad load");
          break;
	}
    }
    // next

    UInt32 word0;

    if (trap == 0) {
	UInt32 data = mmu.read(addr_space, address);
	// next

	if (sbus.bp_memory_exception()) {
	    trap = 1;
	    trapFlag[data_access_exception] = 1;

            // Init word0 to shut up gcc
            word0 = 0;

	}
	else {
	    switch (inst.op3()) {
	    case Instruction::LDSB:
	    case Instruction::LDSBA:
		word0 = (data >> (24 - ((address & 3) << 3))) & 0xff;
		if (word0 & 0x80)    // if necessary, sign extend
		    word0 |= 0xffffff00;
		break;

	    case Instruction::LDUB:
	    case Instruction::LDUBA:
		word0 = (data >> (24 - ((address & 3) << 3))) & 0xff;
		break;

	    case Instruction::LDSH:
	    case Instruction::LDSHA:
		word0 = (data >> (16 - ((address & 2) << 3))) & 0xffff;
		if (word0 & 0x8000)    // if necessary, sign extend
		    word0 |= 0xffff0000;
		break;

	    case Instruction::LDUH:
	    case Instruction::LDUHA:
		word0 = (data >> (16 - ((address & 2) << 3))) & 0xffff;
		break;

	    default:
		word0 = data;
	    }
	}
    }
    // next

    if (trap == 0) {
	switch (inst.op3()) {
	case Instruction::LD:
	case Instruction::LDA:
	case Instruction::LDSH:
	case Instruction::LDSHA:
	case Instruction::LDUH:
	case Instruction::LDUHA:
	case Instruction::LDSB:
	case Instruction::LDSBA:
	case Instruction::LDUB:
	case Instruction::LDUBA:
	    reg[inst.rd()] = word0;
	    break;

	case Instruction::LDF:
	    fpu->ireg( inst.rd(), word0 );
	    break;

	case Instruction::LDFSR:
	    fpu->FSR( word0 );
	    break;

	case Instruction::LDD:
	case Instruction::LDDA:
	    reg[inst.rd() & 0x1e] = word0;
	    break;

	case Instruction::LDDF:
	    fpu->ireg( inst.rd() & 0x1e, word0 );
	    break;

	default:
	    Assert(0, "Bad Load: PLEASE EMAIL isem@cs.unm.edu with this error!");
	}
    }

    if ( trap == 0  &&  ( inst.op3() == Instruction::LDD  ||
			  inst.op3() == Instruction::LDDA ||
			  inst.op3() == Instruction::LDDF )) {

	UInt32 word1 = mmu.read(addr_space, address + 4);
	// next

	if (sbus.bp_memory_exception()) {
	    trap = 1;
	    trapFlag[data_access_exception] = 1;
	}
	else if ( inst.op3() == Instruction::LDDF ) {
	    fpu->ireg( inst.rd() | 0x01 , word1 );
	}
	else {   // must be LDD or LDDA, therefore
	    reg[inst.rd() | 0x01] = word1;
	}
    }
}
