/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//----------------------------------------------------------------------
// compare instructions - see page 148 of SPARC Architecture Manual,
//				              Version 8
//----------------------------------------------------------------------

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: compare.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

#include "Assert.h"
#include "sizedefs.h"
#include "Instruct.h"
#include "FPU.h"

// NEED
// fp_exception -- NV, invalid_fp_register

int FloatingPointUnit::compare(const Instruction& inst) { 
    switch (inst.opf()){
    case FCMPs:
	break;
    case FCMPd:
	break;
    case FCMPEs:
	break;
    case FCMPEd:
	break;
    case FCMPEq:
    case FCMPq:
        _ftt = unimplemented_FPop;
        return unimplemented();
    default:
        Assert(0, "unknown opf: PLEASE EMAIL isem@cs.unm.edu with this error!");
    }
    _ftt = No_FPU_Trap;
    return 0;
}
