
import os
from distutils.core import setup, Extension

# try to determine the directory where the shapelib source files are.
# There are currently two supported situations.
#
# 1. "Standalone" build: the parent directory is the shapelib source
#    directory
# 2. Built in the Thuban source tree where it's ../shapelib/ relative to
#    the directory containing this setup.py

# os.path expects filenames in OS-specific form so we have to construct
# the files with os.path functions. distutils, OTOH, uses posix-style
# filenames exclusively, so we posix when making filenames for
# distutils.
if os.path.exists(os.path.join(os.pardir, "shpeopen.c")):
    shp_dir = ".."
elif os.path.exists(os.path.join(os.pardir, "shapelib")):
    shp_dir = "../shapelib"

extensions = [Extension("shapelibc",
                        ["shapelib_wrap.c",
                         shp_dir + "/shpopen.c",
                         shp_dir + "/shptree.c"],
                        include_dirs = [shp_dir]),
              Extension("shptree",
                        ["shptreemodule.c"],
                        include_dirs = [shp_dir]),
              Extension("dbflibc",
                        ["dbflib_wrap.c",
                         shp_dir + "/dbfopen.c"],
                        include_dirs = [shp_dir])]

setup(name = "pyshapelib",
      version = "0.3",
      description = "Python bindings for shapelib",
      author = "Bernhard Herzog",
      author_email = "bh@intevation.de",
      url = "ftp:intevation.de/users/bh",
      py_modules = ["shapelib", "dbflib"],
      ext_modules = extensions)

