#!/bin/sh
CC=gcc
LYNX=links
# Comment the version definition to not compile the library
VER_E2FSPROGS=1.34
VER_PROGSREISERFS=0.3.1-rc8
VER_NTFSPROGS=1.8.2
LIBEXT=e2fsprogs-$VER_E2FSPROGS/lib/ext2fs/libext2fs.a
LIBNTFS=ntfsprogs-$VER_NTFSPROGS/libntfs/.libs/libntfs.a
LIBREISER=progsreiserfs-$VER_PROGSREISERFS/libreiserfs/.libs/libreiserfs.a

echo "This script will compile e2fsprogs progsreiserfs ntfsprogs libraries"

if [ "$VER_E2FSPROGS" != "" ];
then
if [ ! -e e2fsprogs-$VER_E2FSPROGS.tar.gz ];
then
	$(LYNX) http://prdownloads.sourceforge.net/e2fsprogs/e2fsprogs-$VER_E2FSPROGS.tar.gz
fi

if [ ! -e e2fsprogs-$VER_E2FSPROGS/configure ];
then
	tar xzf e2fsprogs-$VER_E2FSPROGS.tar.gz
fi

if [ ! -e e2fsprogs-$VER_E2FSPROGS/Makefile ];
then
	cd e2fsprogs-$VER_E2FSPROGS
	./configure --with-cc=$CC
	cd ..
fi

if [ ! -e $LIBEXT ];
then
	make -C e2fsprogs-$VER_E2FSPROGS libs
fi
fi

if [ "$VER_PROGSREISERFS" != "" ];
then
if [ ! -e progsreiserfs-$VER_PROGSREISERFS.tar.gz ];
then
	$(LYNX) http://reiserfs.osdn.org.ua/snapshots/progsreiserfs-$VER_PROGSREISERFS.tar.gz
fi

if [ ! -e progsreiserfs-$VER_PROGSREISERFS/configure ];
then
	tar xzf progsreiserfs-$VER_PROGSREISERFS.tar.gz
fi

if [ ! -e progsreiserfs-$VER_PROGSREISERFS/Makefile ];
then
	cd progsreiserfs-$VER_PROGSREISERFS
	./configure --disable-nls CC=$CC
	cd ..
fi

if [ ! -e $LIBREISER ];
then
	cd progsreiserfs-$VER_PROGSREISERFS
	make
	cd ..
fi
fi

if [ "$VER_NTFSPROGS" != "" ];
then
if [ ! -e ntfsprogs-$VER_NTFSPROGS.tar.gz ];
then
	$(LYNX) http://prdownloads.sourceforge.net/linux-ntfs/ntfsprogs-$VER_NTFSPROGS.tar.gz
fi


if [ ! -e ntfsprogs-$VER_NTFSPROGS/configure ];
then
	tar xzf ntfsprogs-$VER_NTFSPROGS.tar.gz
fi

if [ ! -e ntfsprogs-$VER_NTFSPROGS/Makefile ];
then
	cd ntfsprogs-$VER_NTFSPROGS
	./configure CC=$CC
	cd ..
fi

if [ ! -e $LIBNTFS ];
then
	make -C ntfsprogs-$VER_NTFSPROGS libs
fi
fi

echo "To compile TestDisk, go in src directory, run make and follow the directives"

