/*

    File: file_txt.c

    Copyright (C) 2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "photorec.h"

static int filtre(unsigned char car);
static int header_check_txt(const unsigned char *buffer, const unsigned int buffer_size);
static int data_check_txt(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery);
const t_file_hint file_hint_txt= {
  .extension="txt",
  .description="Texte file",
  .min_header_distance=0,
  .min_filesize=100,
  .max_filesize=PHOTOREC_MAX_FILE_SIZE,
  .stream=1,	/* Avoid to split a file */
  .recover=1,
  .header_check=&header_check_txt,
  .data_check=&data_check_txt,
  .file_check=NULL
};

/* return 1 if char can be found in text file */
static int filtre(unsigned char car)
{
  switch(car)
  {
    case 0x9c:	/* '' */
    case 0xa3:	/* '' */
    case 0xa7:	/* '' */
    case 0xab: /* '' */
    case 0xb0:	/* '' */
    case 0xbb:  /* '' */
    case 0xc9:  /* '' */
    case 0xd9:  /* '' */
    case 0xe0: /* '' */
    case 0xe2: /* '' */
    case 0xe4: /* '' */
    case 0xe7: /* '' */
    case 0xe8: /* '' */
    case 0xe9: /* '' */
    case 0xea: /* '' */
    case 0xeb: /* '' */
    case 0xee: /* '' */
    case 0xef: /* '' */
    case 0xf4: /* '' */
    case 0xf6: /* '' */
    case 0xf9: /* '' */
    case 0xfb: /* '' */
    case 0xfc: /* '' */
      return 1;
  }
  return((car=='\b')||(car=='\t')||(car=='\r')||(car=='\n')
    ||((car>=' ')&&(car<='~'))
    ||((car>=0x82)&&(car<=0x8d))
    ||((car>=0x93)&&(car<=0x98))
    );
}

static int header_check_txt(const unsigned char *buffer, const unsigned int buffer_size)
{
  int i;
  for(i=0;i<buffer_size && filtre(buffer[i])==1;i++);
  return (i>=file_hint_txt.min_filesize);
}

static int data_check_txt(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery)
{
  unsigned int i;
  for(i=(buffer_size/2);i<buffer_size;i++)
  {
    /* Test for forbidden char */
    if(filtre(buffer[i])==0)
    {
      file_recovery->file_size+=i-(buffer_size/2);
      return 2;
    }
  }
  return 1;
}
