/*

    File: file_raf.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "photorec.h"

static int header_check_raf(const unsigned char *buffer, const unsigned int buffer_size);
const t_file_hint file_hint_raf= {
  .extension="raf",
  .description="Raw Fujifilm picture",
  .min_header_distance=0,
  .min_filesize=0,
  .max_filesize=PHOTOREC_MAX_FILE_SIZE,
  .stream=0,
  .recover=1,
  .header_check=&header_check_raf,
  .data_check=NULL,
  .file_check=NULL
};
static int header_check_raf(const unsigned char *buffer, const unsigned int buffer_size)
{
  /* Fuji */
  return (memcmp (buffer, "FUJIFILM", 8)==0);
}


