/*

    File: file_html.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the imhtmlied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "photorec.h"

static int header_check_html(const unsigned char *buffer, const unsigned int buffer_size);
static int data_check_html(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery);
const t_file_hint file_hint_html= {
  .extension="html",
  .description="HTML page",
  .min_header_distance=0,
  .min_filesize=0,
  .max_filesize=0,
  .stream=0,
  .recover=1,
  .header_check=&header_check_html,
  .data_check=&data_check_html,
  .file_check=NULL
};

static int header_check_html(const unsigned char *buffer, const unsigned int buffer_size)
{
  const char html_header[]  = {'<','H','T','M','L','>'};
  const char html_header_2[]  = {'<','!','D','O','C','T','Y','P','E',' ','h','t','m','l'};
  return (strncasecmp(buffer,html_header,sizeof(html_header))==0 ||
      strncasecmp(buffer,html_header_2,sizeof(html_header_2))==0);
}

static int data_check_html(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery)
{
  const char html_end_header[]  = {'<','/','H','T','M','L','>'};
  unsigned int i;
  for(i=(buffer_size/2)-sizeof(html_end_header)+1;i-sizeof(html_end_header)+1<buffer_size;i++)
  {
    if(strncasecmp(&buffer[i],html_end_header,sizeof(html_end_header))==0)
    {
      file_recovery->file_size+=i+sizeof(html_end_header)-(buffer_size/2);
      return 2;
    }
  }
  return 1;
}
