/*

    File: lvm.c

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#include <stdio.h>
#include <string.h>
#include "types.h"
#include "common.h"
#include "lvm.h"
#include "intrface.h"
#include "fnctdsk.h"
int check_LVM(t_param_disk *disk_car,t_diskext *partition,const int debug)
{
  unsigned char buffer[8*SECTOR_SIZE];
  if(disk_car->read(disk_car,8, &buffer, partition->lba)!=0)
  { return 1; }
  if(test_LVM(disk_car,(pv_disk_t *)&buffer,partition,debug,0)!=0)
    return 1;
  return 0;
}

int recover_LVM(t_param_disk *disk_car, const pv_disk_t *pv,t_diskext *partition,const int debug, const int dump_ind)
{
  if(test_LVM(disk_car,pv,partition,debug,dump_ind)!=0)
    return 1;
  partition->part_type=(unsigned char)P_LVM;
  partition->part_size=(dword)pv->pv_size;
  if(debug!=0)
  {
    ecrit_rapport("part_size %lu\n",partition->part_size);
  }
  return 0;
}

int test_LVM(t_param_disk *disk_car, const pv_disk_t *pv,t_diskext *partition,const int debug, const int dump_ind)
{
  if ((strncmp((const char *)pv->id,LVM_ID,sizeof(pv->id)) == 0) && ((pv->version == 1) || (pv->version == 2)))
  {
    uint32_t size;
    if(dump_ind!=0)
    {
      ecrit_rapport("\nLVM magic value at %u/%u/%u\n", LBA2cylinder(disk_car,partition->lba),LBA2head(disk_car,partition->lba),LBA2sector(disk_car,partition->lba));
      /* There is a little offset ... */
/*     dump(stdscr,pv,SECTOR_SIZE); */
    }
    if (pv->pv_size > LVM_MAX_SIZE)
      return (1);
    if ((pv->pv_status != 0) && (pv->pv_status != PV_ACTIVE))
      return (1);
    if ((pv->pv_allocatable != 0) && (pv->pv_allocatable != PV_ALLOCATABLE))
      return (1);
    if (pv->lv_cur > MAX_LV)
      return (1);
    if (strlen((const char *)pv->vg_name) > NAME_LEN / 2)
      return (1);
    size = pv->pe_size / LVM_MIN_PE_SIZE * LVM_MIN_PE_SIZE;
    if ((pv->pe_size != size) ||
	(pv->pe_size < LVM_MIN_PE_SIZE) ||
	(pv->pe_size > LVM_MAX_PE_SIZE))
      return (1);

    if (pv->pe_total > ( pv->pe_on_disk.size / sizeof ( disk_pe_t)))
      return (1);
    if (pv->pe_allocated > pv->pe_total)
      return (1);
    partition->upart_type=UP_LVM;
    return 0;
  }
  return 1;
}
