#!/bin/sh
FLOPPY=/dev/fd0
IMG_FLOPPY=testdisk.floppy
MNT_FLOPPY=/mnt/testdisk
MNT_INITRD=/mnt/initrd
KERNEL=/boot/vmlinuz-2.4.18-small
MY_DIR=$PWD
TERMLINUX=/usr/share/terminfo/l/linux
TESTDISK=$PWD/src/testdisk_static

BUSYBOX=busybox-0.60.4
UCLIBC=uClibc-0.9.15
UCLIBCDIR=/uclibc

# Installation of uclibc
if [ ! -e /uclibc/bin/i386-uclibc-gcc ]
then

if [ ! -e $UCLIBC.tar.bz2 ]
then
  echo "Please get $UCLIBC.tar.bz2 at http://www.uclibc.org and put it in $MY_DIR directory"
  exit 1
fi

#tar xjf $UCLIBC.tar.bz2
if [ ! -d $UCLIBCDIR ]
then 
  mkdir $UCLIBCDIR
  if [ ! -d $UCLIBCDIR ]
  then 
    echo "Creation of $UCLIBCDIR failed"
    exit 1
  fi
fi

if [ ! -d /usr/src/linux ]
then
  if [ -d /usr/src/linux-2.4 ]
  then
    ln -s /usr/src/linux-2.4 /usr/src/linux
  else
    echo "/usr/src/linux or /usr/src/linux-2.4 not found. Please install kernel source"
    exit 1
  fi
fi

cd $UCLIBC
echo "DEVEL_PREFIX = $UCLIBCDIR" > Config
grep -v "^DEVEL_PREFIX = " ./extra/Configs/Config.i386 >> Config
make && make install
cd ..
fi

# Installation of Busybox
if [ ! -e $BUSYBOX/busybox ]
then

if [ ! -e $BUSYBOX.tar.bz2 ]
then
  echo "Please get $BUSYBOX.tar.bz2 at http://www.busybox.net and put it in $MY_DIR directory"
  exit 1
fi

tar xjf $BUSYBOX.tar.bz2
cd $BUSYBOX
echo "#define BB_FEATURE_INSTALLER" >> Config.h
echo "#define BB_FEATURE_USE_TERMIOS" >> Config.h
make CC=$UCLIBCDIR/bin/i386-uclibc-gcc
cd ..
fi

if [ ! -e $KERNEL ]
then
  echo "Please redefine KERNEL in the script"
  exit 1
fi

if [ ! -e $TERMLINUX ]
then
  echo "Please redefine TERMLINUX in the script"
fi

if [ ! -e $TESTDISK ]
then
  cd src
  make linuxstatic
  if [ ! -e $TESTDISK ]
  then
    exit 1
  fi
fi



if [ ! -d $MNT_FLOPPY ]
then 
  mkdir $MNT_FLOPPY
  if [ ! -d $MNT_FLOPPY ]
  then 
    echo "Creation of $MNT_FLOPPY failed"
    exit 1
  fi
fi

if [ ! -d $MNT_INITRD ]
then 
  mkdir $MNT_INITRD
  if [ ! -d $MNT_INITRD ]
  then 
    echo "Creation of $MNT_INITRD failed"
    exit 1
  fi
fi

mkfs -t vfat -n "TESTDISK" $FLOPPY
syslinux $FLOPPY
dd if=$FLOPPY of=$IMG_FLOPPY bs=512k


mount -o loop $IMG_FLOPPY $MNT_FLOPPY

cp $KERNEL $MNT_FLOPPY/vmlinuz

cat << EOF > $MNT_FLOPPY/syslinux.cfg
default testdisk
display testdisk.msg

label testdisk
  kernel vmlinuz
  append initrd=initrd.gz root=/dev/fd0
EOF

cat << EOF > $MNT_FLOPPY/testdisk.msg
Welcome to TestDisk rescue boot disk
EOF

dd if=/dev/zero of=initrd bs=1k count=4096

mke2fs -Fm0 initrd 4096
mount -o loop initrd $MNT_INITRD
cd $MNT_INITRD
mkdir dev etc lib mnt mnt/fd0 proc bin sbin usr usr/bin usr/lib usr/sbin var var/log var/db var/run var/state .$UCLIBCDIR

cd dev
mknod -m 660 console c 5 1
mknod -m 664 fd0 b 2 0
mknod -m 666 null c 1 3
mknod -m 640 ram b 1 1
mknod -m 666 tty c 5 0
mknod -m 600 tty0 c 4 0
mknod -m 666 zero c 1 5
mknod -m 660 hda b 3 0
mknod -m 660 hdb b 3 64
mknod -m 660 hdc b 22 0
mknod -m 660 hdd b 22 64
mknod -m 660 sda b 8 0
mknod -m 660 sdb b 8 16
mknod -m 660 sdc b 8 32
mknod -m 660 sdd b 8 48

cd $MNT_INITRD/bin
ln -s busybox sh

cd $MY_DIR
tar cvf - $BUSYBOX/busybox | tar x -C $MNT_INITRD/bin

cd $UCLIBCDIR
tar cvf - lib/ld-uClibc* lib/libc.so* lib/libuClibc* | tar x -C $MNT_INITRD/$UCLIBCDIR

cat << EOF > $MNT_INITRD/linuxrc
#!/bin/sh
PATH="/bin:/sbin:/usr/bin:/usr/sbin"
TERM=linux
ignoreeof=10
no_exit_on_failed_exec=yes
export PATH TERM ignoreeof
umask 022
/bin/busybox mount -t proc /proc /proc
/bin/busybox -install -s
mount -t vfat /dev/fd0 /mnt/fd0
[ -f /mnt/fd0/testdisk.ini ] && cat /mnt/fd0/testdisk.ini > /testdisk.ini
[ -f /testdisk.ini ] && chmod 777 /testdisk.ini
[ -f /testdisk.ini ] && /testdisk.ini
exec sh
EOF
chmod 777 $MNT_INITRD/linuxrc

cp $TERMLINUX $MNT_INITRD
cp $TESTDISK $MNT_INITRD

cat << EOF > $MNT_INITRD/testdisk.ini
#!/bin/sh
export TERMINFO=/
cd /mnt/fd0
/testdisk_static
EOF
chmod 777 $MNT_INITRD/testdisk.ini

cd $MY_DIR
umount $MNT_INITRD
gzip -9f initrd
cp initrd.gz $MNT_FLOPPY
umount $MNT_FLOPPY
dd if=testdisk.floppy of=$FLOPPY bs=512k
