/***************************************************************************
                          tea_gtk_utils.c  -  description
                             -------------------
    begin                : aug. 2004
    copyright            : (C) 2004, 2005 by Peter 'Roxton' Semiletov
    email                : roxton@ua.fm
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef HAVE_LIBASPELL

#include <glib.h>
#include "aspell.h"


GList* get_speller_modules_list (gchar *default_lang)
{
  gchar *lang;
  if (! default_lang)
     lang = g_strdup ("C");
  else 
      lang = g_strdup (default_lang); 

  GList *l = NULL; 
  AspellDictInfoList *dlist;
  AspellDictInfoEnumeration *dels;
  const AspellDictInfo *entry;
  AspellConfig *config;

  config = new_aspell_config ();
  aspell_config_replace (config, "lang", lang); 
  aspell_config_replace (config, "encoding", "UTF-8"); 

  dlist = get_aspell_dict_info_list (config);

  delete_aspell_config(config);

  dels = aspell_dict_info_list_elements(dlist);

  while ((entry = aspell_dict_info_enumeration_next(dels)) != 0) 
        if (entry)
           l = g_list_prepend (l, g_strdup (entry->name)); 	 

  delete_aspell_dict_info_enumeration(dels);
  g_free (lang);

  return l;  
}

#endif
