#include "tzipper.h"
#include "utils.h"


//including a gunzip snippet from OSDaB
//by Angius Fabrizio


bool CZipper::zip_directory (const QString &archpath, const QString &dir2pack)
{
  QString archname = qstring_get_last_after (dir2pack, "/");
 
  QString zipname (archpath); //zip name has a full path ending with .zip
  zipname.append ("/").append (archname).append (".zip");

  QuaZip zip (zipname);

  if (! zip.open (QuaZip::mdCreate))
     return false;

  QDir dir (dir2pack);

  QFileInfoList files = dir.entryInfoList();
  QFile inFile;
  QuaZipFile outFile(&zip);

  foreach (QFileInfo file, files)
          {
           if (! file.isFile())
              continue;

           inFile.setFileName (file.absoluteFilePath());

           if (! inFile.open (QIODevice::ReadOnly))
              return false;

           QString outfname (archname);
           outfname.append ("/").append (file.fileName());

           if (! outFile.open (QIODevice::WriteOnly, QuaZipNewInfo (outfname, inFile.fileName())))
               return false;

           QByteArray ba = inFile.readAll();
           outFile.write (ba);

           outFile.close();
          
           if (outFile.getZipError() != UNZ_OK)
              return false;

           inFile.close();
          
           emit new_iteration (file);
          }
  
  zip.close();

  if (zip.getZipError() != 0) 
     return false;
  
  return true;
}


bool CZipper::read_as_utf8 (const QString &archname, const QString &fname)
{
  QuaZip zip (archname);

  if (! zip.open (QuaZip::mdUnzip))
      return false;

  zip.setFileNameCodec ("IBM866");

  zip.setCurrentFile (fname);
  if (! zip.hasCurrentFile())
      return false;

  QuaZipFileInfo info;
  if (! zip.getCurrentFileInfo (&info))
     return false;

  QuaZipFile file (&zip);

  if (! file.open (QIODevice::ReadOnly)) 
      return false;

  QByteArray ba = file.readAll();

  string_data = QString::fromUtf8 (ba.data());

  file.close();
  zip.close();

  return true;
}


//a snippet from OSDaB
//by Angius Fabrizio
QByteArray gzip_deflateFile (const QString &fileName)
{
  gzFile gzDoc;
  char buff[4097];
  int i;
  QByteArray fname = fileName.toLatin1();

  gzDoc = gzopen(fname.constData(), "rb");
  if (! gzDoc)
     return QByteArray();

  QByteArray data;

  while ((i = gzread (gzDoc, &buff, 4096)) > 0)
        { 
         buff[i] = '\0'; 
         data.append (buff); 
        }

  gzclose(gzDoc);

  return data;
}


bool CZipper::pack_prepared()
{
  if (archive_fullpath.isEmpty())
     return false;
  
  QString zipname (archive_fullpath);
  QuaZip zip (zipname);

  if (! zip.open (QuaZip::mdCreate))
      return false;

  QFile inFile;
  QuaZipFile outFile (&zip);

  foreach (QString fi, files_list)
          {
           QFileInfo file (fi);
           
           if (! file.isFile())
              continue;

           inFile.setFileName (file.absoluteFilePath());

           if (! inFile.open (QIODevice::ReadOnly))
               return false;

           QString outfname (archive_name);
           outfname.append ("/").append (file.fileName());

           if (! outFile.open (QIODevice::WriteOnly, QuaZipNewInfo (outfname, inFile.fileName())))
               return false;

           QByteArray ba = inFile.readAll();
           outFile.write (ba);

           outFile.close();
           
           if (outFile.getZipError() != UNZ_OK)
               return false;

           inFile.close();

           emit new_iteration (file);
         }

  zip.close();

  if (zip.getZipError() != 0)
     return false;
     
  return true;
}
