/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.LimitInputStream;

class RawToBinaryFormatStream
extends LimitInputStream {
    private int dummyBytes = 4;
    private boolean eof = false;

    RawToBinaryFormatStream(InputStream inputStream, int n) {
        super(inputStream);
        if (n >= 0) {
            this.setLimit(n);
        }
    }

    public int read() throws IOException {
        if (this.eof) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S"));
        }
        if (this.dummyBytes != 0) {
            --this.dummyBytes;
            return 0;
        }
        int n = super.read();
        if (n < 0) {
            this.checkSufficientData();
        }
        return n;
    }

    private void checkSufficientData() throws IOException {
        this.eof = true;
        if (!this.limitInPlace) {
            return;
        }
        int n = this.clearLimit();
        if (n > 0) {
            throw new IOException(MessageService.getTextMessage("XJ023.S"));
        }
        if (n == 0) {
            int n2;
            try {
                n2 = super.read();
            }
            catch (IOException iOException) {
                n2 = -1;
            }
            if (n2 >= 0) {
                throw new IOException(MessageService.getTextMessage("XJ023.S"));
            }
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.eof) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S"));
        }
        int n4 = this.dummyBytes;
        if (n4 != 0) {
            if (n2 < n4) {
                n4 = n2;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                byArray[n + n3] = 0;
            }
            this.dummyBytes -= n4;
            n += n4;
            n2 -= n4;
        }
        if ((n3 = super.read(byArray, n, n2)) < 0) {
            if (n4 != 0) {
                return n4;
            }
            this.checkSufficientData();
            return n3;
        }
        return n4 + n3;
    }
}

