/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.Metric;
import edu.uoregon.tau.paraprof.PPML;
import edu.uoregon.tau.paraprof.ParaProfManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PPMLPanel
extends JPanel
implements ActionListener {
    ParaProfManager paraProfManager = null;
    JTextField arg1Field = new JTextField("Argument 1 (x:x:x:x)", 30);
    JTextField arg2Field = new JTextField("Argument 2 (x:x:x:x)", 30);
    String[] operationStrings = new String[]{"Add", "Subtract", "Multiply", "Divide"};
    JComboBox operation = new JComboBox<String>(this.operationStrings);

    public PPMLPanel(ParaProfManager paraProfManager) {
        this.paraProfManager = paraProfManager;
        int n = 800;
        int n2 = 200;
        this.setSize(new Dimension(n, n2));
        this.arg1Field.setEditable(false);
        this.arg2Field.setEditable(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(new JLabel("Argument 1:"), gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.arg1Field, gridBagConstraints, 1, 0, 2, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(new JLabel("Argument 2:"), gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.arg2Field, gridBagConstraints, 1, 1, 2, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.operation, gridBagConstraints, 1, 2, 1, 1);
        JButton jButton = new JButton("Apply operation");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 2, 2, 1, 1);
    }

    public void setArg1Field(String string) {
        this.arg1Field.setText(string);
    }

    public String getArg1Field() {
        return this.arg1Field.getText().trim();
    }

    public void setArg2Field(String string) {
        this.arg2Field.setText(string);
    }

    public String getArg2Field() {
        return this.arg2Field.getText().trim();
    }

    public void applyOperation() {
        String string = this.getArg2Field();
        Metric metric = null;
        metric = string.indexOf("val") != -1 ? PPML.applyOperation(this.paraProfManager.getOperand1(), string, (String)this.operation.getSelectedItem()) : PPML.applyOperation(this.paraProfManager.getOperand1(), this.paraProfManager.getOperand2(), (String)this.operation.getSelectedItem());
        if (metric != null) {
            if (metric.getTrial().dBTrial()) {
                this.paraProfManager.uploadMetric(metric);
            }
            this.paraProfManager.populateTrialMetrics(metric.getTrial());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Apply operation")) {
                this.applyOperation();
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"DBC02");
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"DBC03");
        }
    }
}

