/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.MappingLedgerWindowPanel;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageOutput;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MappingLedgerWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer {
    private ParaProfTrial trial = null;
    private int windowType = -1;
    private JMenu windowsMenu = null;
    private Container contentPane = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;
    private JScrollPane sp = null;
    private MappingLedgerWindowPanel panel = null;
    private Vector list = null;
    private boolean debug = false;

    public MappingLedgerWindow() {
        try {
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(350, 450));
            this.setTitle("Wrong constructor used");
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MLW01");
        }
    }

    public MappingLedgerWindow(ParaProfTrial paraProfTrial, int n, boolean bl) {
        try {
            this.trial = paraProfTrial;
            this.windowType = n;
            this.debug = bl;
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(350, 450));
            switch (n) {
                case 0: {
                    this.setTitle("Function Ledger Window: " + paraProfTrial.getTrialIdentifier(true));
                    break;
                }
                case 1: {
                    this.setTitle("Group Ledger Window: " + paraProfTrial.getTrialIdentifier(true));
                    break;
                }
                case 2: {
                    this.setTitle("User Event Window: " + paraProfTrial.getTrialIdentifier(true));
                    break;
                }
                default: {
                    UtilFncs.systemError(null, null, (String)("Unexpected window type - MLW02 value: " + n));
                }
            }
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MappingLedgerWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (ParaProf.helpWindow.isVisible()) {
                this.help(false);
            }
            this.sortLocalData();
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = null;
            JMenuItem jMenuItem = null;
            JMenu jMenu2 = new JMenu("File");
            jMenu = new JMenu("Open ...");
            jMenuItem = new JMenuItem("ParaProf Manager");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Bin Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenu2.add(jMenu);
            jMenu = new JMenu("Save ...");
            jMenuItem = new JMenuItem("ParaProf Preferrences");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save Image");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenu2.add(jMenu);
            jMenuItem = new JMenuItem("Edit ParaProf Preferences!");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenuItem = new JMenuItem("Print");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenuItem = new JMenuItem("Exit ParaProf!");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenu2.addMenuListener(this);
            this.windowsMenu = new JMenu("Windows");
            jMenuItem = new JMenuItem("Show Function Ledger");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Group Ledger");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Show User Event Ledger");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Call Path Relations");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Close All Sub-Windows");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            this.windowsMenu.addMenuListener(this);
            JMenu jMenu3 = new JMenu("Help");
            jMenuItem = new JMenuItem("Show Help Window");
            jMenuItem.addActionListener(this);
            jMenu3.add(jMenuItem);
            jMenuItem = new JMenuItem("About ParaProf");
            jMenuItem.addActionListener(this);
            jMenu3.add(jMenuItem);
            jMenu3.addMenuListener(this);
            jMenuBar.add(jMenu2);
            jMenuBar.add(this.windowsMenu);
            jMenuBar.add(jMenu3);
            this.setJMenuBar(jMenuBar);
            this.contentPane = this.getContentPane();
            this.gbl = new GridBagLayout();
            this.contentPane.setLayout(this.gbl);
            this.gbc = new GridBagConstraints();
            this.gbc.insets = new Insets(5, 5, 5, 5);
            this.panel = new MappingLedgerWindowPanel(paraProfTrial, this, n, this.debug());
            this.sp = new JScrollPane(this.panel);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 1.0;
            this.addCompItem(this.sp, this.gbc, 0, 0, 1, 1);
            paraProfTrial.getSystemEvents().addObserver(this);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MLW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Print")) {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    PageFormat pageFormat = printerJob.defaultPage();
                    PageFormat pageFormat2 = printerJob.pageDialog(pageFormat);
                    printerJob.setPrintable(this.panel, pageFormat2);
                    if (printerJob.printDialog()) {
                        printerJob.print();
                    }
                } else if (string.equals("Edit ParaProf Preferences!")) {
                    this.trial.getPreferences().showPreferencesWindow();
                } else if (string.equals("Save Image")) {
                    ParaProfImageOutput paraProfImageOutput = new ParaProfImageOutput();
                    paraProfImageOutput.saveImage(this.panel);
                } else if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit ParaProf!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                } else if (string.equals("Show Function Ledger")) {
                    new MappingLedgerWindow(this.trial, 0, this.debug()).show();
                } else if (string.equals("Show Group Ledger")) {
                    new MappingLedgerWindow(this.trial, 1, this.debug()).show();
                } else if (string.equals("Show User Event Ledger")) {
                    new MappingLedgerWindow(this.trial, 2, this.debug()).show();
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    this.help(true);
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW03");
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.trial.groupNamesPresent()) {
                this.windowsMenu.getItem(1).setEnabled(true);
            } else {
                this.windowsMenu.getItem(1).setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.windowsMenu.getItem(2).setEnabled(true);
            } else {
                this.windowsMenu.getItem(2).setEnabled(false);
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW04");
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.panel.repaint();
            } else if (string.equals("colorEvent")) {
                this.panel.repaint();
            } else if (string.equals("dataEvent")) {
                this.sortLocalData();
                this.panel.repaint();
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW05");
        }
    }

    private void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        if (this.windowType == 0) {
            ParaProf.helpWindow.writeText("This is the function ledger window.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("This window shows all the functions tracked in this profile.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("To see more information about any of the mappings shown here,");
            ParaProf.helpWindow.writeText("right click on that function, and select from the popup menu.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
        } else if (this.windowType == 1) {
            ParaProf.helpWindow.writeText("This is the group ledger window.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("This window shows all the groups tracked in this profile.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("Left click any group to hightlight it in the system.");
            ParaProf.helpWindow.writeText("Right click on any group, and select from the popup menu to display more options for masking or displaying functions in a particular group.");
        } else {
            ParaProf.helpWindow.writeText("This is the user event ledger window.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("This window shows all the user events tracked in this profile.");
            ParaProf.helpWindow.writeText("");
            ParaProf.helpWindow.writeText("Left click any mapping to hightlight it in the system.");
            ParaProf.helpWindow.writeText("Right click on any user event, and select from the popup menu.");
        }
    }

    private void sortLocalData() {
        this.list = this.trial.getGlobalMapping().getMapping(this.windowType);
    }

    public Vector getData() {
        return this.list;
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MLW03");
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (this.debug()) {
                System.out.println("------------------------");
                System.out.println("A Mapping Ledger Window for window type: " + this.windowType + " is closing");
                System.out.println("Clearing resourses for that window.");
            }
            ((Component)this).setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW10");
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

