/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ParaProfImageFormatFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class ParaProfImageOptionsPanel
extends JPanel
implements PropertyChangeListener {
    private Component component = null;
    private JCheckBox fullScreen = new JCheckBox("Full Screen");
    private JCheckBox prependHeader = new JCheckBox("Prepend Header");
    private JLabel imageQualityLabel = new JLabel("Image Quality");
    private String[] imageQualityStrings = new String[]{"1.0", "0.75", "0.5", "0.25", "0.15", "0.1"};
    private JComboBox imageQuality = new JComboBox<String>(this.imageQualityStrings);
    private boolean imageQualityEnabled = true;

    public ParaProfImageOptionsPanel(Component component) {
        try {
            this.component = component;
            int n = 200;
            int n2 = 500;
            this.setSize(new Dimension(n, n2));
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.fullScreen, gridBagConstraints, 0, 0, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.prependHeader, gridBagConstraints, 0, 1, 1, 1);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.imageQualityLabel, gridBagConstraints, 0, 2, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(this.imageQuality, gridBagConstraints, 1, 2, 1, 1);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"PPIOP01");
        }
    }

    public boolean isFullScreen() {
        return this.fullScreen.isSelected();
    }

    public boolean isPrependHeader() {
        return this.prependHeader.isSelected();
    }

    public float getImageQuality() {
        return Float.valueOf((String)this.imageQuality.getSelectedItem()).floatValue();
    }

    public boolean imageQualityEnabled() {
        return this.imageQualityEnabled;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JFileChooser jFileChooser;
        FileFilter fileFilter;
        Object object;
        if (propertyChangeEvent.getPropertyName().equals("fileFilterChanged") && (object = propertyChangeEvent.getSource()) instanceof JFileChooser && (fileFilter = (jFileChooser = (JFileChooser)object).getFileFilter()) instanceof ParaProfImageFormatFileFilter) {
            String string = ((ParaProfImageFormatFileFilter)fileFilter).getExtension();
            if (string.equals(ParaProfImageFormatFileFilter.PNG)) {
                this.imageQuality.setEnabled(false);
                this.imageQualityEnabled = false;
            } else {
                this.imageQuality.setEnabled(true);
                this.imageQualityEnabled = true;
            }
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"PPIOP02");
        }
    }
}

