/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.Mapping;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.CallPathDrawObject;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.MappingDataWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.SMWThreadDataElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class CallPathTextWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ParaProfImageInterface {
    int xPanelSize = 800;
    int yPanelSize = 600;
    boolean calculatePanelSize = true;
    int nodeID = -1;
    int contextID = -1;
    int threadID = -1;
    private ParaProfTrial trial = null;
    CallPathTextWindow cPTWindow = null;
    int windowType = 0;
    Font monoFont = null;
    FontMetrics fmMonoFont = null;
    Vector drawObjectsComplete = null;
    Vector drawObjects = null;
    int startLocation = 0;
    int maxFontAscent = 0;
    int maxFontDescent = 0;
    int spacing = 0;
    int check = 0;
    int base = 0;
    int startPosition = 0;
    int stringWidth = 0;
    int numCallsWidth = 0;
    int excPos = 0;
    int incPos = 0;
    int callsPos1 = 0;
    int callsPos2 = 0;
    int namePos = 0;
    double max = 0.0;
    int yHeightNeeded = 0;
    int xWidthNeeded = 0;
    int length = 0;
    private JPopupMenu popup = new JPopupMenu();
    private Object clickedOnObject = null;
    private int lastHeaderEndPosition = 0;
    private boolean debug = false;

    public CallPathTextWindowPanel(ParaProfTrial paraProfTrial, int n, int n2, int n3, CallPathTextWindow callPathTextWindow, int n4, boolean bl) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.nodeID = n;
            this.contextID = n2;
            this.threadID = n3;
            this.trial = paraProfTrial;
            this.cPTWindow = callPathTextWindow;
            this.windowType = n4;
            this.debug = bl;
            this.repaint();
            this.addMouseListener(this);
            JMenuItem jMenuItem = new JMenuItem("Show Function Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem("Find Function");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem("Change Function Color");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            jMenuItem = new JMenuItem("Reset to Generic Color");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"CPTWP01");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, 0, false);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDWP03");
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (pageFormat.getOrientation() == 1) {
            System.out.println("PORTRAIT");
        } else if (pageFormat.getOrientation() == 0) {
            System.out.println("LANDSCAPE");
        }
        if (n >= 3) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        this.renderIt(graphics2D, 2, false);
        return 0;
    }

    public void renderIt(Graphics2D graphics2D, int n, boolean bl) {
        try {
            int n2 = ParaProf.defaultNumberPrecision;
            int n3 = 0;
            int n4 = this.trial.getPreferences().getBarHeight();
            this.spacing = this.trial.getPreferences().getBarSpacing();
            this.monoFont = new Font("Monospaced", this.trial.getPreferences().getFontStyle(), n4);
            this.fmMonoFont = graphics2D.getFontMetrics(this.monoFont);
            this.maxFontAscent = this.fmMonoFont.getMaxAscent();
            this.maxFontDescent = this.fmMonoFont.getMaxDescent();
            graphics2D.setFont(this.monoFont);
            if (this.spacing <= this.maxFontAscent + this.maxFontDescent) {
                ++this.spacing;
            }
            if (this.windowType == 0) {
                Object object;
                int n5;
                int n6;
                ListIterator listIterator = null;
                ListIterator listIterator2 = null;
                ListIterator listIterator3 = null;
                GlobalMapping globalMapping = this.trial.getGlobalMapping();
                Integer n7 = null;
                Object var12_23 = null;
                Object var13_26 = null;
                Object var14_29 = null;
                Object var15_32 = null;
                SMWThreadDataElement sMWThreadDataElement = null;
                CallPathDrawObject callPathDrawObject = null;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                if (this.drawObjectsComplete == null) {
                    this.drawObjectsComplete = new Vector();
                    this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    listIterator = this.cPTWindow.getDataIterator();
                    while (listIterator.hasNext()) {
                        GlobalMappingElement globalMappingElement;
                        int n8;
                        sMWThreadDataElement = (SMWThreadDataElement)listIterator.next();
                        if (sMWThreadDataElement.isCallPathObject()) continue;
                        listIterator2 = sMWThreadDataElement.getParentsIterator();
                        while (listIterator2.hasNext()) {
                            n7 = (Integer)listIterator2.next();
                            listIterator3 = sMWThreadDataElement.getCallPathIDParents(n7);
                            d = 0.0;
                            d2 = 0.0;
                            d3 = 0.0;
                            while (listIterator3.hasNext()) {
                                n8 = (Integer)listIterator3.next();
                                globalMappingElement = globalMapping.getGlobalMappingElement(n8, 0);
                                d += globalMappingElement.getMeanExclusiveValue(this.trial.getSelectedMetricID());
                                d2 += globalMappingElement.getMeanInclusiveValue(this.trial.getSelectedMetricID());
                                d3 += globalMappingElement.getMeanNumberOfCalls();
                            }
                            callPathDrawObject = new CallPathDrawObject((Mapping)globalMapping.getGlobalMappingElement(n7.intValue(), 0), true, false, false);
                            callPathDrawObject.setExclusiveValue(d);
                            callPathDrawObject.setInclusiveValue(d2);
                            callPathDrawObject.setNumberOfCallsFromCallPathObjects(d3);
                            callPathDrawObject.setNumberOfCalls(sMWThreadDataElement.getMeanNumberOfCalls());
                            this.drawObjectsComplete.add(callPathDrawObject);
                        }
                        callPathDrawObject = new CallPathDrawObject((Mapping)globalMapping.getGlobalMappingElement(sMWThreadDataElement.getMappingID(), 0), false, false, false);
                        callPathDrawObject.setExclusiveValue(sMWThreadDataElement.getMeanExclusiveValue());
                        callPathDrawObject.setInclusiveValue(sMWThreadDataElement.getMeanInclusiveValue());
                        callPathDrawObject.setNumberOfCalls(sMWThreadDataElement.getMeanNumberOfCalls());
                        this.drawObjectsComplete.add(callPathDrawObject);
                        listIterator2 = sMWThreadDataElement.getChildrenIterator();
                        while (listIterator2.hasNext()) {
                            n7 = (Integer)listIterator2.next();
                            listIterator3 = sMWThreadDataElement.getCallPathIDChildren(n7);
                            d = 0.0;
                            d2 = 0.0;
                            d3 = 0.0;
                            while (listIterator3.hasNext()) {
                                n8 = (Integer)listIterator3.next();
                                globalMappingElement = globalMapping.getGlobalMappingElement(n8, 0);
                                d += globalMappingElement.getMeanExclusiveValue(this.trial.getSelectedMetricID());
                                d2 += globalMappingElement.getMeanInclusiveValue(this.trial.getSelectedMetricID());
                                d3 += globalMappingElement.getMeanNumberOfCalls();
                            }
                            callPathDrawObject = new CallPathDrawObject((Mapping)globalMapping.getGlobalMappingElement(n7.intValue(), 0), false, true, false);
                            callPathDrawObject.setExclusiveValue(d);
                            callPathDrawObject.setInclusiveValue(d2);
                            callPathDrawObject.setNumberOfCallsFromCallPathObjects(d3);
                            callPathDrawObject.setNumberOfCalls(globalMapping.getGlobalMappingElement(n7.intValue(), 0).getMeanNumberOfCalls());
                            this.drawObjectsComplete.add(callPathDrawObject);
                        }
                        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    }
                }
                if (this.drawObjects == null) {
                    this.drawObjects = new Vector();
                    Vector<CallPathDrawObject> vector = new Vector<CallPathDrawObject>();
                    boolean bl2 = false;
                    n6 = -1;
                    n5 = -1;
                    if (this.cPTWindow.showCollapsedView()) {
                        object = this.drawObjectsComplete.elements();
                        block31: while (object.hasMoreElements()) {
                            callPathDrawObject = (CallPathDrawObject)object.nextElement();
                            n6 = callPathDrawObject.isSpacer() ? 0 : (callPathDrawObject.isParent() ? (bl2 ? 1 : 2) : (callPathDrawObject.isChild() ? (bl2 ? 3 : 4) : (bl2 ? 5 : 6)));
                            switch (n6) {
                                case 0: {
                                    this.drawObjects.add(callPathDrawObject);
                                    continue block31;
                                }
                                case 1: {
                                    bl2 = false;
                                    vector.add(callPathDrawObject);
                                    continue block31;
                                }
                                case 2: {
                                    vector.add(callPathDrawObject);
                                    continue block31;
                                }
                                case 3: {
                                    this.drawObjects.add(callPathDrawObject);
                                    continue block31;
                                }
                                case 5: {
                                    int n9;
                                    n5 = vector.size();
                                    for (n9 = 0; n9 < n5; ++n9) {
                                        this.drawObjects.add(vector.elementAt(n9));
                                    }
                                    vector.clear();
                                    this.drawObjects.add(callPathDrawObject);
                                    if (callPathDrawObject.isExpanded()) {
                                        bl2 = true;
                                        continue block31;
                                    }
                                    bl2 = false;
                                    continue block31;
                                }
                                case 6: {
                                    int n9;
                                    if (callPathDrawObject.isExpanded()) {
                                        n5 = vector.size();
                                        for (n9 = 0; n9 < n5; ++n9) {
                                            this.drawObjects.add(vector.elementAt(n9));
                                        }
                                        vector.clear();
                                        bl2 = true;
                                    } else {
                                        vector.clear();
                                    }
                                    this.drawObjects.add(callPathDrawObject);
                                    continue block31;
                                }
                            }
                            if (!this.debug()) continue;
                            System.out.println("In default state (CPTWP). State is: " + n6);
                        }
                    } else {
                        this.drawObjects = this.drawObjectsComplete;
                    }
                }
                if (this.calculatePanelSize()) {
                    Enumeration enumeration = this.drawObjects.elements();
                    while (enumeration.hasMoreElements()) {
                        callPathDrawObject = (CallPathDrawObject)enumeration.nextElement();
                        this.yHeightNeeded += this.spacing;
                        this.max = this.setMax(this.max, callPathDrawObject.getExclusiveValue(), callPathDrawObject.getInclusiveValue());
                        if (callPathDrawObject.isSpacer()) continue;
                        this.length = this.fmMonoFont.stringWidth(callPathDrawObject.getMappingName()) + 10;
                        if (this.xWidthNeeded >= this.length) continue;
                        this.xWidthNeeded = this.length;
                    }
                    this.base = 20;
                    this.startPosition = this.fmMonoFont.stringWidth("--> ") + this.base;
                    this.stringWidth = this.fmMonoFont.stringWidth(UtilFncs.getOutputString((int)this.cPTWindow.units(), (double)this.max, (int)n2)) + 10;
                    this.check = this.fmMonoFont.stringWidth("Exclusive");
                    if (this.stringWidth < this.check) {
                        this.stringWidth = this.check + 5;
                    }
                    this.numCallsWidth = this.fmMonoFont.stringWidth(Double.toString(globalMapping.getMaxMeanNumberOfCalls())) + 10;
                    this.check = this.fmMonoFont.stringWidth("Calls/Tot.Calls");
                    if (this.numCallsWidth < this.check) {
                        this.numCallsWidth = this.check + 5;
                    }
                    this.excPos = this.startPosition;
                    this.incPos = this.excPos + this.stringWidth;
                    this.callsPos1 = this.incPos + this.stringWidth;
                    this.callsPos2 = this.callsPos1 + this.numCallsWidth;
                    this.namePos = this.callsPos2 + this.numCallsWidth;
                    this.xWidthNeeded = this.xWidthNeeded + this.namePos + 20;
                    boolean bl3 = false;
                    if (this.xWidthNeeded > this.xPanelSize) {
                        this.xPanelSize = this.xWidthNeeded + 10;
                        bl3 = true;
                    }
                    if (this.yHeightNeeded > this.yPanelSize) {
                        this.yPanelSize = this.yHeightNeeded + 10;
                        bl3 = true;
                    }
                    if (bl3 && n == 0) {
                        this.revalidate();
                    }
                    this.setCalculatePanelSize(false);
                }
                int n10 = 0;
                int n11 = 0;
                n6 = 0;
                n5 = 0;
                object = null;
                Rectangle rectangle = null;
                if (n == 0 || n == 1) {
                    if (n == 0) {
                        object = graphics2D.getClipBounds();
                        n10 = (int)((Rectangle)object).getY();
                        n11 = (int)((double)n10 + ((Rectangle)object).getHeight());
                    } else {
                        rectangle = this.cPTWindow.getViewRect();
                        n10 = (int)rectangle.getY();
                        n11 = (int)((double)n10 + rectangle.getHeight());
                    }
                    n6 = (n10 - n3) / this.spacing - 1;
                    n5 = (n11 - n3) / this.spacing + 1;
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n6 > this.drawObjects.size() - 1) {
                        n6 = this.drawObjects.size() - 1;
                    }
                    if (n5 > this.drawObjects.size() - 1) {
                        n5 = this.drawObjects.size() - 1;
                    }
                    if (n == 0) {
                        n3 += n6 * this.spacing;
                    }
                } else if (n == 2 || n == 3) {
                    n6 = 0;
                    n5 = this.drawObjects.size() - 1;
                }
                graphics2D.setColor(Color.black);
                if (bl) {
                    n3 += this.spacing;
                    String string = this.cPTWindow.getHeaderString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
                    while (stringTokenizer.hasMoreTokens()) {
                        graphics2D.drawString(stringTokenizer.nextToken(), 15, n3);
                        n3 += this.spacing;
                    }
                    this.lastHeaderEndPosition = n3;
                }
                for (int i = n6; i <= n5; ++i) {
                    callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(i);
                    if (i == 1) {
                        graphics2D.drawString("Exclusive", this.excPos, n3);
                        graphics2D.drawString("Inclusive", this.incPos, n3);
                        graphics2D.drawString("Calls/Tot.Calls", this.callsPos1, n3);
                        graphics2D.drawString("Name[id]", this.namePos, n3);
                        n3 += this.spacing;
                        continue;
                    }
                    if (i == 2) {
                        graphics2D.drawString("--------------------------------------------------------------------------------", this.excPos, n3);
                        n3 += this.spacing;
                        continue;
                    }
                    if (!callPathDrawObject.isParentChild() && !callPathDrawObject.isSpacer()) {
                        graphics2D.drawString("--> ", this.base, n3);
                        graphics2D.drawString(UtilFncs.getOutputString((int)this.cPTWindow.units(), (double)callPathDrawObject.getExclusiveValue(), (int)ParaProf.defaultNumberPrecision), this.excPos, n3);
                        graphics2D.drawString(UtilFncs.getOutputString((int)this.cPTWindow.units(), (double)callPathDrawObject.getInclusiveValue(), (int)ParaProf.defaultNumberPrecision), this.incPos, n3);
                        graphics2D.drawString(Double.toString(callPathDrawObject.getNumberOfCalls()), this.callsPos1, n3);
                        int n12 = callPathDrawObject.getMappingID();
                        if (this.trial.getColorChooser().getHighlightColorID() == n12) {
                            graphics2D.setColor(Color.red);
                            graphics2D.drawString(callPathDrawObject.getMappingName() + "[" + n12 + "]", this.namePos, n3);
                            graphics2D.setColor(Color.black);
                        } else {
                            graphics2D.drawString(callPathDrawObject.getMappingName() + "[" + n12 + "]", this.namePos, n3);
                        }
                        n3 += this.spacing;
                        continue;
                    }
                    if (callPathDrawObject.isSpacer()) {
                        n3 += this.spacing;
                        continue;
                    }
                    graphics2D.drawString(UtilFncs.getOutputString((int)this.cPTWindow.units(), (double)callPathDrawObject.getExclusiveValue(), (int)ParaProf.defaultNumberPrecision), this.excPos, n3);
                    graphics2D.drawString(UtilFncs.getOutputString((int)this.cPTWindow.units(), (double)callPathDrawObject.getInclusiveValue(), (int)ParaProf.defaultNumberPrecision), this.incPos, n3);
                    graphics2D.drawString(callPathDrawObject.getNumberOfCallsFromCallPathObjects() + "/" + callPathDrawObject.getNumberOfCalls(), this.callsPos1, n3);
                    int n13 = callPathDrawObject.getMappingID();
                    if (this.trial.getColorChooser().getHighlightColorID() == n13) {
                        graphics2D.setColor(Color.red);
                        graphics2D.drawString(callPathDrawObject.getMappingName() + "[" + callPathDrawObject.getMappingID() + "]", this.namePos, n3);
                        graphics2D.setColor(Color.black);
                    } else {
                        graphics2D.drawString(callPathDrawObject.getMappingName() + "[" + callPathDrawObject.getMappingID() + "]", this.namePos, n3);
                    }
                    n3 += this.spacing;
                }
            } else if (this.windowType == 1) {
                Object object;
                int n14;
                int n15;
                int n16;
                ListIterator listIterator = null;
                ListIterator listIterator4 = null;
                ListIterator listIterator5 = null;
                GlobalMapping globalMapping = this.trial.getGlobalMapping();
                Integer n17 = null;
                Object var12_24 = null;
                Thread thread = null;
                Vector vector = null;
                GlobalThreadDataElement globalThreadDataElement = null;
                SMWThreadDataElement sMWThreadDataElement = null;
                CallPathDrawObject callPathDrawObject = null;
                double d = 0.0;
                double d4 = 0.0;
                int n18 = 0;
                thread = this.trial.getNCT().getThread(this.nodeID, this.contextID, this.threadID);
                vector = thread.getFunctionList();
                if (this.drawObjectsComplete == null) {
                    this.drawObjectsComplete = new Vector();
                    this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    listIterator = this.cPTWindow.getDataIterator();
                    while (listIterator.hasNext()) {
                        int n19;
                        sMWThreadDataElement = (SMWThreadDataElement)listIterator.next();
                        if (sMWThreadDataElement.isCallPathObject()) continue;
                        listIterator4 = sMWThreadDataElement.getParentsIterator();
                        while (listIterator4.hasNext()) {
                            n17 = (Integer)listIterator4.next();
                            listIterator5 = sMWThreadDataElement.getCallPathIDParents(n17);
                            d = 0.0;
                            d4 = 0.0;
                            n18 = 0;
                            while (listIterator5.hasNext()) {
                                n19 = (Integer)listIterator5.next();
                                globalThreadDataElement = (GlobalThreadDataElement)vector.elementAt(n19);
                                d += globalThreadDataElement.getExclusiveValue(this.trial.getSelectedMetricID());
                                d4 += globalThreadDataElement.getInclusiveValue(this.trial.getSelectedMetricID());
                                n18 += globalThreadDataElement.getNumberOfCalls();
                            }
                            callPathDrawObject = new CallPathDrawObject((Mapping)thread.getFunction(n17.intValue()), true, false, false);
                            callPathDrawObject.setExclusiveValue(d);
                            callPathDrawObject.setInclusiveValue(d4);
                            callPathDrawObject.setNumberOfCallsFromCallPathObjects(n18);
                            callPathDrawObject.setNumberOfCalls(sMWThreadDataElement.getNumberOfCalls());
                            this.drawObjectsComplete.add(callPathDrawObject);
                        }
                        callPathDrawObject = new CallPathDrawObject((Mapping)thread.getFunction(sMWThreadDataElement.getMappingID()), false, false, false);
                        callPathDrawObject.setExclusiveValue(sMWThreadDataElement.getExclusiveValue());
                        callPathDrawObject.setInclusiveValue(sMWThreadDataElement.getInclusiveValue());
                        callPathDrawObject.setNumberOfCalls(sMWThreadDataElement.getNumberOfCalls());
                        this.drawObjectsComplete.add(callPathDrawObject);
                        listIterator4 = sMWThreadDataElement.getChildrenIterator();
                        while (listIterator4.hasNext()) {
                            n17 = (Integer)listIterator4.next();
                            listIterator5 = sMWThreadDataElement.getCallPathIDChildren(n17);
                            d = 0.0;
                            d4 = 0.0;
                            n18 = 0;
                            while (listIterator5.hasNext()) {
                                n19 = (Integer)listIterator5.next();
                                globalThreadDataElement = (GlobalThreadDataElement)vector.elementAt(n19);
                                d += globalThreadDataElement.getExclusiveValue(this.trial.getSelectedMetricID());
                                d4 += globalThreadDataElement.getInclusiveValue(this.trial.getSelectedMetricID());
                                n18 += globalThreadDataElement.getNumberOfCalls();
                            }
                            callPathDrawObject = new CallPathDrawObject((Mapping)thread.getFunction(n17.intValue()), false, true, false);
                            callPathDrawObject.setExclusiveValue(d);
                            callPathDrawObject.setInclusiveValue(d4);
                            callPathDrawObject.setNumberOfCallsFromCallPathObjects(n18);
                            callPathDrawObject.setNumberOfCalls(thread.getFunction(n17.intValue()).getNumberOfCalls());
                            this.drawObjectsComplete.add(callPathDrawObject);
                        }
                        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    }
                }
                if (this.drawObjects == null) {
                    this.drawObjects = new Vector();
                    Vector<CallPathDrawObject> vector2 = new Vector<CallPathDrawObject>();
                    n16 = 0;
                    n15 = -1;
                    n14 = -1;
                    if (this.cPTWindow.showCollapsedView()) {
                        object = this.drawObjectsComplete.elements();
                        block42: while (object.hasMoreElements()) {
                            callPathDrawObject = (CallPathDrawObject)object.nextElement();
                            n15 = callPathDrawObject.isSpacer() ? 0 : (callPathDrawObject.isParent() ? (n16 != 0 ? 1 : 2) : (callPathDrawObject.isChild() ? (n16 != 0 ? 3 : 4) : (n16 != 0 ? 5 : 6)));
                            switch (n15) {
                                case 0: {
                                    this.drawObjects.add(callPathDrawObject);
                                    continue block42;
                                }
                                case 1: {
                                    n16 = 0;
                                    vector2.add(callPathDrawObject);
                                    continue block42;
                                }
                                case 2: {
                                    vector2.add(callPathDrawObject);
                                    continue block42;
                                }
                                case 3: {
                                    this.drawObjects.add(callPathDrawObject);
                                    continue block42;
                                }
                                case 5: {
                                    int n20;
                                    n14 = vector2.size();
                                    for (n20 = 0; n20 < n14; ++n20) {
                                        this.drawObjects.add(vector2.elementAt(n20));
                                    }
                                    vector2.clear();
                                    this.drawObjects.add(callPathDrawObject);
                                    if (callPathDrawObject.isExpanded()) {
                                        n16 = 1;
                                        continue block42;
                                    }
                                    n16 = 0;
                                    continue block42;
                                }
                                case 6: {
                                    int n20;
                                    if (callPathDrawObject.isExpanded()) {
                                        n14 = vector2.size();
                                        for (n20 = 0; n20 < n14; ++n20) {
                                            this.drawObjects.add(vector2.elementAt(n20));
                                        }
                                        vector2.clear();
                                        n16 = 1;
                                    } else {
                                        vector2.clear();
                                    }
                                    this.drawObjects.add(callPathDrawObject);
                                    continue block42;
                                }
                            }
                            if (!this.debug()) continue;
                            System.out.println("In default state (CPTWP). State is: " + n15);
                        }
                    } else {
                        this.drawObjects = this.drawObjectsComplete;
                    }
                }
                if (this.calculatePanelSize()) {
                    Enumeration enumeration = this.drawObjects.elements();
                    while (enumeration.hasMoreElements()) {
                        callPathDrawObject = (CallPathDrawObject)enumeration.nextElement();
                        this.yHeightNeeded += this.spacing;
                        this.max = this.setMax(this.max, this.fmMonoFont.stringWidth(UtilFncs.getOutputString((int)this.cPTWindow.units(), (double)callPathDrawObject.getExclusiveValue(), (int)n2)), this.fmMonoFont.stringWidth(UtilFncs.getOutputString((int)this.cPTWindow.units(), (double)callPathDrawObject.getInclusiveValue(), (int)n2)));
                        if (callPathDrawObject.isSpacer()) continue;
                        this.length = this.fmMonoFont.stringWidth(callPathDrawObject.getMappingName()) + 10;
                        if (this.xWidthNeeded >= this.length) continue;
                        this.xWidthNeeded = this.length;
                    }
                    this.base = 20;
                    this.startPosition = this.fmMonoFont.stringWidth("--> ") + this.base;
                    this.stringWidth = (int)this.max + 10;
                    this.check = this.fmMonoFont.stringWidth("Exclusive");
                    if (this.stringWidth < this.check) {
                        this.stringWidth = this.check + 5;
                    }
                    this.numCallsWidth = this.fmMonoFont.stringWidth(Integer.toString(thread.getMaxNumberOfCalls())) + 10;
                    this.check = this.fmMonoFont.stringWidth("Calls/Tot.Calls");
                    if (this.numCallsWidth < this.check) {
                        this.numCallsWidth = this.check + 5;
                    }
                    this.excPos = this.startPosition;
                    this.incPos = this.excPos + this.stringWidth;
                    this.callsPos1 = this.incPos + this.stringWidth;
                    this.callsPos2 = this.callsPos1 + this.numCallsWidth;
                    this.namePos = this.callsPos2 + this.numCallsWidth;
                    this.xWidthNeeded = this.xWidthNeeded + this.namePos + 20;
                    boolean bl4 = false;
                    if (this.xWidthNeeded > this.xPanelSize) {
                        this.xPanelSize = this.xWidthNeeded + 10;
                        bl4 = true;
                    }
                    if (this.yHeightNeeded > this.yPanelSize) {
                        this.yPanelSize = this.yHeightNeeded + 10;
                        bl4 = true;
                    }
                    if (bl4 && n == 0) {
                        this.revalidate();
                    }
                    this.setCalculatePanelSize(false);
                }
                int n21 = 0;
                n16 = 0;
                n15 = 0;
                n14 = 0;
                object = null;
                Rectangle rectangle = null;
                if (n == 0 || n == 1) {
                    if (n == 0) {
                        object = graphics2D.getClipBounds();
                        n21 = (int)((Rectangle)object).getY();
                        n16 = (int)((double)n21 + ((Rectangle)object).getHeight());
                    } else {
                        rectangle = this.cPTWindow.getViewRect();
                        n21 = (int)rectangle.getY();
                        n16 = (int)((double)n21 + rectangle.getHeight());
                    }
                    n15 = (n21 - n3) / this.spacing - 1;
                    n14 = (n16 - n3) / this.spacing + 1;
                    if (n15 < 0) {
                        n15 = 0;
                    }
                    if (n14 < 0) {
                        n14 = 0;
                    }
                    if (n15 > this.drawObjects.size() - 1) {
                        n15 = this.drawObjects.size() - 1;
                    }
                    if (n14 > this.drawObjects.size() - 1) {
                        n14 = this.drawObjects.size() - 1;
                    }
                    if (n == 0) {
                        n3 += n15 * this.spacing;
                    }
                } else if (n == 2 || n == 3) {
                    n15 = 0;
                    n14 = this.drawObjects.size() - 1;
                }
                graphics2D.setColor(Color.black);
                if (bl) {
                    n3 += this.spacing;
                    String string = this.cPTWindow.getHeaderString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
                    while (stringTokenizer.hasMoreTokens()) {
                        graphics2D.drawString(stringTokenizer.nextToken(), 15, n3);
                        n3 += this.spacing;
                    }
                    this.lastHeaderEndPosition = n3;
                }
                for (int i = n15; i <= n14; ++i) {
                    callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(i);
                    if (i == 1) {
                        graphics2D.drawString("Exclusive", this.excPos, n3);
                        graphics2D.drawString("Inclusive", this.incPos, n3);
                        graphics2D.drawString("Calls/Tot.Calls", this.callsPos1, n3);
                        graphics2D.drawString("Name[id]", this.namePos, n3);
                        n3 += this.spacing;
                        continue;
                    }
                    if (i == 2) {
                        graphics2D.drawString("--------------------------------------------------------------------------------", this.excPos, n3);
                        n3 += this.spacing;
                        continue;
                    }
                    if (!callPathDrawObject.isParentChild() && !callPathDrawObject.isSpacer()) {
                        graphics2D.drawString("--> ", this.base, n3);
                        graphics2D.drawString(UtilFncs.getOutputString((int)this.cPTWindow.units(), (double)callPathDrawObject.getExclusiveValue(), (int)ParaProf.defaultNumberPrecision), this.excPos, n3);
                        graphics2D.drawString(UtilFncs.getOutputString((int)this.cPTWindow.units(), (double)callPathDrawObject.getInclusiveValue(), (int)ParaProf.defaultNumberPrecision), this.incPos, n3);
                        graphics2D.drawString(Double.toString(callPathDrawObject.getNumberOfCalls()), this.callsPos1, n3);
                        int n22 = callPathDrawObject.getMappingID();
                        if (this.trial.getColorChooser().getHighlightColorID() == n22) {
                            graphics2D.setColor(Color.red);
                            graphics2D.drawString(callPathDrawObject.getMappingName() + "[" + n22 + "]", this.namePos, n3);
                            graphics2D.setColor(Color.black);
                        } else {
                            graphics2D.drawString(callPathDrawObject.getMappingName() + "[" + n22 + "]", this.namePos, n3);
                        }
                        n3 += this.spacing;
                        continue;
                    }
                    if (callPathDrawObject.isSpacer()) {
                        n3 += this.spacing;
                        continue;
                    }
                    graphics2D.drawString(UtilFncs.getOutputString((int)this.cPTWindow.units(), (double)callPathDrawObject.getExclusiveValue(), (int)ParaProf.defaultNumberPrecision), this.excPos, n3);
                    graphics2D.drawString(UtilFncs.getOutputString((int)this.cPTWindow.units(), (double)callPathDrawObject.getInclusiveValue(), (int)ParaProf.defaultNumberPrecision), this.incPos, n3);
                    graphics2D.drawString(callPathDrawObject.getNumberOfCallsFromCallPathObjects() + "/" + callPathDrawObject.getNumberOfCalls(), this.callsPos1, n3);
                    int n23 = callPathDrawObject.getMappingID();
                    if (this.trial.getColorChooser().getHighlightColorID() == n23) {
                        graphics2D.setColor(Color.red);
                        graphics2D.drawString(callPathDrawObject.getMappingName() + "[" + callPathDrawObject.getMappingID() + "]", this.namePos, n3);
                        graphics2D.setColor(Color.black);
                    } else {
                        graphics2D.drawString(callPathDrawObject.getMappingName() + "[" + callPathDrawObject.getMappingID() + "]", this.namePos, n3);
                    }
                    n3 += this.spacing;
                }
            } else if (this.windowType == 2) {
                Object object;
                int n24;
                int n25;
                int n26;
                Object object2;
                ListIterator listIterator = null;
                ListIterator listIterator6 = null;
                Object var9_16 = null;
                GlobalMapping globalMapping = this.trial.getGlobalMapping();
                GlobalMappingElement globalMappingElement = null;
                CallPathDrawObject callPathDrawObject = null;
                Integer n27 = null;
                Object var14_31 = null;
                if (this.drawObjectsComplete == null) {
                    this.drawObjectsComplete = new Vector();
                    this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    listIterator = this.cPTWindow.getDataIterator();
                    while (listIterator.hasNext()) {
                        globalMappingElement = (GlobalMappingElement)listIterator.next();
                        if (globalMappingElement.isCallPathObject()) continue;
                        listIterator6 = globalMappingElement.getParentsIterator();
                        while (listIterator6.hasNext()) {
                            n27 = (Integer)listIterator6.next();
                            callPathDrawObject = new CallPathDrawObject((Mapping)globalMapping.getGlobalMappingElement(n27.intValue(), 0), true, false, false);
                            this.drawObjectsComplete.add(callPathDrawObject);
                        }
                        callPathDrawObject = new CallPathDrawObject((Mapping)globalMappingElement, false, false, false);
                        this.drawObjectsComplete.add(callPathDrawObject);
                        listIterator6 = globalMappingElement.getChildrenIterator();
                        while (listIterator6.hasNext()) {
                            n27 = (Integer)listIterator6.next();
                            callPathDrawObject = new CallPathDrawObject((Mapping)globalMapping.getGlobalMappingElement(n27.intValue(), 0), false, true, false);
                            this.drawObjectsComplete.add(callPathDrawObject);
                        }
                        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
                    }
                }
                if (this.drawObjects == null) {
                    this.drawObjects = new Vector();
                    object2 = new Vector();
                    n26 = 0;
                    n25 = -1;
                    n24 = -1;
                    if (this.cPTWindow.showCollapsedView()) {
                        object = this.drawObjectsComplete.elements();
                        block51: while (object.hasMoreElements()) {
                            callPathDrawObject = (CallPathDrawObject)object.nextElement();
                            n25 = callPathDrawObject.isSpacer() ? 0 : (callPathDrawObject.isParent() ? (n26 != 0 ? 1 : 2) : (callPathDrawObject.isChild() ? (n26 != 0 ? 3 : 4) : (n26 != 0 ? 5 : 6)));
                            switch (n25) {
                                case 0: {
                                    this.drawObjects.add(callPathDrawObject);
                                    continue block51;
                                }
                                case 1: {
                                    n26 = 0;
                                    ((Vector)object2).add(callPathDrawObject);
                                    continue block51;
                                }
                                case 2: {
                                    ((Vector)object2).add(callPathDrawObject);
                                    continue block51;
                                }
                                case 3: {
                                    this.drawObjects.add(callPathDrawObject);
                                    continue block51;
                                }
                                case 5: {
                                    int n28;
                                    n24 = ((Vector)object2).size();
                                    for (n28 = 0; n28 < n24; ++n28) {
                                        this.drawObjects.add(((Vector)object2).elementAt(n28));
                                    }
                                    ((Vector)object2).clear();
                                    this.drawObjects.add(callPathDrawObject);
                                    if (callPathDrawObject.isExpanded()) {
                                        n26 = 1;
                                        continue block51;
                                    }
                                    n26 = 0;
                                    continue block51;
                                }
                                case 6: {
                                    int n28;
                                    if (callPathDrawObject.isExpanded()) {
                                        n24 = ((Vector)object2).size();
                                        for (n28 = 0; n28 < n24; ++n28) {
                                            this.drawObjects.add(((Vector)object2).elementAt(n28));
                                        }
                                        ((Vector)object2).clear();
                                        n26 = 1;
                                    } else {
                                        ((Vector)object2).clear();
                                    }
                                    this.drawObjects.add(callPathDrawObject);
                                    continue block51;
                                }
                            }
                            if (!this.debug()) continue;
                            System.out.println("In default state (CPTWP). State is: " + n25);
                        }
                    } else {
                        this.drawObjects = this.drawObjectsComplete;
                    }
                }
                if (this.calculatePanelSize()) {
                    object2 = this.drawObjects.elements();
                    while (object2.hasMoreElements()) {
                        callPathDrawObject = (CallPathDrawObject)object2.nextElement();
                        this.yHeightNeeded += this.spacing;
                        if (callPathDrawObject.isSpacer()) continue;
                        this.length = this.fmMonoFont.stringWidth(callPathDrawObject.getMappingName()) + 10;
                        if (this.xWidthNeeded >= this.length) continue;
                        this.xWidthNeeded = this.length;
                    }
                    this.base = 20;
                    this.startPosition = this.fmMonoFont.stringWidth("--> ") + this.base;
                    this.xWidthNeeded += 20;
                    boolean bl5 = false;
                    if (this.xWidthNeeded > this.xPanelSize) {
                        this.xPanelSize = this.xWidthNeeded + 10;
                        bl5 = true;
                    }
                    if (this.yHeightNeeded > this.yPanelSize) {
                        this.yPanelSize = this.yHeightNeeded + 10;
                        bl5 = true;
                    }
                    if (bl5 && n == 0) {
                        this.revalidate();
                    }
                    this.setCalculatePanelSize(false);
                }
                int n29 = 0;
                n26 = 0;
                n25 = 0;
                n24 = 0;
                object = null;
                Rectangle rectangle = null;
                if (n == 0 || n == 1) {
                    if (n == 0) {
                        object = graphics2D.getClipBounds();
                        n29 = (int)((Rectangle)object).getY();
                        n26 = (int)((double)n29 + ((Rectangle)object).getHeight());
                    } else {
                        rectangle = this.cPTWindow.getViewRect();
                        n29 = (int)rectangle.getY();
                        n26 = (int)((double)n29 + rectangle.getHeight());
                    }
                    n25 = (n29 - n3) / this.spacing - 1;
                    n24 = (n26 - n3) / this.spacing + 1;
                    if (n25 < 0) {
                        n25 = 0;
                    }
                    if (n24 < 0) {
                        n24 = 0;
                    }
                    if (n25 > this.drawObjects.size() - 1) {
                        n25 = this.drawObjects.size() - 1;
                    }
                    if (n24 > this.drawObjects.size() - 1) {
                        n24 = this.drawObjects.size() - 1;
                    }
                    if (n == 0) {
                        n3 += n25 * this.spacing;
                    }
                } else if (n == 2 || n == 3) {
                    n25 = 0;
                    n24 = this.drawObjects.size() - 1;
                }
                graphics2D.setColor(Color.black);
                if (bl) {
                    FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                    Insets insets = this.getInsets();
                    n3 += this.spacing;
                    String string = this.cPTWindow.getHeaderString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
                    while (stringTokenizer.hasMoreTokens()) {
                        AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                        attributedString.addAttribute(TextAttribute.FONT, this.monoFont);
                        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                        float f = this.getSize().width - insets.left - insets.right;
                        float f2 = insets.left;
                        float f3 = insets.right;
                        while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                            TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                            textLayout.draw(graphics2D, f2, n3 += this.spacing);
                            f2 = insets.left;
                        }
                    }
                    this.lastHeaderEndPosition = n3;
                }
                for (int i = n25; i <= n24; ++i) {
                    callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(i);
                    if (i == 1) {
                        graphics2D.drawString("Name[id]", this.startPosition, n3);
                        n3 += this.spacing;
                        continue;
                    }
                    if (i == 2) {
                        graphics2D.drawString("--------------------------------------------------------------------------------", this.startPosition, n3);
                        n3 += this.spacing;
                        continue;
                    }
                    if (!callPathDrawObject.isParentChild() && !callPathDrawObject.isSpacer()) {
                        graphics2D.drawString("--> ", this.base, n3);
                        int n30 = callPathDrawObject.getMappingID();
                        if (this.trial.getColorChooser().getHighlightColorID() == n30) {
                            graphics2D.setColor(Color.red);
                            graphics2D.drawString(callPathDrawObject.getMappingName() + "[" + n30 + "]", this.startPosition, n3);
                            graphics2D.setColor(Color.black);
                        } else {
                            graphics2D.drawString(callPathDrawObject.getMappingName() + "[" + n30 + "]", this.startPosition, n3);
                        }
                        n3 += this.spacing;
                        continue;
                    }
                    if (callPathDrawObject.isSpacer()) {
                        n3 += this.spacing;
                        continue;
                    }
                    int n31 = callPathDrawObject.getMappingID();
                    if (this.trial.getColorChooser().getHighlightColorID() == n31) {
                        graphics2D.setColor(Color.red);
                        graphics2D.drawString(callPathDrawObject.getMappingName() + "[" + callPathDrawObject.getMappingID() + "]", this.startPosition, n3);
                        graphics2D.setColor(Color.black);
                    } else {
                        graphics2D.drawString(callPathDrawObject.getMappingName() + "[" + callPathDrawObject.getMappingID() + "]", this.startPosition, n3);
                    }
                    n3 += this.spacing;
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, (Component)this, (String)"CPTWP02");
        }
    }

    private double setMax(double d, double d2, double d3) {
        if (d < d2) {
            d = d2;
        }
        if (d < d3) {
            d = d3;
        }
        return d;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            CallPathDrawObject callPathDrawObject = null;
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof CallPathDrawObject) {
                        callPathDrawObject = (CallPathDrawObject)this.clickedOnObject;
                        this.trial.getColorChooser().setHighlightColorID(callPathDrawObject.getMappingID());
                        MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, callPathDrawObject.getMappingID(), this.trial.getStaticMainWindow().getSMWData(), this.debug());
                        this.trial.getSystemEvents().addObserver(mappingDataWindow);
                        mappingDataWindow.show();
                    }
                } else if (string.equals("Find Function")) {
                    if (this.clickedOnObject instanceof CallPathDrawObject) {
                        int n = ((CallPathDrawObject)this.clickedOnObject).getMappingID();
                        int n2 = this.drawObjects.size();
                        for (int i = 0; i < n2; ++i) {
                            callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(i);
                            if (callPathDrawObject.getMappingID() != n || callPathDrawObject.isParentChild()) continue;
                            Dimension dimension = this.cPTWindow.getViewportSize();
                            this.cPTWindow.setVerticalScrollBarPosition(i * this.trial.getPreferences().getBarSpacing() - (int)dimension.getHeight() / 2);
                            this.trial.getColorChooser().setHighlightColorID(n);
                            return;
                        }
                    }
                } else if (string.equals("Change Function Color")) {
                    if (this.clickedOnObject instanceof CallPathDrawObject) {
                        int n = ((CallPathDrawObject)this.clickedOnObject).getMappingID();
                        GlobalMapping globalMapping = this.trial.getGlobalMapping();
                        GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                        Color color = globalMappingElement.getColor();
                        new JColorChooser();
                        color = JColorChooser.showDialog(this, "Please select a new color", color);
                        if (color != null) {
                            globalMappingElement.setSpecificColor(color);
                            globalMappingElement.setColorFlag(true);
                            this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                        }
                    }
                } else if (string.equals("Reset to Generic Color") && this.clickedOnObject instanceof CallPathDrawObject) {
                    int n = ((CallPathDrawObject)this.clickedOnObject).getMappingID();
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                    globalMappingElement.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TSWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            CallPathDrawObject callPathDrawObject = null;
            int n4 = (n2 - 1) / this.trial.getPreferences().getBarSpacing() + 1;
            if (n4 < this.drawObjects.size() && !(callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(n4)).isSpacer()) {
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    this.clickedOnObject = callPathDrawObject;
                    this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
                if (n < this.startPosition) {
                    if (!callPathDrawObject.isParentChild()) {
                        if (callPathDrawObject.isExpanded()) {
                            callPathDrawObject.setExpanded(false);
                        } else {
                            callPathDrawObject.setExpanded(true);
                        }
                    }
                    this.drawObjects = null;
                }
                if (this.trial.getColorChooser().getHighlightColorID() == -1) {
                    this.trial.getColorChooser().setHighlightColorID(callPathDrawObject.getMappingID());
                } else if (this.trial.getColorChooser().getHighlightColorID() != callPathDrawObject.getMappingID()) {
                    this.trial.getColorChooser().setHighlightColorID(callPathDrawObject.getMappingID());
                } else {
                    this.trial.getColorChooser().setHighlightColorID(-1);
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.cPTWindow.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    public void resetAllDrawObjects() {
        this.drawObjectsComplete.clear();
        this.drawObjectsComplete = null;
        this.drawObjects.clear();
        this.drawObjects = null;
    }

    private void setCalculatePanelSize(boolean bl) {
        this.calculatePanelSize = bl;
    }

    private boolean calculatePanelSize() {
        return this.calculatePanelSize;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

