/*
 * Decompiled with CFR 0.152.
 */
package perfdb.util.dbinterface;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import perfdb.util.dbinterface.DB;
import perfdb.util.dbinterface.DBAcct;
import perfdb.util.dbinterface.JDBCAcct;
import perfdb.util.dbinterface.ParseConfig;

public class DBConnector
implements DB {
    private Statement statement;
    private DBAcct acct = null;
    private Connection conn = null;
    private ParseConfig parseConfig = null;
    private String dbaddress;
    private String driverName;

    public DBConnector(ParseConfig parser) throws SQLException {
        this.parseConfig = parser;
        this.setJDBC(parser);
        this.register();
    }

    public DBConnector(DBAcct acct, ParseConfig parser) throws SQLException {
        this.parseConfig = parser;
        this.setJDBC(parser);
        this.setAcct(acct);
        this.register();
        this.connect();
    }

    public DBConnector(DBAcct acct, ParseConfig parser, boolean test) throws SQLException {
        this.parseConfig = parser;
        this.setJDBC(parser);
        this.setAcct(acct);
        this.register();
        this.testConnect();
    }

    public void setJDBC(ParseConfig parser) {
        this.dbaddress = parser.getDBType().compareTo("mysql") == 0 ? "jdbc:" + parser.getDBType() + "://" + parser.getDBHost() + ":" + parser.getDBPort() + "/" + parser.getDBName() + "?" : "jdbc:" + parser.getDBType() + "://" + parser.getDBHost() + ":" + parser.getDBPort() + "/" + parser.getDBName() + ";";
        this.driverName = parser.getJDBCDriver();
    }

    public void close() {
        try {
            if (this.conn.isClosed()) {
                return;
            }
            this.conn.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public boolean connect() {
        try {
            if (this.conn != null) {
                return true;
            }
            this.conn = DriverManager.getConnection(this.getConnectString());
            return true;
        }
        catch (SQLException ex) {
            System.err.println("Cannot connect to server.");
            ex.printStackTrace();
            return false;
        }
    }

    public boolean testConnect() throws SQLException {
        try {
            if (this.conn != null) {
                return true;
            }
            this.conn = DriverManager.getConnection(this.getConnectString());
            return true;
        }
        catch (SQLException ex) {
            System.err.println("Cannot connect to server.");
            throw ex;
        }
    }

    public boolean connect(DBAcct acct) {
        this.setAcct(acct);
        return this.connect();
    }

    public boolean connect(Connection newconn) {
        this.conn = newconn;
        return true;
    }

    public ResultSet executeQuery(String query) throws SQLException {
        if (this.statement == null) {
            if (this.conn == null) {
                System.err.println("Database is closed for " + query);
                return null;
            }
            this.statement = this.conn.createStatement();
        }
        return this.statement.executeQuery(query.trim());
    }

    public boolean execute(String query) throws SQLException {
        if (this.statement == null) {
            if (this.conn == null) {
                System.err.println("Database is closed for " + query);
                return false;
            }
            this.statement = this.conn.createStatement();
        }
        return this.statement.execute(query.trim());
    }

    public int executeUpdate(String sql) throws SQLException {
        try {
            if (this.statement == null) {
                if (this.conn == null) {
                    System.err.println("Database is closed for " + sql);
                    return 0;
                }
                this.statement = this.conn.createStatement();
            }
            return this.statement.executeUpdate(sql.trim());
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public DBAcct getAcct() {
        return this.acct;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getConnectString() {
        return this.getDBAddress() + this.getAcct();
    }

    public String getDBAddress() {
        return this.dbaddress;
    }

    public String getDataItem(String query) {
        try {
            ResultSet resultSet = this.executeQuery(query);
            if (!resultSet.next()) {
                resultSet.close();
                return null;
            }
            String result = resultSet.getString(1);
            resultSet.close();
            return result;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean isClosed() {
        if (this.conn == null) {
            return true;
        }
        try {
            return this.conn.isClosed();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return true;
        }
    }

    public void register() {
        try {
            Class.forName(this.driverName).newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setAcct(JDBCAcct newValue) {
        this.acct = newValue;
    }

    public void setAcct(DBAcct newValue) {
        this.acct = newValue;
    }

    public void setDBAddress(String newValue) {
        this.dbaddress = newValue;
    }

    public String getDBType() {
        return new String(this.parseConfig.getDBType());
    }
}

