/*
 * Decompiled with CFR 0.152.
 */
package perfdb.loadxml;

import jargs.gnu.CmdLineParser;
import perfdb.ConnectionManager;
import perfdb.loadxml.Load;
import perfdb.util.dbinterface.DB;

public class LoadTrial {
    private Load load = null;
    private DB db = null;
    private static String TRIAL_USAGE = "USAGE: perfdb_loadtrial [{-h,--help}] [{-x,--xmlfile} filename] [{-t,--trialid] trial id] [{-p --problemfile} filename]\n";
    private ConnectionManager connector;

    public LoadTrial(String configFileName) {
        this.connector = new ConnectionManager(configFileName);
    }

    public ConnectionManager getConnector() {
        return this.connector;
    }

    public Load getLoad() {
        if (this.load == null) {
            this.load = this.connector.getDB() == null ? new Load(this.connector.getParserClass()) : new Load(this.connector.getDB(), this.connector.getParserClass());
        }
        return this.load;
    }

    public String storeDocument(String xmlFile, String trialId, String problemFile, boolean bulkLoad) {
        String trialIdOut;
        if (trialId.compareTo("0") != 0 && (trialIdOut = this.getLoad().lookupTrial("trial", trialId)) == null) {
            System.out.println("The trial " + trialId + " was not found.");
            System.exit(-1);
        }
        try {
            trialId = this.getLoad().parse(xmlFile, trialId, problemFile, bulkLoad);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.out.println("Error: " + ex.getMessage());
        }
        if (trialId != null) {
            System.out.println("Loaded " + xmlFile + ", the trial id is: " + trialId);
        } else {
            System.out.println("Was unable to load document from " + xmlFile);
        }
        return trialId;
    }

    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option configfileOpt = parser.addStringOption('g', "configfile");
        CmdLineParser.Option xmlfileOpt = parser.addStringOption('x', "xmlfile");
        CmdLineParser.Option trialidOpt = parser.addStringOption('t', "trialid");
        CmdLineParser.Option problemfileOpt = parser.addStringOption('p', "problemfile");
        CmdLineParser.Option bulkOpt = parser.addBooleanOption('b', "bulk");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            System.err.println(TRIAL_USAGE);
            System.exit(-1);
        }
        Boolean help = (Boolean)parser.getOptionValue(helpOpt);
        String configFile = (String)parser.getOptionValue(configfileOpt);
        String xmlFile = (String)parser.getOptionValue(xmlfileOpt);
        String trialID = (String)parser.getOptionValue(trialidOpt);
        String problemFile = (String)parser.getOptionValue(problemfileOpt);
        Boolean bulk = (Boolean)parser.getOptionValue(bulkOpt);
        if (help != null && help.booleanValue()) {
            System.err.println(TRIAL_USAGE);
            System.exit(-1);
        }
        if (configFile == null) {
            System.err.println("Please enter a valid config file.");
            System.err.println(TRIAL_USAGE);
            System.exit(-1);
        }
        if (trialID == null) {
            trialID = new String("0");
        }
        if (xmlFile == null) {
            System.err.println("Please enter a valid trial XML file.");
            System.err.println(TRIAL_USAGE);
            System.exit(-1);
        }
        LoadTrial loadTrial = new LoadTrial(configFile);
        loadTrial.getConnector().connect();
        int exitval = 0;
        String trialid = loadTrial.storeDocument(xmlFile, trialID, problemFile, bulk != null && bulk != false);
        if (trialid != null) {
            exitval = Integer.parseInt(trialid);
        }
        loadTrial.getConnector().dbclose();
        System.exit(exitval);
    }
}

