/*
 * Decompiled with CFR 0.152.
 */
package perfdb.loadxml;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import perfdb.util.dbinterface.DB;

public class LoadHandler2
extends DefaultHandler {
    protected String appid = "";
    protected String expid = "";
    protected String probsize = "";
    protected String trialName = "";
    protected String userData = "";
    protected String problemString = "";
    protected String currentElement = "";
    protected String documentName = "";
    protected String documentId = "";
    protected String metricStr = "";
    protected String metricId = "";
    protected String trialId = "";
    protected String trialTime = "";
    protected boolean newTrial = false;
    protected int funAmt;
    protected int ueAmt;
    protected String nodenum = "";
    protected String contextpnode = "";
    protected String threadpcontext = "";
    protected String nodeid = "";
    protected String threadid = "";
    protected String contextid = "";
    protected String funid = "";
    protected String funname = "";
    protected String fungroup = "";
    protected String funIndex = "";
    protected String locid = "";
    protected String inclperc = "";
    protected String incl = "";
    protected String exclperc = "";
    protected String excl = "";
    protected String callnum = "";
    protected String subrs = "";
    protected String inclpcall = "";
    protected String uename = "";
    protected String ueid = "";
    protected String uegroup = "UE";
    protected String numofsamples = "";
    protected String maxvalue = "";
    protected String minvalue = "";
    protected String meanvalue = "";
    protected String standardDeviation = "";
    private DB dbconnector;
    private String[] funArray;
    private String[] ueArray;

    public LoadHandler2(DB db, String trialId, String problemString) {
        this.dbconnector = db;
        this.trialId = trialId;
        this.problemString = problemString;
    }

    public DB getDB() {
        return this.dbconnector;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getTrialId() {
        return this.trialId;
    }

    public String getDocumentName() {
        if (this.documentName == null) {
            this.setDocumentName("NoName" + this.getDocumentId());
        }
        return this.documentName;
    }

    public void setDocumentName(String newValue) {
        this.documentName = newValue;
    }

    public void startDocument() throws SAXException {
        StringBuffer buf = new StringBuffer();
        buf.append("insert into xml_file (trial, metric, name) values ");
        File ff = new File(this.getDocumentName());
        String filename = ff.getAbsolutePath();
        buf.append("(0, 0, '" + filename + "'); ");
        try {
            this.getDB().executeUpdate(buf.toString());
            buf.delete(0, buf.toString().length());
            if (this.getDB().getDBType().compareTo("mysql") == 0) {
                buf.append("select LAST_INSERT_ID();");
            } else {
                buf.append("select currval('xml_file_id_seq');");
            }
            this.documentId = this.getDB().getDataItem(buf.toString());
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public String metricAttrToString(Attributes attrList) {
        StringBuffer buf = new StringBuffer();
        int length = attrList.getLength();
        int i = 0;
        while (i < length) {
            buf.append(attrList.getValue(i));
            ++i;
        }
        return buf.toString();
    }

    public void startElement(String url, String name, String qname, Attributes attrList) throws SAXException {
        if (name.equalsIgnoreCase("Onetrial")) {
            this.metricStr = this.metricAttrToString(attrList);
        }
        this.currentElement = new String(name);
    }

    public void characters(char[] chars, int start, int length) {
        boolean isWhitespace = true;
        int i = start;
        while (i < start + length) {
            if (!Character.isWhitespace(chars[i])) {
                isWhitespace = false;
                break;
            }
            ++i;
        }
        if (isWhitespace) {
            return;
        }
        String tempcode = new String(chars, start, length);
        if (this.currentElement.equals("AppID")) {
            this.appid = tempcode;
            if (this.appid.length() == 0) {
                System.out.println("No valid application ID. Quit loadding.");
                System.exit(-1);
            }
        } else if (this.currentElement.equals("ExpID")) {
            this.expid = tempcode;
            if (this.expid.length() == 0) {
                System.out.println("No valid experiment ID. Quit loadding.");
                System.exit(-1);
            }
        } else if (this.currentElement.equals("ProblemSize")) {
            this.probsize = tempcode;
        } else if (this.currentElement.equals("TrialName")) {
            this.trialName = tempcode;
        } else if (this.currentElement.equals("UserData")) {
            this.userData = tempcode;
        } else if (this.currentElement.equals("Trialtime")) {
            this.trialTime = tempcode;
        } else if (this.currentElement.equals("FunAmt")) {
            this.funAmt = Integer.parseInt(tempcode);
            if (this.funAmt > 0) {
                this.funArray = new String[this.funAmt];
            }
        } else if (this.currentElement.equals("UserEventAmt")) {
            this.ueAmt = Integer.parseInt(tempcode);
            if (this.ueAmt > 0) {
                this.ueArray = new String[this.ueAmt];
            }
            if (this.ueAmt + this.funAmt == 0) {
                System.out.println("Cannot get a valid function amount, quit loadding.");
                System.exit(-1);
            }
        } else if (this.currentElement.equals("node")) {
            this.nodenum = tempcode;
        } else if (this.currentElement.equals("context")) {
            this.contextpnode = tempcode;
        } else if (this.currentElement.equals("thread")) {
            this.threadpcontext = tempcode;
        } else if (this.currentElement.equals("nodeID")) {
            this.nodeid = tempcode;
        } else if (this.currentElement.equals("contextID")) {
            this.contextid = tempcode;
        } else if (this.currentElement.equals("threadID")) {
            this.threadid = tempcode;
        } else if (this.currentElement.equals("funname")) {
            this.funname = this.funname + tempcode;
        } else if (this.currentElement.equals("fungroup")) {
            this.fungroup = this.fungroup + tempcode;
        } else if (this.currentElement.equals("funID")) {
            this.funid = tempcode;
        } else if (this.currentElement.equals("inclperc")) {
            this.inclperc = tempcode;
        } else if (this.currentElement.equals("inclutime")) {
            this.incl = tempcode;
        } else if (this.currentElement.equals("exclperc")) {
            this.exclperc = tempcode;
        } else if (this.currentElement.equals("exclutime")) {
            this.excl = tempcode;
        } else if (this.currentElement.equals("call")) {
            this.callnum = tempcode;
        } else if (this.currentElement.equals("subrs")) {
            this.subrs = tempcode;
        } else if (this.currentElement.equals("inclutimePcall")) {
            this.inclpcall = tempcode;
        } else if (this.currentElement.equals("uename")) {
            this.uename = tempcode;
        } else if (this.currentElement.equals("ueID")) {
            this.ueid = tempcode;
        } else if (this.currentElement.equals("numofsamples")) {
            this.numofsamples = tempcode;
        } else if (this.currentElement.equals("maxvalue")) {
            this.maxvalue = tempcode;
        } else if (this.currentElement.equals("minvalue")) {
            this.minvalue = tempcode;
        } else if (this.currentElement.equals("meanvalue")) {
            this.meanvalue = tempcode;
        } else if (this.currentElement.equals("stddevvalue")) {
            this.standardDeviation = tempcode;
        }
    }

    public void endElement(String url, String name, String qname) {
        StringBuffer buf = new StringBuffer();
        if (name.equalsIgnoreCase("usereventamt")) {
            if (this.trialId.compareTo("0") == 0) {
                this.newTrial = true;
                buf.append("insert into trial (experiment, name, time, node_count, contexts_per_node, threads_per_context, userdata, problem_definition)");
                buf.append(" values ");
                buf.append("(" + this.expid + ", '" + this.trialName + "', '" + this.trialTime + "', " + this.nodenum + ", " + this.contextpnode + ", " + this.threadpcontext + ", '" + this.userData + "', '" + this.problemString + "'); ");
                try {
                    this.getDB().executeUpdate(buf.toString());
                    buf.delete(0, buf.toString().length());
                    if (this.getDB().getDBType().compareTo("mysql") == 0) {
                        buf.append("select LAST_INSERT_ID();");
                    } else {
                        buf.append("select currval('trial_id_seq');");
                    }
                    this.trialId = this.getDB().getDataItem(buf.toString());
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    System.exit(0);
                }
            } else {
                try {
                    this.newTrial = false;
                    buf.append("select id, function_number from function where trial = " + this.trialId + " order by function_number asc;");
                    ResultSet functions = this.getDB().executeQuery(buf.toString());
                    while (functions.next()) {
                        String tmpId = functions.getString(1);
                        int tmpInt = functions.getInt(2);
                        this.funArray[tmpInt] = tmpId;
                    }
                    functions.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    System.exit(0);
                }
            }
            try {
                buf.delete(0, buf.toString().length());
                buf.append("insert into metric (name) values (TRIM('");
                buf.append(this.metricStr);
                buf.append("'));");
                this.getDB().executeUpdate(buf.toString());
                buf.delete(0, buf.toString().length());
                if (this.getDB().getDBType().compareTo("mysql") == 0) {
                    buf.append("select LAST_INSERT_ID();");
                } else {
                    buf.append("select currval('metric_id_seq');");
                }
                this.metricId = this.getDB().getDataItem(buf.toString());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                System.exit(0);
            }
            try {
                buf.delete(0, buf.toString().length());
                buf.append("update xml_file set trial = " + this.trialId);
                buf.append(", metric = " + this.metricId + " where id = " + this.getDocumentId() + ";");
                this.getDB().executeUpdate(buf.toString());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                System.exit(0);
            }
        }
        if (name.equalsIgnoreCase("instrumentedobj")) {
            int tempInt = Integer.parseInt(this.funid);
            if (this.funArray[tempInt] == null) {
                if (this.fungroup.trim().length() == 0) {
                    this.fungroup = "NA";
                }
                buf.delete(0, buf.toString().length());
                buf.append("insert into function (trial, function_number, name, group_name) values (");
                buf.append(this.getTrialId() + ", ");
                buf.append(this.funid + ", '");
                buf.append(this.funname + "', '");
                buf.append(this.fungroup + "');");
                try {
                    this.getDB().executeUpdate(buf.toString());
                    buf.delete(0, buf.toString().length());
                    if (this.getDB().getDBType().compareTo("mysql") == 0) {
                        buf.append("select LAST_INSERT_ID();");
                    } else {
                        buf.append("select currval('function_id_seq');");
                    }
                    this.funArray[tempInt] = this.getDB().getDataItem(buf.toString());
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    System.exit(0);
                }
            }
            buf.delete(0, buf.toString().length());
            buf.append("insert into interval_location_profile (function, node, context, thread, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES ( ");
            buf.append(this.funArray[tempInt] + ", ");
            buf.append(this.nodeid + ", ");
            buf.append(this.contextid + ", ");
            buf.append(this.threadid + ", ");
            buf.append(this.metricId + ", ");
            buf.append(this.inclperc + ", ");
            buf.append(this.incl + ", ");
            buf.append(this.exclperc + ", ");
            buf.append(this.excl + ", ");
            buf.append(this.callnum + ", ");
            buf.append(this.subrs + ", ");
            buf.append(this.inclpcall + ");");
            try {
                this.getDB().executeUpdate(buf.toString());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                System.exit(0);
            }
            this.funname = "";
            this.fungroup = "";
        }
        if (name.equalsIgnoreCase("userevent") && this.newTrial) {
            int ueidInt = Integer.parseInt(this.ueid);
            if (this.ueArray[ueidInt] == null) {
                buf.delete(0, buf.toString().length());
                buf.append("insert into user_event (trial, name, group_name) VALUES (");
                buf.append(this.getTrialId() + ", '");
                buf.append(this.uename + "', '");
                buf.append(this.uegroup + "');");
                try {
                    this.getDB().executeUpdate(buf.toString());
                    buf.delete(0, buf.toString().length());
                    if (this.getDB().getDBType().compareTo("mysql") == 0) {
                        buf.append("select LAST_INSERT_ID();");
                    } else {
                        buf.append("select currval('user_event_id_seq');");
                    }
                    this.ueArray[ueidInt] = this.getDB().getDataItem(buf.toString());
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    System.exit(0);
                }
            }
            buf.delete(0, buf.toString().length());
            buf.append("insert into atomic_location_profile (user_event, node, context, thread, sample_count, maximum_value, minimum_value, mean_value, standard_deviation) VALUES (");
            buf.append(this.ueArray[ueidInt] + ", ");
            buf.append(this.nodeid + ", ");
            buf.append(this.contextid + ", ");
            buf.append(this.threadid + ", ");
            buf.append(this.numofsamples + ", ");
            buf.append(this.maxvalue + ", ");
            buf.append(this.minvalue + ", ");
            buf.append(this.meanvalue + ", ");
            buf.append(this.standardDeviation + ");");
            try {
                this.getDB().executeUpdate(buf.toString());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                System.exit(0);
            }
            this.uename = "";
        }
        if (name.equalsIgnoreCase("totalfunction")) {
            buf.delete(0, buf.toString().length());
            buf.append("insert into interval_total_summary (function, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES ( ");
            buf.append(this.funArray[Integer.parseInt(this.funid)] + ", ");
            buf.append(this.metricId + ", ");
            buf.append(this.inclperc + ", ");
            buf.append(this.incl + ", ");
            buf.append(this.exclperc + ", ");
            buf.append(this.excl + ", ");
            buf.append(this.callnum + ", ");
            buf.append(this.subrs + ", ");
            buf.append(this.inclpcall + ");");
            try {
                this.getDB().executeUpdate(buf.toString());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                System.exit(0);
            }
            this.funname = "";
            this.fungroup = "";
        }
        if (name.equalsIgnoreCase("meanfunction")) {
            buf.delete(0, buf.toString().length());
            buf.append("insert into interval_mean_summary (function, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES ( ");
            buf.append(this.funArray[Integer.parseInt(this.funid)] + ", ");
            buf.append(this.metricId + ", ");
            buf.append(this.inclperc + ", ");
            buf.append(this.incl + ", ");
            buf.append(this.exclperc + ", ");
            buf.append(this.excl + ", ");
            buf.append(this.callnum + ", ");
            buf.append(this.subrs + ", ");
            buf.append(this.inclpcall + ");");
            try {
                this.getDB().executeUpdate(buf.toString());
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                System.exit(0);
            }
            this.funname = "";
            this.fungroup = "";
        }
    }
}

