/*
 * Decompiled with CFR 0.152.
 */
package perfdb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import perfdb.PasswordField;
import perfdb.util.dbinterface.DB;
import perfdb.util.dbinterface.DBConnector;
import perfdb.util.dbinterface.JDBCAcct;
import perfdb.util.dbinterface.ParseConfig;

public class ConnectionManager {
    private String perfdbAcct;
    private String parserClass = "org.apache.xerces.parsers.SAXParser";
    private String dbschema;
    private ParseConfig parser = null;
    private DB db = null;

    public ConnectionManager(String configFileName, String password) {
        this.parser = new ParseConfig(configFileName);
        this.initialize(configFileName, password);
    }

    public ConnectionManager(String configFileName) {
        this.parser = new ParseConfig(configFileName);
        String password = this.getPassword();
        this.initialize(configFileName, password);
        System.out.println("\r\n");
    }

    public void initialize(String configFileName, String password) {
        this.perfdbAcct = this.parser.getDBType().compareTo("mysql") == 0 ? "user=" + this.parser.getDBUserName() + "&password=" + password : "user=" + this.parser.getDBUserName() + ";password=" + password;
        this.dbschema = this.parser.getDBSchema();
    }

    public ParseConfig getParseConfig() {
        return this.parser;
    }

    public void connect() {
        try {
            this.setDB(new DBConnector(new JDBCAcct(this.perfdbAcct), this.parser));
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void connectTest() throws SQLException {
        this.setDB(new DBConnector(new JDBCAcct(this.perfdbAcct), this.parser, true));
    }

    public void connect(String value) {
        this.setPerfdbAcct(value);
        this.connect();
    }

    public String getParserClass() {
        return this.parserClass;
    }

    public String getPerfdbAcct() {
        return this.perfdbAcct;
    }

    public String getSchemafile() {
        return this.dbschema;
    }

    public void dbclose() {
        try {
            if (this.db != null) {
                this.db.close();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setParserClass(String newValue) {
        this.parserClass = newValue;
    }

    public void setPerfdbAcct(String newValue) {
        this.perfdbAcct = newValue;
    }

    public void setDB(DB newValue) {
        this.db = newValue;
    }

    public DB getDB() {
        return this.db;
    }

    public void setSchemafile(String filename) {
        this.dbschema = filename;
    }

    /*
     * WARNING - void declaration
     */
    public void genParentSchema(String filename) {
        File readSchema = new File(filename);
        StringBuffer buf = new StringBuffer();
        if (readSchema.exists()) {
            System.out.println("Found " + filename + "  ... Loading");
        } else {
            System.out.println("Did not find " + filename);
        }
        try {
            String inputString;
            BufferedReader preader = new BufferedReader(new FileReader(readSchema));
            while ((inputString = preader.readLine()) != null) {
                void var3_6;
                buf.append((String)var3_6);
                if (!ConnectionManager.isEnd((String)var3_6)) continue;
                try {
                    this.getDB().executeUpdate(buf.toString());
                    buf = buf.delete(0, buf.length());
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void genParentSchema() {
        this.genParentSchema(this.parser.getDBSchema());
    }

    public static boolean isEnd(String st) {
        return st.trim().endsWith(";");
    }

    public String getPassword() {
        String tmpString;
        block2: {
            tmpString = this.parser.getDBPasswd();
            if (tmpString != null) break block2;
            try {
                PasswordField passwordField = new PasswordField();
                tmpString = passwordField.getPassword(this.parser.getDBUserName() + "'s database password:");
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.exit(0);
            }
        }
        return tmpString;
    }
}

