/*
 * Decompiled with CFR 0.152.
 */
package TauIL.interpreter;

import TauIL.interpreter.DataSource;
import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.ParaProfDataSession;
import edu.uoregon.tau.dms.dss.ParaProfObserver;
import edu.uoregon.tau.dms.dss.TauPprofOutputSession;
import java.io.File;
import java.util.ListIterator;
import java.util.Vector;

class ProfileDataSource
extends DataSource
implements ParaProfObserver {
    private GlobalMapping event_mapping;
    private GlobalMappingElement event;
    private ParaProfDataSession data;
    private Vector files = new Vector();
    private File[] source_file = new File[1];
    private ListIterator iterator;
    private boolean time_metric = true;
    private boolean loading = false;

    protected ProfileDataSource() {
        this("pprof.dat");
    }

    protected ProfileDataSource(String string) {
        this.setFile(string);
    }

    protected void setFile(String string) {
        this.source_file[0] = string == null || string.equals("") ? new File("pprof.dat") : new File(string);
    }

    protected void load() {
        this.data = new TauPprofOutputSession();
        this.files.add(this.source_file);
        this.data.addObserver((ParaProfObserver)this);
        this.loading = true;
        this.data.initialize((Object)this.files);
        while (this.loading) {
        }
    }

    public void update(Object object) {
        this.update();
    }

    public void update() {
        this.data.terminate();
        this.event_mapping = this.data.getGlobalMapping();
        this.iterator = this.event_mapping.getMappingIterator(0);
        this.loading = false;
    }

    protected boolean isTimeMetric() {
        return this.time_metric;
    }

    protected boolean hasNext() {
        return this.iterator.hasNext();
    }

    protected void next() {
        this.event = (GlobalMappingElement)this.iterator.next();
    }

    protected void reset() {
        this.iterator = this.event_mapping.getMappingIterator(0);
    }

    protected String getEventName() {
        return this.event.getMappingName();
    }

    protected double getNumCalls() {
        return this.event.getMaxNumberOfCalls();
    }

    protected double getNumSubRS() {
        return this.event.getMaxNumberOfSubRoutines();
    }

    protected double getPercent() {
        return this.event.getMeanInclusivePercentValue(0);
    }

    protected double getUsec() {
        return this.getExclusiveValue();
    }

    protected double getCount() {
        return this.getExclusiveValue();
    }

    protected double getExclusiveValue() {
        return this.event.getTotalExclusiveValue(0);
    }

    protected double getCumUsec() {
        return this.getInclusiveValue();
    }

    protected double getTotCount() {
        return this.getInclusiveValue();
    }

    protected double getInclusiveValue() {
        return this.event.getTotalInclusiveValue(0);
    }

    protected double getStdDev() {
        return 0.0;
    }

    protected double getUsecsPerCall() {
        return this.getPerCall();
    }

    protected double getCountsPerCall() {
        return this.getPerCall();
    }

    protected double getPerCall() {
        return this.event.getMeanUserSecPerCall(0);
    }
}

