/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.DataSession;
import edu.uoregon.tau.dms.dss.Debug;
import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.ParaProfError;
import edu.uoregon.tau.dms.dss.Thread;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JOptionPane;

public class UtilFncs {
    public static boolean debug = false;
    public static Debug objectDebug = null;

    public static String lpad(String string, int n) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = 32;
        }
        String string2 = new String(cArray, 0, n2);
        return string2.concat(string);
    }

    public static String pad(String string, int n) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = 32;
        }
        return string.concat(new String(cArray, 0, n2));
    }

    public static double adjustDoublePresision(double d, int n) {
        String string = null;
        try {
            String string2 = "#.#";
            for (int i = 0; i < n - 1; ++i) {
                string2 = string2 + "#";
            }
            string2 = string2 + "E0";
            DecimalFormat decimalFormat = new DecimalFormat(string2);
            string = decimalFormat.format(d);
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "UF01");
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static String formatDouble(double d, int n) {
        boolean bl = false;
        String string = Double.toString(d);
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != 'E') continue;
            bl = true;
            break;
        }
        if (!bl) {
            int n2;
            String string2 = "";
            for (n2 = 0; n2 < string.length(); ++n2) {
                string2 = string.charAt(n2) != '.' ? string2 + "#" : string2 + ".";
            }
            n2 = n;
            if (string2.length() < n2) {
                n2 = string2.length();
            }
            if (string2.indexOf(46) + 5 < n2) {
                n2 = string2.indexOf(46) + 5;
            }
            string2 = string2.substring(0, n2);
            DecimalFormat decimalFormat = new DecimalFormat(string2);
            string = decimalFormat.format(d);
            return UtilFncs.lpad(string, n);
        }
        String string3 = "0.0###";
        string3 = string3 + "E0";
        DecimalFormat decimalFormat = new DecimalFormat(string3);
        string = decimalFormat.format(d);
        return UtilFncs.lpad(string, n);
    }

    public static String getOutputString(int n, double d, int n2) {
        switch (n) {
            case 0: {
                return UtilFncs.formatDouble(d, n2);
            }
            case 1: {
                return UtilFncs.formatDouble(d / 1000.0, n2);
            }
            case 2: {
                return UtilFncs.formatDouble(d / 1000000.0, n2);
            }
            case 3: {
                int n3 = 0;
                int n4 = 0;
                n3 = (int)(d / 3.6E9);
                n4 = (int)((d -= (double)n3 * 3.6E9) / 6.0E7);
                String string = Integer.toString(n3);
                String string2 = Integer.toString(n4);
                String string3 = UtilFncs.formatDouble((d -= (double)n4 * 6.0E7) / 1000000.0, 7);
                int n5 = 0;
                for (int i = 0; i < string3.length(); ++i) {
                    if (string3.charAt(i) == ' ') continue;
                    n5 = i;
                    break;
                }
                string3 = string3.substring(n5);
                return UtilFncs.lpad(string + ":" + string2 + ":" + string3, n2);
            }
        }
        UtilFncs.systemError(null, null, "Unexpected string type - UF02 value: " + n);
        return null;
    }

    public static String getUnitsString(int n, boolean bl, boolean bl2) {
        if (bl2) {
            if (!bl) {
                return "counts";
            }
            switch (n) {
                case 0: {
                    return "Derived metric shown in microseconds format";
                }
                case 1: {
                    return "Derived metric shown in milliseconds format";
                }
                case 2: {
                    return "Derived metric shown in seconds format";
                }
                case 3: {
                    return "Derived metric shown in hour:minute:seconds format";
                }
            }
        } else {
            if (!bl) {
                return "counts";
            }
            switch (n) {
                case 0: {
                    return "microseconds";
                }
                case 1: {
                    return "milliseconds";
                }
                case 2: {
                    return "seconds";
                }
                case 3: {
                    return "hour:minute:seconds";
                }
            }
            UtilFncs.systemError(null, null, "Unexpected string type - UF03 value: " + n);
        }
        return null;
    }

    public static String getValueTypeString(int n) {
        switch (n) {
            case 2: {
                return "exclusive";
            }
            case 4: {
                return "inclusive";
            }
            case 6: {
                return "number of calls";
            }
            case 8: {
                return "number of subroutines";
            }
            case 10: {
                return "per call value";
            }
            case 12: {
                return "number of userevents";
            }
            case 14: {
                return "minimum number of userevents";
            }
            case 16: {
                return "maximum number of userevents";
            }
            case 18: {
                return "mean number of userevents";
            }
        }
        UtilFncs.systemError(null, null, "Unexpected string type - UF04 value: " + n);
        return null;
    }

    public static int exists(int[] nArray, int n) {
        if (nArray == null) {
            return -1;
        }
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int exists(Vector vector, int n) {
        if (vector == null) {
            return -1;
        }
        Integer n2 = null;
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            n2 = (Integer)vector.elementAt(i);
            if (n2 != n) continue;
            return i;
        }
        return -1;
    }

    public static void systemError(Object object, Component component, String string) {
        System.out.println("####################################");
        boolean bl = true;
        if (object != null) {
            Object object2;
            if (object instanceof Exception) {
                object2 = (Exception)object;
                if (debug) {
                    System.out.println(((Throwable)object2).toString());
                    ((Throwable)object2).printStackTrace();
                    System.out.println("\n");
                }
                ((Throwable)object2).printStackTrace();
                System.out.println("An error was detected: " + string);
                System.out.println(ParaProfError.contactString);
            }
            if (object instanceof ParaProfError) {
                object2 = (ParaProfError)object;
                if (((ParaProfError)object2).exp != null) {
                    System.out.println(((ParaProfError)object2).exp.toString());
                    ((ParaProfError)object2).exp.printStackTrace();
                    System.out.println("\n");
                }
                if (debug) {
                    if (((ParaProfError)object2).showPopup && ((ParaProfError)object2).popupString != null) {
                        JOptionPane.showMessageDialog(((ParaProfError)object2).component, "ParaProf Error", ((ParaProfError)object2).popupString, 0);
                    }
                    if (((ParaProfError)object2).exp != null) {
                        System.out.println(((ParaProfError)object2).exp.toString());
                        ((ParaProfError)object2).exp.printStackTrace();
                        System.out.println("\n");
                    }
                    if (((ParaProfError)object2).location != null) {
                        System.out.println("Location: " + ((ParaProfError)object2).location);
                    }
                    if (((ParaProfError)object2).s0 != null) {
                        System.out.println(((ParaProfError)object2).s0);
                    }
                    if (((ParaProfError)object2).s1 != null) {
                        System.out.println(((ParaProfError)object2).s1);
                    }
                    if (((ParaProfError)object2).showContactString) {
                        System.out.println(ParaProfError.contactString);
                    }
                } else {
                    if (((ParaProfError)object2).showPopup && ((ParaProfError)object2).popupString != null) {
                        JOptionPane.showMessageDialog(((ParaProfError)object2).component, ((ParaProfError)object2).popupString, "ParaProf Error", 0);
                    }
                    if (((ParaProfError)object2).location != null) {
                        System.out.println("Location: " + ((ParaProfError)object2).location);
                    }
                    if (((ParaProfError)object2).s0 != null) {
                        System.out.println(((ParaProfError)object2).s0);
                    }
                    if (((ParaProfError)object2).s1 != null) {
                        System.out.println(((ParaProfError)object2).s1);
                    }
                    if (((ParaProfError)object2).showContactString) {
                        System.out.println(ParaProfError.contactString);
                    }
                }
                bl = ((ParaProfError)object2).quit;
            } else {
                System.out.println("An error has been detected: " + string);
            }
        } else {
            System.out.println("An error was detected at " + string);
        }
        System.out.println("####################################");
        if (bl) {
            System.exit(0);
        }
    }

    public static void outputData(DataSession dataSession, File file, Component component) {
        try {
            Object object;
            boolean bl = false;
            PrintWriter printWriter = null;
            Vector vector = null;
            GlobalMapping globalMapping = dataSession.getGlobalMapping();
            int n = dataSession.getNumberOfMetrics();
            StringBuffer stringBuffer = new StringBuffer(1000);
            if (file != null) {
                printWriter = new PrintWriter(new FileWriter(file));
                bl = true;
            }
            if (bl) {
                printWriter.println("<metrics>");
                printWriter.println("<numofmetrics>" + n + "</numofmetrics>");
            } else {
                System.out.println("<metrics>");
                System.out.println("<numofmetrics>" + n + "</numofmetrics>");
            }
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    printWriter.println(dataSession.getMetricName(i));
                    continue;
                }
                System.out.println(dataSession.getMetricName(i));
            }
            if (bl) {
                printWriter.println("</metrics>");
            } else {
                System.out.println("</metrics>");
            }
            vector = globalMapping.getMapping(0);
            if (bl) {
                printWriter.println("<funnameidmap>");
                printWriter.println("<numoffunctions>" + vector.size() + "</numoffunctions>");
            } else {
                System.out.println("<funnameidmap>");
                System.out.println("<numoffunctions>" + vector.size() + "</numoffunctions>");
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (GlobalMappingElement)enumeration.nextElement();
                if (bl) {
                    printWriter.println("\"" + ((GlobalMappingElement)object).getMappingName() + "\"" + ((GlobalMappingElement)object).getMappingID());
                    continue;
                }
                System.out.println("\"" + ((GlobalMappingElement)object).getMappingName() + "\"" + ((GlobalMappingElement)object).getMappingID());
            }
            if (bl) {
                printWriter.println("</funnameidmap>");
            } else {
                System.out.println("</funnameidmap>");
            }
            if (bl) {
                printWriter.println("id mincl(..) mexcl(..) minclp(..) mexclp(..) museccall(..) mnoc mnos");
            } else {
                System.out.println("id mincl(..) mexcl(..) minclp(..) mexclp(..) museccall(..) mnoc mnos");
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.delete(0, stringBuffer.length());
                object = (GlobalMappingElement)enumeration.nextElement();
                stringBuffer.append(((GlobalMappingElement)object).getMappingID() + " ");
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(((GlobalMappingElement)object).getMeanInclusiveValue(i) + " ");
                    stringBuffer.append(((GlobalMappingElement)object).getMeanExclusiveValue(i) + " ");
                    stringBuffer.append(((GlobalMappingElement)object).getMeanInclusivePercentValue(i) + " ");
                    stringBuffer.append(((GlobalMappingElement)object).getMeanExclusivePercentValue(i) + " ");
                    stringBuffer.append(((GlobalMappingElement)object).getMeanUserSecPerCall(i) + " ");
                }
                stringBuffer.append(((GlobalMappingElement)object).getMeanNumberOfCalls() + " ");
                stringBuffer.append(((GlobalMappingElement)object).getMeanNumberOfSubRoutines() + "");
                if (bl) {
                    printWriter.println(stringBuffer);
                    continue;
                }
                System.out.println(stringBuffer);
            }
            vector = globalMapping.getMapping(2);
            if (bl) {
                printWriter.println("<usereventnameidmap>");
                printWriter.println("<numofuserevents>" + vector.size() + "</numofuserevents>");
            } else {
                System.out.println("<usereventnameidmap>");
                System.out.println("<numofuserevents>" + vector.size() + "</numofuserevents>");
            }
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (GlobalMappingElement)enumeration.nextElement();
                if (bl) {
                    printWriter.println("\"" + ((GlobalMappingElement)object).getMappingName() + "\"" + ((GlobalMappingElement)object).getMappingID());
                    continue;
                }
                System.out.println("\"" + ((GlobalMappingElement)object).getMappingName() + "\"" + ((GlobalMappingElement)object).getMappingID());
            }
            if (bl) {
                printWriter.println("</usereventnameidmap>");
            } else {
                System.out.println("</usereventnameidmap>");
            }
            if (bl) {
                printWriter.println("<threaddata>");
                printWriter.println("funid incl(..) excl(..) inclp(..) exclp(..) useccall(..) mnoc mnos");
                printWriter.println("usereventid num min max mean");
                printWriter.println("<numofthreads>" + dataSession.getNCT().getTotalNumberOfThreads() + "</numofthreads>");
            } else {
                System.out.println("<threaddata>");
                System.out.println("id incl(..) excl(..) inclp(..) exclp(..) useccall(..) noc nos");
                System.out.println("usereventid num min max mean");
                System.out.println("<numofthreads>" + dataSession.getNCT().getTotalNumberOfThreads() + "</numofthreads>");
            }
            enumeration = null;
            object = dataSession.getNCT().getNodes().elements();
            while (object.hasMoreElements()) {
                Node node = (Node)object.nextElement();
                Enumeration enumeration2 = node.getContexts().elements();
                while (enumeration2.hasMoreElements()) {
                    Context context = (Context)enumeration2.nextElement();
                    Enumeration enumeration3 = context.getThreads().elements();
                    while (enumeration3.hasMoreElements()) {
                        int n2;
                        GlobalThreadDataElement globalThreadDataElement;
                        Thread thread = (Thread)enumeration3.nextElement();
                        ListIterator listIterator = null;
                        if (bl) {
                            printWriter.println("<thread>" + thread.getNodeID() + "," + thread.getContextID() + "," + thread.getThreadID() + "</thread");
                        } else {
                            System.out.println("<thread>" + thread.getNodeID() + "," + thread.getContextID() + "," + thread.getThreadID() + "</thread");
                        }
                        if (bl) {
                            printWriter.println("<functiondata>");
                        } else {
                            System.out.println("<functiondata>");
                        }
                        listIterator = thread.getFunctionListIterator();
                        while (listIterator.hasNext()) {
                            stringBuffer.delete(0, stringBuffer.length());
                            globalThreadDataElement = (GlobalThreadDataElement)listIterator.next();
                            if (globalThreadDataElement == null) continue;
                            stringBuffer.append(globalThreadDataElement.getMappingID() + " ");
                            for (n2 = 0; n2 < n; ++n2) {
                                stringBuffer.append(globalThreadDataElement.getInclusiveValue(n2) + " ");
                                stringBuffer.append(globalThreadDataElement.getExclusiveValue(n2) + " ");
                                stringBuffer.append(globalThreadDataElement.getInclusivePercentValue(n2) + " ");
                                stringBuffer.append(globalThreadDataElement.getExclusivePercentValue(n2) + " ");
                                stringBuffer.append(globalThreadDataElement.getUserSecPerCall(n2) + " ");
                            }
                            stringBuffer.append(globalThreadDataElement.getNumberOfCalls() + " ");
                            stringBuffer.append(globalThreadDataElement.getNumberOfSubRoutines() + "");
                            if (bl) {
                                printWriter.println(stringBuffer);
                                continue;
                            }
                            System.out.println(stringBuffer);
                        }
                        if (bl) {
                            printWriter.println("</functiondata>");
                        } else {
                            System.out.println("</functiondata>");
                        }
                        if (bl) {
                            printWriter.println("<usereventdata>");
                        } else {
                            System.out.println("<usereventdata>");
                        }
                        listIterator = thread.getUsereventListIterator();
                        while (listIterator.hasNext()) {
                            stringBuffer.delete(0, stringBuffer.length());
                            globalThreadDataElement = (GlobalThreadDataElement)listIterator.next();
                            if (globalThreadDataElement == null) continue;
                            stringBuffer.append(globalThreadDataElement.getMappingID() + " ");
                            for (n2 = 0; n2 < n; ++n2) {
                                stringBuffer.append(globalThreadDataElement.getUserEventNumberValue() + " ");
                                stringBuffer.append(globalThreadDataElement.getUserEventMinValue() + " ");
                                stringBuffer.append(globalThreadDataElement.getUserEventMaxValue() + " ");
                                stringBuffer.append(globalThreadDataElement.getUserEventMeanValue() + "");
                            }
                            if (bl) {
                                printWriter.println(stringBuffer);
                                continue;
                            }
                            System.out.println(stringBuffer);
                        }
                        if (bl) {
                            printWriter.println("</usereventdata>");
                            continue;
                        }
                        System.out.println("</usereventdata>");
                    }
                }
            }
            if (bl) {
                printWriter.println("</threaddata>");
            } else {
                System.out.println("</threaddata>");
            }
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError(new ParaProfError("UF05", "File write error! Check console for details.", "An error occurred whilst trying to save txt file.", null, exception, component, null, null, true, false, false), null, null);
        }
    }
}

