/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.database.ConnectionManager;
import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.dss.Application;
import edu.uoregon.tau.dms.dss.AtomicEvent;
import edu.uoregon.tau.dms.dss.AtomicLocationProfile;
import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.DataSession;
import edu.uoregon.tau.dms.dss.DataSessionIterator;
import edu.uoregon.tau.dms.dss.Experiment;
import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.IntervalEvent;
import edu.uoregon.tau.dms.dss.IntervalLocationProfile;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.Trial;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;

public class PerfDMFSession
extends DataSession {
    private DB db = null;
    private ConnectionManager connector;
    private Hashtable intervalEventHash = null;
    private Hashtable atomicEventHash = null;
    private String configFileName = null;

    public DB db() {
        return this.db;
    }

    public void setDB(DB dB) {
        this.db = dB;
    }

    public void initialize(Object object) {
        try {
            this.initialize(object, true, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public void initialize(Object object, boolean bl, boolean bl2) throws Exception {
        this.configFileName = new String((String)object);
        try {
            this.connector = new ConnectionManager(this.configFileName, bl);
            this.connector.connect();
            this.db = this.connector.getDB();
        }
        catch (Exception exception) {
            if (bl2) {
                System.exit(0);
            }
            throw exception;
        }
    }

    public void initialize(Object object, String string, boolean bl) throws Exception {
        String string2 = (String)object;
        try {
            this.connector = new ConnectionManager(string2, string);
            this.connector.connect();
            this.db = this.connector.getDB();
        }
        catch (Exception exception) {
            if (bl) {
                System.exit(0);
            }
            throw exception;
        }
    }

    public void terminate() {
        this.connector.dbclose();
    }

    public ConnectionManager getConnector() {
        return this.connector;
    }

    public ListIterator getApplicationList() {
        String string = "";
        return new DataSessionIterator(Application.getApplicationList(this.db, string));
    }

    public ListIterator getExperimentList() {
        String string = "";
        if (this.application != null) {
            string = "WHERE application = " + this.application.getID();
        }
        return new DataSessionIterator(Experiment.getExperimentList(this.db, string));
    }

    public ListIterator getTrialList() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.experiment != null) {
            stringBuffer.append("WHERE t.experiment = " + this.experiment.getID());
        } else if (this.application != null) {
            stringBuffer.append("WHERE e.application = " + this.application.getID());
        }
        return new DataSessionIterator(Trial.getTrialList(this.db, stringBuffer.toString()));
    }

    public Application setApplication(int n) {
        this.application = null;
        this.experiment = null;
        this.trial = null;
        this.intervalEventHash = null;
        this.atomicEventHash = null;
        String string = " WHERE id = " + n;
        Vector vector = Application.getApplicationList(this.db, string);
        if (vector.size() == 1) {
            this.application = (Application)vector.elementAt(0);
        }
        return this.application;
    }

    public Application setApplication(String string, String string2) {
        Vector vector;
        this.application = null;
        this.experiment = null;
        this.trial = null;
        this.intervalEventHash = null;
        this.atomicEventHash = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE name = '" + string + "'");
        if (string2 != null) {
            stringBuffer.append(" AND version = " + string2);
        }
        if ((vector = Application.getApplicationList(this.db, stringBuffer.toString())).size() == 1) {
            this.application = (Application)vector.elementAt(0);
        }
        return this.application;
    }

    public Experiment setExperiment(int n) {
        this.experiment = null;
        this.trial = null;
        this.intervalEventHash = null;
        this.atomicEventHash = null;
        String string = " WHERE id = " + n;
        Vector vector = Experiment.getExperimentList(this.db, string);
        if (vector.size() == 1) {
            this.experiment = (Experiment)vector.elementAt(0);
        }
        return this.experiment;
    }

    public Trial setTrial(int n) {
        return this.setTrial(n, true);
    }

    private Trial setTrial(int n, boolean bl) {
        String string;
        Vector vector;
        this.trial = null;
        this.metrics = null;
        if (bl) {
            this.intervalEventHash = null;
            this.atomicEventHash = null;
        }
        if ((vector = Trial.getTrialList(this.db, string = " WHERE t.id = " + n)).size() == 1) {
            this.trial = (Trial)vector.elementAt(0);
        }
        return this.trial;
    }

    public ListIterator getIntervalEvents() {
        String string = new String();
        if (this.trial != null) {
            string = " WHERE trial = " + this.trial.getID();
        } else if (this.experiment != null) {
            string = " WHERE experiment = " + this.experiment.getID();
        } else if (this.application != null) {
            string = " WHERE application = " + this.application.getID();
        }
        this.intervalEvents = IntervalEvent.getIntervalEvents(this, this.db, string);
        if (this.intervalEventHash == null) {
            this.intervalEventHash = new Hashtable();
        }
        Enumeration enumeration = this.intervalEvents.elements();
        while (enumeration.hasMoreElements()) {
            IntervalEvent intervalEvent = (IntervalEvent)enumeration.nextElement();
            this.intervalEventHash.put(new Integer(intervalEvent.getID()), intervalEvent);
        }
        return new DataSessionIterator(this.intervalEvents);
    }

    public void getIntervalEventDetail(IntervalEvent intervalEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE ms.interval_event = " + intervalEvent.getID());
        if (this.metrics != null && this.metrics.size() > 0) {
            stringBuffer.append(" AND ms.metric in (");
            Enumeration enumeration = this.metrics.elements();
            while (enumeration.hasMoreElements()) {
                Metric metric = (Metric)enumeration.nextElement();
                stringBuffer.append(metric.getID());
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        IntervalLocationProfile.getIntervalEventDetail(this.db, intervalEvent, stringBuffer.toString());
    }

    public void getAtomicEventDetail(AtomicEvent atomicEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" WHERE e.id = " + atomicEvent.getID());
        AtomicLocationProfile.getAtomicEventDetail(this.db, atomicEvent, stringBuffer.toString());
    }

    public ListIterator getAtomicEvents() {
        String string = new String();
        if (this.trial != null) {
            string = " WHERE t.id = " + this.trial.getID();
        } else if (this.experiment != null) {
            string = " WHERE t.experiment = " + this.experiment.getID();
        } else if (this.application != null) {
            string = " WHERE e.application = " + this.application.getID();
        }
        this.atomicEvents = AtomicEvent.getAtomicEvents(this, this.db, string);
        if (this.atomicEventHash == null) {
            this.atomicEventHash = new Hashtable();
        }
        Enumeration enumeration = this.atomicEvents.elements();
        while (enumeration.hasMoreElements()) {
            AtomicEvent atomicEvent = (AtomicEvent)enumeration.nextElement();
            this.atomicEventHash.put(new Integer(atomicEvent.getID()), atomicEvent);
        }
        return new DataSessionIterator(this.atomicEvents);
    }

    public IntervalEvent setIntervalEvent(int n) {
        IntervalEvent intervalEvent = null;
        this.intervalEvents = new Vector();
        intervalEvent = this.getIntervalEvent(n);
        if (intervalEvent != null) {
            this.intervalEvents.addElement(intervalEvent);
        }
        this.setTrial(intervalEvent.getTrialID(), false);
        return intervalEvent;
    }

    public AtomicEvent setAtomicEvent(int n) {
        AtomicEvent atomicEvent = null;
        this.atomicEvents = new Vector();
        atomicEvent = this.getAtomicEvent(n);
        if (atomicEvent != null) {
            this.atomicEvents.addElement(atomicEvent);
        }
        return atomicEvent;
    }

    public ListIterator getIntervalEventData() {
        Object object;
        Enumeration enumeration;
        if (this.trial == null && this.intervalEvents == null) {
            System.out.println("Please select a trial or a set of intervalEvents before getting intervalEvent data.");
            return null;
        }
        if (this.intervalEvents == null) {
            this.getIntervalEvents();
        }
        int n = 0;
        n = this.metrics != null && this.metrics.size() > 0 ? this.metrics.size() : this.trial.getMetricCount();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.trial != null) {
            stringBuffer.append(" WHERE e.trial = " + this.trial.getID());
            bl = true;
        }
        if (this.intervalEvents != null && this.intervalEvents.size() > 0) {
            if (bl) {
                stringBuffer.append(" AND p.interval_event in (");
            } else {
                stringBuffer.append(" WHERE p.interval_event in (");
            }
            enumeration = this.intervalEvents.elements();
            while (enumeration.hasMoreElements()) {
                object = (IntervalEvent)enumeration.nextElement();
                stringBuffer.append(((IntervalEvent)object).getID());
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.nodes != null && this.nodes.size() > 0) {
            stringBuffer.append(" AND p.node IN (");
            enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                stringBuffer.append(object);
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.contexts != null && this.contexts.size() > 0) {
            stringBuffer.append(" AND p.context IN (");
            enumeration = this.contexts.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                stringBuffer.append(object);
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.threads != null && this.threads.size() > 0) {
            stringBuffer.append(" AND p.thread IN (");
            enumeration = this.threads.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                stringBuffer.append(object);
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.metrics != null && this.metrics.size() > 0) {
            stringBuffer.append(" AND p.metric IN (");
            enumeration = this.metrics.elements();
            while (enumeration.hasMoreElements()) {
                object = (Metric)enumeration.nextElement();
                stringBuffer.append(((Metric)object).getID());
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        this.intervalEventData = IntervalLocationProfile.getIntervalEventData(this.db, n, stringBuffer.toString());
        return new DataSessionIterator(this.intervalEventData);
    }

    public ListIterator getAtomicEventData() {
        Object object;
        Enumeration enumeration;
        if (this.trial == null && this.atomicEvents == null) {
            System.out.println("Please select a trial or a set of user events before getting user event data.");
            return null;
        }
        if (this.atomicEvents == null) {
            this.getAtomicEvents();
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.trial != null) {
            stringBuffer.append(" WHERE e.trial = " + this.trial.getID());
            bl = true;
        }
        if (this.atomicEvents != null && this.atomicEvents.size() > 0) {
            if (bl) {
                stringBuffer.append(" AND e.id IN (");
            } else {
                stringBuffer.append(" WHERE e.id IN (");
            }
            enumeration = this.atomicEvents.elements();
            while (enumeration.hasMoreElements()) {
                object = (AtomicEvent)enumeration.nextElement();
                stringBuffer.append(((AtomicEvent)object).getID());
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.nodes != null && this.nodes.size() > 0) {
            stringBuffer.append(" AND p.node IN (");
            enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                stringBuffer.append(object);
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.contexts != null && this.contexts.size() > 0) {
            stringBuffer.append(" AND p.context IN (");
            enumeration = this.contexts.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                stringBuffer.append(object);
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        if (this.threads != null && this.threads.size() > 0) {
            stringBuffer.append(" AND p.thread IN (");
            enumeration = this.threads.elements();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                stringBuffer.append(object);
                if (enumeration.hasMoreElements()) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(") ");
            }
        }
        this.atomicEventData = AtomicLocationProfile.getAtomicEventData(this.db, stringBuffer.toString());
        return new DataSessionIterator(this.atomicEventData);
    }

    public IntervalEvent getIntervalEvent(int n) {
        IntervalEvent intervalEvent = null;
        if (this.intervalEventHash != null) {
            intervalEvent = (IntervalEvent)this.intervalEventHash.get(new Integer(n));
        }
        if (intervalEvent == null) {
            String string = " WHERE id = " + n;
            Vector vector = IntervalEvent.getIntervalEvents(this, this.db, string);
            if (vector.size() == 1) {
                intervalEvent = (IntervalEvent)vector.elementAt(0);
            }
            if (this.intervalEventHash == null) {
                this.intervalEventHash = new Hashtable();
            }
            this.intervalEventHash.put(new Integer(intervalEvent.getID()), intervalEvent);
        }
        return intervalEvent;
    }

    public AtomicEvent getAtomicEvent(int n) {
        AtomicEvent atomicEvent = null;
        if (this.atomicEventHash != null) {
            atomicEvent = (AtomicEvent)this.atomicEventHash.get(new Integer(n));
        }
        if (atomicEvent == null) {
            String string = " WHERE u.id = " + n;
            Vector vector = AtomicEvent.getAtomicEvents(this, this.db, string);
            if (vector.size() == 1) {
                atomicEvent = (AtomicEvent)vector.elementAt(0);
            }
            if (this.atomicEventHash == null) {
                this.atomicEventHash = new Hashtable();
            }
            this.atomicEventHash.put(new Integer(atomicEvent.getID()), atomicEvent);
        }
        return atomicEvent;
    }

    public int saveApplication(Application application) {
        return application.saveApplication(this.db);
    }

    public int saveExperiment(Experiment experiment) {
        return experiment.saveExperiment(this.db);
    }

    public int saveTrial() {
        int n = this.trial.saveTrial(this.db);
        return n;
    }

    private Hashtable saveMetrics(int n, Trial trial, int n2) {
        System.out.print("Saving the metrics: ");
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Enumeration enumeration = trial.getDataSession().getMetrics().elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            Metric metric = (Metric)enumeration.nextElement();
            int n4 = 0;
            if (n2 < 0 || n2 == n3) {
                n4 = metric.saveMetric(this.db, n);
                System.out.print("\rSaving the metrics: " + (n3 + 1) + " records saved...");
            }
            hashtable.put(new Integer(n3), new Integer(n4));
            ++n3;
        }
        System.out.print("\n");
        return hashtable;
    }

    private Hashtable saveIntervalEvents(int n, Hashtable hashtable, int n2) {
        System.out.print("Saving the intervalEvents: ");
        Hashtable<Integer, Integer> hashtable2 = new Hashtable<Integer, Integer>();
        Enumeration enumeration = this.intervalEvents.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            IntervalEvent intervalEvent = (IntervalEvent)enumeration.nextElement();
            int n4 = intervalEvent.saveIntervalEvent(this.db, n, hashtable, n2);
            hashtable2.put(new Integer(intervalEvent.getID()), new Integer(n4));
            System.out.print("\rSaving the intervalEvents: " + ++n3 + " records saved...");
        }
        System.out.print("\n");
        return hashtable2;
    }

    private void saveIntervalEventData(Hashtable hashtable, Hashtable hashtable2, int n) {
        Enumeration enumeration = this.intervalEventData.elements();
        IntervalLocationProfile.saveIntervalEventData(this.db, hashtable, enumeration, hashtable2, n);
    }

    private Hashtable saveAtomicEvents(int n) {
        System.out.print("Saving the user events:");
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Enumeration enumeration = this.atomicEvents.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            AtomicEvent atomicEvent = (AtomicEvent)enumeration.nextElement();
            int n3 = atomicEvent.saveAtomicEvent(this.db, n);
            hashtable.put(new Integer(atomicEvent.getID()), new Integer(n3));
            System.out.print("\rSaving the user events: " + ++n2 + " records saved...");
        }
        System.out.print("\n");
        return hashtable;
    }

    private void saveAtomicEventData(Hashtable hashtable) {
        System.out.print("Saving the user event data:");
        Enumeration enumeration = this.atomicEventData.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            AtomicLocationProfile atomicLocationProfile = (AtomicLocationProfile)enumeration.nextElement();
            Integer n2 = (Integer)hashtable.get(new Integer(atomicLocationProfile.getAtomicEventID()));
            atomicLocationProfile.saveAtomicEventData(this.db, n2);
            System.out.print("\rSaving the user event data: " + ++n + " records saved...");
        }
        System.out.print("\n");
    }

    public int saveTrial(Trial trial) {
        return trial.saveTrial(this.db);
    }

    public int saveIntervalEvent(IntervalEvent intervalEvent, int n, Hashtable hashtable) {
        return intervalEvent.saveIntervalEvent(this.db, n, hashtable, -1);
    }

    public void saveIntervalEventData(IntervalLocationProfile intervalLocationProfile, int n, Hashtable hashtable) {
        intervalLocationProfile.saveIntervalEventData(this.db, n, hashtable, -1);
    }

    public int saveAtomicEvent(AtomicEvent atomicEvent, int n) {
        return atomicEvent.saveAtomicEvent(this.db, n);
    }

    public void saveAtomicEventData(AtomicLocationProfile atomicLocationProfile, int n) {
        atomicLocationProfile.saveAtomicEventData(this.db, n);
    }

    public int saveParaProfTrial(Trial trial, int n) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Serializable serializable2;
        long l = System.currentTimeMillis();
        GlobalMapping globalMapping = trial.getDataSession().getGlobalMapping();
        Vector vector = globalMapping.getMapping(1);
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            GlobalMappingElement globalMappingElement = (GlobalMappingElement)enumeration.nextElement();
            stringArray[n2++] = globalMappingElement.getMappingName();
        }
        this.metrics = trial.getDataSession().getMetrics();
        int n3 = this.metrics.size();
        System.out.println("Found " + n3 + " metrics...");
        this.intervalEvents = new Vector();
        this.intervalEventData = new Vector();
        this.atomicEvents = new Vector();
        this.atomicEventData = new Vector();
        int n4 = 0;
        int n5 = 0;
        System.out.print("Creating the intervalEvents:");
        Object object4 = globalMapping.getMapping(0).elements();
        while (object4.hasMoreElements()) {
            serializable2 = (GlobalMappingElement)object4.nextElement();
            if (serializable2 == null) continue;
            object3 = new IntervalEvent(this);
            ((IntervalEvent)object3).setName(((GlobalMappingElement)serializable2).getMappingName());
            ((IntervalEvent)object3).setID(((GlobalMappingElement)serializable2).getMappingID());
            object2 = ((GlobalMappingElement)serializable2).getGroups();
            serializable = new StringBuffer();
            for (int i = 0; i < ((GlobalMappingElement)serializable2).getNumberOfGroups(); ++i) {
                if (i > 0) {
                    ((StringBuffer)serializable).append("|");
                }
                ((StringBuffer)serializable).append(stringArray[object2[i]]);
            }
            if (((GlobalMappingElement)serializable2).getNumberOfGroups() > 0) {
                ((IntervalEvent)object3).setGroup(((StringBuffer)serializable).toString());
            }
            this.intervalEvents.add(object3);
            System.out.print("\rCreating the intervalEvents: " + ++n4 + " intervalEvents found...");
            IntervalLocationProfile intervalLocationProfile = new IntervalLocationProfile(n3);
            object = new IntervalLocationProfile(n3);
            for (int i = 0; i < n3; ++i) {
                intervalLocationProfile.setNumCalls((int)((GlobalMappingElement)serializable2).getTotalNumberOfCalls());
                intervalLocationProfile.setNumSubroutines((int)((GlobalMappingElement)serializable2).getTotalNumberOfSubRoutines());
                intervalLocationProfile.setInclusivePercentage(i, ((GlobalMappingElement)serializable2).getTotalInclusivePercentValue(i));
                intervalLocationProfile.setInclusive(i, ((GlobalMappingElement)serializable2).getTotalInclusiveValue(i));
                intervalLocationProfile.setExclusivePercentage(i, ((GlobalMappingElement)serializable2).getTotalExclusivePercentValue(i));
                intervalLocationProfile.setExclusive(i, ((GlobalMappingElement)serializable2).getTotalExclusiveValue(i));
                intervalLocationProfile.setInclusivePerCall(i, ((GlobalMappingElement)serializable2).getTotalUserSecPerCall(i));
                ((IntervalLocationProfile)object).setNumCalls((int)((GlobalMappingElement)serializable2).getMeanNumberOfCalls());
                ((IntervalLocationProfile)object).setNumSubroutines((int)((GlobalMappingElement)serializable2).getMeanNumberOfSubRoutines());
                ((IntervalLocationProfile)object).setInclusivePercentage(i, ((GlobalMappingElement)serializable2).getMeanInclusivePercentValue(i));
                ((IntervalLocationProfile)object).setInclusive(i, ((GlobalMappingElement)serializable2).getMeanInclusiveValue(i));
                ((IntervalLocationProfile)object).setExclusivePercentage(i, ((GlobalMappingElement)serializable2).getMeanExclusivePercentValue(i));
                ((IntervalLocationProfile)object).setExclusive(i, ((GlobalMappingElement)serializable2).getMeanExclusiveValue(i));
                ((IntervalLocationProfile)object).setInclusivePerCall(i, ((GlobalMappingElement)serializable2).getMeanUserSecPerCall(i));
            }
            ((IntervalEvent)object3).setTotalSummary(intervalLocationProfile);
            ((IntervalEvent)object3).setMeanSummary((IntervalLocationProfile)object);
        }
        System.out.print("\nCreating user events:");
        object4 = globalMapping.getMapping(2).elements();
        while (object4.hasMoreElements()) {
            serializable2 = (GlobalMappingElement)object4.nextElement();
            if (serializable2 == null) continue;
            System.out.print(".");
            System.out.print("\rCreating the user events: " + ++n5 + " user events found...");
            object3 = new AtomicEvent(this);
            ((AtomicEvent)object3).setName(((GlobalMappingElement)serializable2).getMappingName());
            ((AtomicEvent)object3).setID(((GlobalMappingElement)serializable2).getMappingID());
            object2 = ((GlobalMappingElement)serializable2).getGroups();
            serializable = new StringBuffer();
            for (int i = 0; i < ((GlobalMappingElement)serializable2).getNumberOfGroups(); ++i) {
                if (i > 0) {
                    ((StringBuffer)serializable).append("|");
                }
                ((StringBuffer)serializable).append(stringArray[object2[i]]);
            }
            ((AtomicEvent)object3).setGroup(((StringBuffer)serializable).toString());
            this.atomicEvents.add(object3);
        }
        n4 = 0;
        n5 = 0;
        System.out.print("\nCreating the intervalEvent / user event data:");
        object4 = new StringBuffer(10);
        serializable2 = trial.getDataSession().getNCT().getNodes();
        object3 = ((Vector)serializable2).elements();
        while (object3.hasMoreElements()) {
            object2 = (Node)object3.nextElement();
            serializable = object2.getContexts();
            Enumeration enumeration2 = ((Vector)serializable).elements();
            while (enumeration2.hasMoreElements()) {
                object = (Context)enumeration2.nextElement();
                Vector vector2 = ((Context)object).getThreads();
                Enumeration enumeration3 = vector2.elements();
                while (enumeration3.hasMoreElements()) {
                    Object object5;
                    GlobalThreadDataElement globalThreadDataElement;
                    Thread thread = (Thread)enumeration3.nextElement();
                    Vector vector3 = thread.getFunctionList();
                    Vector vector4 = thread.getUsereventList();
                    Enumeration enumeration4 = vector3.elements();
                    while (enumeration4.hasMoreElements()) {
                        globalThreadDataElement = (GlobalThreadDataElement)enumeration4.nextElement();
                        if (globalThreadDataElement == null) continue;
                        if (n4 % 1000 == 0) {
                            System.out.print("\rCreating the intervalEvent / user event data: " + ++n4 + " / " + n5 + " found...");
                        }
                        ++n4;
                        object5 = new IntervalLocationProfile(n3);
                        ((IntervalLocationProfile)object5).setNode(thread.getNodeID());
                        ((IntervalLocationProfile)object5).setContext(thread.getContextID());
                        ((IntervalLocationProfile)object5).setThread(thread.getThreadID());
                        ((IntervalLocationProfile)object5).setIntervalEventID(globalThreadDataElement.getMappingID());
                        ((IntervalLocationProfile)object5).setNumCalls(globalThreadDataElement.getNumberOfCalls());
                        ((IntervalLocationProfile)object5).setNumSubroutines(globalThreadDataElement.getNumberOfSubRoutines());
                        for (int i = 0; i < n3; ++i) {
                            ((IntervalLocationProfile)object5).setInclusive(i, globalThreadDataElement.getInclusiveValue(i));
                            ((IntervalLocationProfile)object5).setExclusive(i, globalThreadDataElement.getExclusiveValue(i));
                            ((IntervalLocationProfile)object5).setInclusivePercentage(i, globalThreadDataElement.getInclusivePercentValue(i));
                            ((IntervalLocationProfile)object5).setExclusivePercentage(i, globalThreadDataElement.getExclusivePercentValue(i));
                            ((IntervalLocationProfile)object5).setInclusivePerCall(i, globalThreadDataElement.getUserSecPerCall(i));
                        }
                        this.intervalEventData.add(object5);
                    }
                    if (vector4 == null) continue;
                    enumeration4 = vector4.elements();
                    while (enumeration4.hasMoreElements()) {
                        globalThreadDataElement = (GlobalThreadDataElement)enumeration4.nextElement();
                        if (globalThreadDataElement == null) continue;
                        if (n5 % 1000 == 0) {
                            System.out.print("\rCreating the intervalEvent / user event data: " + n4 + " / " + n5 + " found...");
                        }
                        ++n5;
                        object5 = new AtomicLocationProfile();
                        ((AtomicLocationProfile)object5).setAtomicEventID(globalThreadDataElement.getMappingID());
                        ((AtomicLocationProfile)object5).setNode(thread.getNodeID());
                        ((AtomicLocationProfile)object5).setContext(thread.getContextID());
                        ((AtomicLocationProfile)object5).setThread(thread.getThreadID());
                        ((AtomicLocationProfile)object5).setSampleCount(globalThreadDataElement.getUserEventNumberValue());
                        ((AtomicLocationProfile)object5).setMaximumValue(globalThreadDataElement.getUserEventMaxValue());
                        ((AtomicLocationProfile)object5).setMinimumValue(globalThreadDataElement.getUserEventMinValue());
                        ((AtomicLocationProfile)object5).setMeanValue(globalThreadDataElement.getUserEventMeanValue());
                        ((AtomicLocationProfile)object5).setSumSquared(globalThreadDataElement.getUserEventSumSquared());
                        this.atomicEventData.add(object5);
                    }
                }
            }
        }
        int n6 = 0;
        if (n < 0) {
            System.out.println("\nSaving the trial...");
            n6 = trial.saveTrial(this.db);
            object2 = this.saveMetrics(n6, trial, n);
            if (this.intervalEvents != null && this.intervalEvents.size() > 0) {
                serializable = this.saveIntervalEvents(n6, (Hashtable)object2, n);
                this.saveIntervalEventData((Hashtable)serializable, (Hashtable)object2, n);
            }
            if (this.atomicEvents != null && this.atomicEvents.size() > 0) {
                serializable = this.saveAtomicEvents(n6);
                if (this.atomicEventData != null && this.atomicEventData.size() > 0) {
                    this.saveAtomicEventData((Hashtable)serializable);
                }
            }
            System.out.println("New Trial ID: " + n6);
        } else {
            n6 = trial.getID();
            System.out.println("\nSaving the metric...");
            object2 = this.saveMetrics(n6, trial, n);
            if (this.intervalEvents != null && this.intervalEvents.size() > 0) {
                serializable = this.saveIntervalEvents(n6, (Hashtable)object2, n);
                this.saveIntervalEventData((Hashtable)serializable, (Hashtable)object2, n);
            }
            System.out.println("Modified Trial ID: " + n6);
        }
        this.vacuumDatabase();
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)l3 / 1000.0;
        System.out.println("Elapsed time: " + d + " seconds.");
        return n6;
    }

    private void vacuumDatabase() {
        if (this.db.getDBType().compareTo("mysql") == 0) {
            return;
        }
        if (this.db.getDBType().compareTo("db2") == 0) {
            return;
        }
    }

    public int saveApplication() {
        int n = 0;
        if (this.application != null) {
            n = this.application.saveApplication(this.db);
        }
        return n;
    }

    public int saveExperiment() {
        int n = 0;
        if (this.experiment != null) {
            n = this.experiment.saveExperiment(this.db);
        }
        return n;
    }

    public void deleteTrial(int n) {
        Trial.deleteTrial(this.db, n);
    }

    public void deleteExperiment(int n) {
        PerfDMFSession perfDMFSession = new PerfDMFSession();
        perfDMFSession.setDB(this.db());
        perfDMFSession.setExperiment(n);
        ListIterator listIterator = perfDMFSession.getTrialList();
        while (listIterator.hasNext()) {
            Trial trial = (Trial)listIterator.next();
            Trial.deleteTrial(this.db, trial.getID());
        }
        Experiment.deleteExperiment(this.db, n);
    }

    public void deleteApplication(int n) {
        PerfDMFSession perfDMFSession = new PerfDMFSession();
        perfDMFSession.setDB(this.db());
        perfDMFSession.setApplication(n);
        ListIterator listIterator = perfDMFSession.getExperimentList();
        while (listIterator.hasNext()) {
            Experiment experiment = (Experiment)listIterator.next();
            perfDMFSession.setExperiment(experiment.getID());
            ListIterator listIterator2 = perfDMFSession.getTrialList();
            while (listIterator2.hasNext()) {
                Trial trial = (Trial)listIterator2.next();
                Trial.deleteTrial(this.db, trial.getID());
            }
            Experiment.deleteExperiment(this.db, experiment.getID());
        }
        Application.deleteApplication(this.db, n);
    }

    public int getNumberOfMetrics() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT id, name ");
        stringBuffer.append("FROM " + this.db.getSchemaPrefix() + "metric ");
        stringBuffer.append("WHERE trial = ");
        stringBuffer.append(this.trial.getID());
        stringBuffer.append(" ORDER BY id ");
        try {
            ResultSet resultSet = this.db.executeQuery(stringBuffer.toString());
            int n = 0;
            while (resultSet.next()) {
                ++n;
            }
            resultSet.close();
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }
}

