/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class NCT {
    Vector nodes = new Vector();

    public boolean addNode(Node node) {
        boolean bl = false;
        try {
            int n;
            if (node.getNodeID() >= 0 && (n = this.getNodePosition(node)) < 0) {
                this.nodes.insertElementAt(node, -(n + 1));
                bl = true;
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "N1");
        }
        return bl;
    }

    public Node addNode(int n) {
        Node node = null;
        try {
            int n2;
            if (n >= 0 && (n2 = this.getNodePosition(new Integer(n))) < 0) {
                node = new Node(n);
                this.nodes.insertElementAt(node, -(n2 + 1));
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "N2");
        }
        return node;
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public Node getNode(int n) {
        Node node = null;
        try {
            int n2 = this.getNodePosition(new Integer(n));
            if (n2 >= 0) {
                node = (Node)this.nodes.elementAt(n2);
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "N3");
        }
        return node;
    }

    private int getNodePosition(Integer n) {
        return Collections.binarySearch(this.nodes, n);
    }

    private int getNodePosition(Node node) {
        return Collections.binarySearch(this.nodes, node);
    }

    public int getTotalNumberOfContexts() {
        int n = -1;
        Enumeration enumeration = this.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            n += node.getNumberOfContexts();
        }
        return n;
    }

    public int getNumberOfContexts(int n) {
        return ((Node)this.nodes.elementAt(this.getNodePosition(new Integer(n)))).getNumberOfContexts();
    }

    public Vector getContexts(int n) {
        Vector vector = null;
        int n2 = this.getNodePosition(new Integer(n));
        if (n2 >= 0) {
            vector = ((Node)this.nodes.elementAt(n2)).getContexts();
        }
        return vector;
    }

    public Context getContext(int n, int n2) {
        Context context = null;
        int n3 = this.getNodePosition(new Integer(n));
        if (n3 >= 0) {
            context = ((Node)this.nodes.elementAt(n3)).getContext(n2);
        }
        return context;
    }

    public int getTotalNumberOfThreads() {
        int n = -1;
        Enumeration enumeration = this.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            Enumeration enumeration2 = node.getContexts().elements();
            while (enumeration2.hasMoreElements()) {
                Context context = (Context)enumeration2.nextElement();
                n += context.getNumberOfThreads();
            }
        }
        return n;
    }

    public int getNumberOfThreads(int n, int n2) {
        return this.getContext(n, n2).getNumberOfThreads();
    }

    public Vector getThreads() {
        Vector vector = new Vector();
        Enumeration enumeration = this.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            Enumeration enumeration2 = node.getContexts().elements();
            while (enumeration2.hasMoreElements()) {
                vector.addAll(((Context)enumeration2.nextElement()).getThreads());
            }
        }
        return vector;
    }

    public Vector getThreads(int n) {
        Vector vector = new Vector();
        Node node = this.getNode(n);
        Enumeration enumeration = node.getContexts().elements();
        while (enumeration.hasMoreElements()) {
            vector.addAll(((Context)enumeration.nextElement()).getThreads());
        }
        return vector;
    }

    public Vector getThreads(int n, int n2) {
        Vector vector = null;
        Context context = this.getContext(n, n2);
        if (context != null) {
            vector = context.getThreads();
        }
        return vector;
    }

    public Thread getThread(int n, int n2, int n3) {
        Object var4_4 = null;
        Context context = this.getContext(n, n2);
        Thread thread = null;
        if (context != null) {
            thread = context.getThread(n3);
        }
        return thread;
    }
}

