/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.analysis;

import edu.uoregon.tau.dms.analysis.DistanceAnalysis;
import edu.uoregon.tau.dms.analysis.DistanceMatrix;
import edu.uoregon.tau.dms.analysis.ThreadMatrix;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.PerfDMFSession;
import edu.uoregon.tau.dms.dss.Trial;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ThreadDistance
extends DistanceAnalysis {
    public ThreadDistance(PerfDMFSession perfDMFSession, Trial trial, Metric metric) {
        super(perfDMFSession, trial, metric);
    }

    protected void getTotals() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select l.node, l.context, l.thread, sum(l.exclusive) ");
        stringBuffer.append("from interval_event e ");
        stringBuffer.append("left outer join interval_location_profile l ");
        stringBuffer.append("on e.id = l.interval_event ");
        stringBuffer.append("where e.trial = ? and l.metric = ? ");
        stringBuffer.append("group by l.node, l.context, l.thread ");
        stringBuffer.append("order by l.node, l.context, l.thread ");
        try {
            PreparedStatement preparedStatement = this.db.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.trial.getID());
            preparedStatement.setInt(2, this.metric.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                this.results.total[n++] = resultSet.getDouble(4);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return;
        }
    }

    protected void getMatrixData() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.trial.getNumThreadsPerContext();
        int n2 = n * this.trial.getNumContextsPerNode();
        stringBuffer.append("select (l.node * ");
        stringBuffer.append(n2);
        stringBuffer.append(") + (l.context * ");
        stringBuffer.append(n);
        stringBuffer.append(") + l.thread as idx, e.id, ");
        stringBuffer.append("COALESCE(l.exclusive, 0.0) from interval_event e ");
        stringBuffer.append("left outer join interval_location_profile l ");
        stringBuffer.append("on e.id = l.interval_event ");
        stringBuffer.append("where e.trial = ? and l.metric = ? ");
        stringBuffer.append("order by e.id, idx ");
        try {
            PreparedStatement preparedStatement = this.db.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.trial.getID());
            preparedStatement.setInt(2, this.metric.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (resultSet.next()) {
                n3 = resultSet.getInt(1);
                n5 = resultSet.getInt(2);
                this.results.dataMatrix[n3][n4] = this.results.total[n3] == 0.0 ? 0.0 : resultSet.getDouble(3) / this.results.total[n3];
            }
            while (resultSet.next()) {
                n3 = resultSet.getInt(1);
                if (n5 != resultSet.getInt(2)) {
                    ++n4;
                    n5 = resultSet.getInt(2);
                }
                if (this.results.total[n3] == 0.0) {
                    this.results.dataMatrix[n3][n4] = 0.0;
                    continue;
                }
                this.results.dataMatrix[n3][n4] = resultSet.getDouble(3) / this.results.total[n3];
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return;
        }
    }

    public int getThreadCount() {
        return this.results == null ? 0 : this.results.matrixSize;
    }

    public int getEventCount() {
        return this.results == null ? 0 : this.results.dimensionCount;
    }

    protected DistanceMatrix createTheMatrix(int n, int n2) {
        return new ThreadMatrix(n, n2);
    }
}

