/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.GlobalContext;
import jRacy.GlobalMapping;
import jRacy.GlobalMappingElement;
import jRacy.GlobalServer;
import jRacy.GlobalThread;
import jRacy.MappingDataWindow;
import jRacy.SMWThreadDataElement;
import jRacy.StaticMainWindowData;
import jRacy.ThreadDataWindow;
import jRacy.Trial;
import jRacy.UtilFncs;
import jRacy.jRacy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ThreadDataWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable {
    int xPanelSize = 700;
    int yPanelSize = 450;
    private int newXPanelSize = 0;
    private int newYPanelSize = 0;
    String counterName = null;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int defaultBarLength = 250;
    private int maxXLength = 0;
    private int numberOfColors = 0;
    private double maxInclusiveValue = 0.0;
    private double maxExclusiveValue = 0.0;
    private double maxInclusivePercentValue = 0.0;
    private double maxExclusivePercentValue = 0.0;
    private int maxNumberOfCalls = 0;
    private int maxNumberOfSubroutines = 0;
    private double maxUserSecPerCall = 0.0;
    private int serverNumber = -1;
    private int contextNumber = -1;
    private int threadNumber = -1;
    private Trial trial = null;
    private StaticMainWindowData sMWData = null;
    private ThreadDataWindow tDWindow = null;
    private GlobalThread tmpGT = null;
    private Vector tmpThreadDataElementList = null;
    private SMWThreadDataElement tmpSMWThreadDataElement = null;
    private JPopupMenu popup = new JPopupMenu();
    private Object clickedOnObject = null;

    public ThreadDataWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TDWP01");
        }
    }

    public ThreadDataWindowPanel(Trial trial, int n, int n2, int n3, ThreadDataWindow threadDataWindow, StaticMainWindowData staticMainWindowData) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.serverNumber = n;
            this.contextNumber = n2;
            this.threadNumber = n3;
            this.trial = trial;
            this.tDWindow = threadDataWindow;
            this.sMWData = staticMainWindowData;
            GlobalServer globalServer = (GlobalServer)this.trial.getStaticServerList().elementAt(this.serverNumber);
            Vector vector = globalServer.getContextList();
            GlobalContext globalContext = (GlobalContext)vector.elementAt(this.contextNumber);
            Vector vector2 = globalContext.getThreadList();
            this.tmpGT = (GlobalThread)vector2.elementAt(this.threadNumber);
            JMenuItem jMenuItem = new JMenuItem("Show Function Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Change Function Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Reset to Generic Color");
            jMenuItem3.addActionListener(this);
            this.popup.add(jMenuItem3);
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TDWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.drawPage((Graphics2D)graphics, false);
        }
        catch (Exception exception) {
            System.out.println(exception);
            jRacy.systemError(exception, null, "TDWP03");
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (pageFormat.getOrientation() == 1) {
            System.out.println("PORTRAIT");
        } else if (pageFormat.getOrientation() == 0) {
            System.out.println("LANDSCAPE");
        }
        if (n >= 3) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        this.drawPage(graphics2D, true);
        return 0;
    }

    public void drawPage(Graphics2D graphics2D, boolean bl) {
        try {
            int n;
            int n2;
            FontMetrics fontMetrics;
            Font font;
            boolean bl2 = this.tDWindow.getFormatNumbers();
            this.numberOfColors = this.trial.getColorChooser().getNumberOfColors();
            if (!this.trial.getPreferences().areBarDetailsSet()) {
                font = new Font(this.trial.getPreferences().getJRacyFont(), this.trial.getPreferences().getFontStyle(), 12);
                graphics2D.setFont(font);
                fontMetrics = graphics2D.getFontMetrics(font);
                n2 = fontMetrics.getAscent();
                int n3 = fontMetrics.getMaxDescent();
                int n4 = n2 + n3;
                this.trial.getPreferences().setBarDetails(n2, n4 + 5);
                this.trial.getPreferences().setSliders(n2, n4 + 5);
            }
            this.barSpacing = this.trial.getPreferences().getBarSpacing();
            this.barHeight = this.trial.getPreferences().getBarHeight();
            font = new Font(this.trial.getPreferences().getJRacyFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
            graphics2D.setFont(font);
            fontMetrics = graphics2D.getFontMetrics(font);
            n2 = jRacy.defaultNumberPrecision;
            double d = 0.0;
            int n5 = 0;
            int n6 = 0;
            int n7 = this.defaultBarLength + 60;
            n5 += this.barSpacing;
            this.counterName = this.trial.getCounterName();
            if (this.counterName != null) {
                graphics2D.drawString("COUNTER NAME: " + this.counterName, 5, n5);
                n5 += this.barSpacing;
            }
            this.tmpThreadDataElementList = this.tDWindow.getStaticMainWindowSystemData();
            if (this.tmpThreadDataElementList.size() == 0) {
                return;
            }
            Rectangle rectangle = graphics2D.getClipBounds();
            int n8 = (int)rectangle.getY();
            int n9 = (int)((double)n8 + rectangle.getHeight());
            int n10 = 0;
            int n11 = 0;
            if (rectangle != null) {
                int n12;
                this.newYPanelSize = n5 + (this.tmpThreadDataElementList.size() + 1) * this.barSpacing;
                if (bl) {
                    n10 = 0;
                    n11 = 100;
                } else {
                    n10 = (n8 - n5) / this.barSpacing - 1;
                    n11 = (n9 - n5) / this.barSpacing + 1;
                    if (n10 < 0) {
                        n10 = 0;
                    }
                    if (n11 < 0) {
                        n11 = 0;
                    }
                    if (n10 > this.tmpThreadDataElementList.size() - 1) {
                        n10 = this.tmpThreadDataElementList.size() - 1;
                    }
                    if (n11 > this.tmpThreadDataElementList.size() - 1) {
                        n11 = this.tmpThreadDataElementList.size() - 1;
                    }
                    n5 += n10 * this.barSpacing;
                }
                this.maxInclusiveValue = this.tmpGT.getMaxInclusiveValue(this.trial.getCurValLoc());
                this.maxExclusiveValue = this.tmpGT.getMaxExclusiveValue(this.trial.getCurValLoc());
                this.maxInclusivePercentValue = this.tmpGT.getMaxInclusivePercentValue(this.trial.getCurValLoc());
                this.maxExclusivePercentValue = this.tmpGT.getMaxExclusivePercentValue(this.trial.getCurValLoc());
                this.maxNumberOfCalls = this.tmpGT.getMaxNumberOfCalls();
                this.maxNumberOfSubroutines = this.tmpGT.getMaxNumberOfSubRoutines();
                this.maxUserSecPerCall = this.tmpGT.getMaxUserSecPerCall(this.trial.getCurValLoc());
                if (this.tDWindow.isInclusive()) {
                    if (this.tDWindow.isPercent()) {
                        n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxInclusivePercentValue, n2) + "%");
                        n7 += n12;
                    } else if (this.tDWindow.units().equals("Seconds")) {
                        n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxInclusiveValue / 1000000.0, n2));
                        n7 += n12;
                    } else if (this.tDWindow.units().equals("Milliseconds")) {
                        n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxInclusiveValue / 1000.0, n2));
                        n7 += n12;
                    } else {
                        n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxInclusiveValue, n2));
                        n7 += n12;
                    }
                } else if (this.tDWindow.isPercent()) {
                    n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxExclusivePercentValue, n2) + "%");
                    n7 += n12;
                } else if (this.tDWindow.units().equals("Seconds")) {
                    n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxExclusiveValue / 1000000.0, n2));
                    n7 += n12;
                } else if (this.tDWindow.units().equals("Milliseconds")) {
                    n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxExclusiveValue / 1000.0, n2));
                    n7 += n12;
                } else {
                    n12 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxExclusiveValue, n2));
                    n7 += n12;
                }
                if (this.tDWindow.getMetric().equals("Inclusive")) {
                    if (this.tDWindow.isPercent()) {
                        n = n10;
                        while (n <= n11) {
                            this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n);
                            n5 += this.barSpacing;
                            double d2 = this.tmpSMWThreadDataElement.getInclusivePercentValue();
                            double d3 = d2 / this.maxInclusivePercentValue;
                            int n13 = (int)(d3 * (double)this.defaultBarLength);
                            if (n13 == 0) {
                                n13 = 1;
                            }
                            Color color = this.tmpSMWThreadDataElement.getMappingColor();
                            graphics2D.setColor(color);
                            if (n13 > 2 && this.barHeight > 2) {
                                graphics2D.fillRect(n7 - n13 + 1, n5 - this.barHeight + 1, n13 - 1, this.barHeight - 1);
                                if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                    graphics2D.drawRect(n7 - n13, n5 - this.barHeight, n13, this.barHeight);
                                    graphics2D.drawRect(n7 - n13 + 1, n5 - this.barHeight + 1, n13 - 2, this.barHeight - 2);
                                } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                    graphics2D.drawRect(n7 - n13, n5 - this.barHeight, n13, this.barHeight);
                                    graphics2D.drawRect(n7 - n13 + 1, n5 - this.barHeight + 1, n13 - 2, this.barHeight - 2);
                                } else {
                                    graphics2D.setColor(Color.black);
                                    graphics2D.drawRect(n7 - n13, n5 - this.barHeight, n13, this.barHeight);
                                }
                            } else {
                                if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                } else {
                                    color = this.tmpSMWThreadDataElement.getMappingColor();
                                    graphics2D.setColor(color);
                                }
                                graphics2D.fillRect(n7 - n13, n5 - this.barHeight, n13, this.barHeight);
                            }
                            graphics2D.setColor(Color.black);
                            String string = UtilFncs.adjustDoublePresision(d2, n2) + "%";
                            n12 = fontMetrics.stringWidth(string);
                            int n14 = n7 - n13 - n12 - 5;
                            graphics2D.drawString(string, n14, n5);
                            string = this.tmpSMWThreadDataElement.getMappingName();
                            graphics2D.drawString(string, n7 + 5, n5);
                            n12 = n7 + fontMetrics.stringWidth(string) + 5;
                            if (n6 < n12) {
                                n6 = n12 + 15;
                            }
                            this.tmpSMWThreadDataElement.setTDWDrawCoords(n14, n12, n5 - this.barHeight, n5);
                            ++n;
                        }
                    } else {
                        n = n10;
                        while (n <= n11) {
                            int n15;
                            String string;
                            this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n);
                            n5 += this.barSpacing;
                            double d4 = this.tmpSMWThreadDataElement.getInclusiveValue();
                            double d5 = d4 / this.maxInclusiveValue;
                            int n16 = (int)(d5 * (double)this.defaultBarLength);
                            if (n16 == 0) {
                                n16 = 1;
                            }
                            Color color = this.tmpSMWThreadDataElement.getMappingColor();
                            graphics2D.setColor(color);
                            if (n16 > 2 && this.barHeight > 2) {
                                graphics2D.fillRect(n7 - n16 + 1, n5 - this.barHeight + 1, n16 - 1, this.barHeight - 1);
                                if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                    graphics2D.drawRect(n7 - n16, n5 - this.barHeight, n16, this.barHeight);
                                    graphics2D.drawRect(n7 - n16 + 1, n5 - this.barHeight + 1, n16 - 2, this.barHeight - 2);
                                } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                    graphics2D.drawRect(n7 - n16, n5 - this.barHeight, n16, this.barHeight);
                                    graphics2D.drawRect(n7 - n16 + 1, n5 - this.barHeight + 1, n16 - 2, this.barHeight - 2);
                                } else {
                                    graphics2D.setColor(Color.black);
                                    graphics2D.drawRect(n7 - n16, n5 - this.barHeight, n16, this.barHeight);
                                }
                            } else {
                                if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                } else {
                                    color = this.tmpSMWThreadDataElement.getMappingColor();
                                    graphics2D.setColor(color);
                                }
                                graphics2D.fillRect(n7 - n16, n5 - this.barHeight, n16, this.barHeight);
                            }
                            graphics2D.setColor(Color.black);
                            if (this.tDWindow.units().equals("Seconds")) {
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d4 / 1000000.0, n2)));
                                n12 = fontMetrics.stringWidth(string);
                                n15 = n7 - n16 - n12 - 5;
                                graphics2D.drawString(string, n15, n5);
                            } else if (this.tDWindow.units().equals("Milliseconds")) {
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d4 / 1000.0, n2)));
                                n12 = fontMetrics.stringWidth(string);
                                n15 = n7 - n16 - n12 - 5;
                                graphics2D.drawString(string, n15, n5);
                            } else {
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d4, n2)));
                                n12 = fontMetrics.stringWidth(string);
                                n15 = n7 - n16 - n12 - 5;
                                graphics2D.drawString(string, n15, n5);
                            }
                            string = this.tmpSMWThreadDataElement.getMappingName();
                            graphics2D.drawString(string, n7 + 5, n5);
                            n12 = n7 + fontMetrics.stringWidth(string) + 5;
                            if (n6 < n12) {
                                n6 = n12 + 15;
                            }
                            this.tmpSMWThreadDataElement.setTDWDrawCoords(n15, n12, n5 - this.barHeight, n5);
                            ++n;
                        }
                    }
                } else if (this.tDWindow.getMetric().equals("Exclusive")) {
                    if (this.tDWindow.isPercent()) {
                        n = n10;
                        while (n <= n11) {
                            this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n);
                            n5 += this.barSpacing;
                            double d6 = this.tmpSMWThreadDataElement.getExclusivePercentValue();
                            double d7 = d6 / this.maxExclusivePercentValue;
                            int n17 = (int)(d7 * (double)this.defaultBarLength);
                            if (n17 == 0) {
                                n17 = 1;
                            }
                            Color color = this.tmpSMWThreadDataElement.getMappingColor();
                            graphics2D.setColor(color);
                            if (n17 > 2 && this.barHeight > 2) {
                                graphics2D.fillRect(n7 - n17 + 1, n5 - this.barHeight + 1, n17 - 1, this.barHeight - 1);
                                if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                    graphics2D.drawRect(n7 - n17, n5 - this.barHeight, n17, this.barHeight);
                                    graphics2D.drawRect(n7 - n17 + 1, n5 - this.barHeight + 1, n17 - 2, this.barHeight - 2);
                                } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                    graphics2D.drawRect(n7 - n17, n5 - this.barHeight, n17, this.barHeight);
                                    graphics2D.drawRect(n7 - n17 + 1, n5 - this.barHeight + 1, n17 - 2, this.barHeight - 2);
                                } else {
                                    graphics2D.setColor(Color.black);
                                    graphics2D.drawRect(n7 - n17, n5 - this.barHeight, n17, this.barHeight);
                                }
                            } else {
                                if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                } else {
                                    color = this.tmpSMWThreadDataElement.getMappingColor();
                                    graphics2D.setColor(color);
                                }
                                graphics2D.fillRect(n7 - n17, n5 - this.barHeight, n17, this.barHeight);
                            }
                            graphics2D.setColor(Color.black);
                            String string = UtilFncs.adjustDoublePresision(d6, n2) + "%";
                            n12 = fontMetrics.stringWidth(string);
                            int n18 = n7 - n17 - n12 - 5;
                            graphics2D.drawString(string, n18, n5);
                            string = this.tmpSMWThreadDataElement.getMappingName();
                            graphics2D.drawString(string, n7 + 5, n5);
                            n12 = n7 + fontMetrics.stringWidth(string) + 5;
                            if (n6 < n12) {
                                n6 = n12 + 15;
                            }
                            this.tmpSMWThreadDataElement.setTDWDrawCoords(n18, n12, n5 - this.barHeight, n5);
                            ++n;
                        }
                    } else {
                        n = n10;
                        while (n <= n11) {
                            int n19;
                            String string;
                            this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n);
                            n5 += this.barSpacing;
                            double d8 = this.tmpSMWThreadDataElement.getExclusiveValue();
                            double d9 = d8 / this.maxExclusiveValue;
                            int n20 = (int)(d9 * (double)this.defaultBarLength);
                            if (n20 == 0) {
                                n20 = 1;
                            }
                            Color color = this.tmpSMWThreadDataElement.getMappingColor();
                            graphics2D.setColor(color);
                            if (n20 > 2 && this.barHeight > 2) {
                                graphics2D.fillRect(n7 - n20 + 1, n5 - this.barHeight + 1, n20 - 1, this.barHeight - 1);
                                if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                    graphics2D.drawRect(n7 - n20, n5 - this.barHeight, n20, this.barHeight);
                                    graphics2D.drawRect(n7 - n20 + 1, n5 - this.barHeight + 1, n20 - 2, this.barHeight - 2);
                                } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                    graphics2D.drawRect(n7 - n20, n5 - this.barHeight, n20, this.barHeight);
                                    graphics2D.drawRect(n7 - n20 + 1, n5 - this.barHeight + 1, n20 - 2, this.barHeight - 2);
                                } else {
                                    graphics2D.setColor(Color.black);
                                    graphics2D.drawRect(n7 - n20, n5 - this.barHeight, n20, this.barHeight);
                                }
                            } else {
                                if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                } else {
                                    color = this.tmpSMWThreadDataElement.getMappingColor();
                                    graphics2D.setColor(color);
                                }
                                graphics2D.fillRect(n7 - n20, n5 - this.barHeight, n20, this.barHeight);
                            }
                            graphics2D.setColor(Color.black);
                            if (this.tDWindow.units().equals("Seconds")) {
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d8 / 1000000.0, n2)));
                                n12 = fontMetrics.stringWidth(string);
                                n19 = n7 - n20 - n12 - 5;
                                graphics2D.drawString(string, n19, n5);
                            } else if (this.tDWindow.units().equals("Milliseconds")) {
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d8 / 1000.0, n2)));
                                n12 = fontMetrics.stringWidth(string);
                                n19 = n7 - n20 - n12 - 5;
                                graphics2D.drawString(string, n19, n5);
                            } else {
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d8, n2)));
                                n12 = fontMetrics.stringWidth(string);
                                n19 = n7 - n20 - n12 - 5;
                                graphics2D.drawString(string, n19, n5);
                            }
                            string = this.tmpSMWThreadDataElement.getMappingName();
                            graphics2D.drawString(string, n7 + 5, n5);
                            n12 = n7 + fontMetrics.stringWidth(string) + 5;
                            if (n6 < n12) {
                                n6 = n12 + 15;
                            }
                            this.tmpSMWThreadDataElement.setTDWDrawCoords(n19, n12, n5 - this.barHeight, n5);
                            ++n;
                        }
                    }
                } else if (this.tDWindow.getMetric().equals("Number of Calls")) {
                    n = n10;
                    while (n <= n11) {
                        this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n);
                        n5 += this.barSpacing;
                        double d10 = this.tmpSMWThreadDataElement.getNumberOfCalls();
                        double d11 = d10 / (double)this.maxNumberOfCalls;
                        int n21 = (int)(d11 * (double)this.defaultBarLength);
                        if (n21 == 0) {
                            n21 = 1;
                        }
                        Color color = this.tmpSMWThreadDataElement.getMappingColor();
                        graphics2D.setColor(color);
                        if (n21 > 2 && this.barHeight > 2) {
                            graphics2D.fillRect(n7 - n21 + 1, n5 - this.barHeight + 1, n21 - 1, this.barHeight - 1);
                            if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                graphics2D.drawRect(n7 - n21, n5 - this.barHeight, n21, this.barHeight);
                                graphics2D.drawRect(n7 - n21 + 1, n5 - this.barHeight + 1, n21 - 2, this.barHeight - 2);
                            } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                graphics2D.drawRect(n7 - n21, n5 - this.barHeight, n21, this.barHeight);
                                graphics2D.drawRect(n7 - n21 + 1, n5 - this.barHeight + 1, n21 - 2, this.barHeight - 2);
                            } else {
                                graphics2D.setColor(Color.black);
                                graphics2D.drawRect(n7 - n21, n5 - this.barHeight, n21, this.barHeight);
                            }
                        } else {
                            if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                            } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            } else {
                                color = this.tmpSMWThreadDataElement.getMappingColor();
                                graphics2D.setColor(color);
                            }
                            graphics2D.fillRect(n7 - n21, n5 - this.barHeight, n21, this.barHeight);
                        }
                        graphics2D.setColor(Color.black);
                        String string = new String(Double.toString(d10));
                        n12 = fontMetrics.stringWidth(string);
                        int n22 = n7 - n21 - n12 - 5;
                        graphics2D.drawString(Double.toString(d10), n22, n5);
                        string = this.tmpSMWThreadDataElement.getMappingName();
                        graphics2D.drawString(string, n7 + 5, n5);
                        n12 = n7 + fontMetrics.stringWidth(string) + 5;
                        if (n6 < n12) {
                            n6 = n12 + 15;
                        }
                        this.tmpSMWThreadDataElement.setTDWDrawCoords(n22, n12, n5 - this.barHeight, n5);
                        ++n;
                    }
                } else if (this.tDWindow.getMetric().equals("Number of Subroutines")) {
                    n = n10;
                    while (n <= n11) {
                        this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n);
                        n5 += this.barSpacing;
                        double d12 = this.tmpSMWThreadDataElement.getNumberOfSubRoutines();
                        double d13 = d12 / (double)this.maxNumberOfSubroutines;
                        int n23 = (int)(d13 * (double)this.defaultBarLength);
                        if (n23 == 0) {
                            n23 = 1;
                        }
                        Color color = this.tmpSMWThreadDataElement.getMappingColor();
                        graphics2D.setColor(color);
                        if (n23 > 2 && this.barHeight > 2) {
                            graphics2D.fillRect(n7 - n23 + 1, n5 - this.barHeight + 1, n23 - 1, this.barHeight - 1);
                            if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                graphics2D.drawRect(n7 - n23, n5 - this.barHeight, n23, this.barHeight);
                                graphics2D.drawRect(n7 - n23 + 1, n5 - this.barHeight + 1, n23 - 2, this.barHeight - 2);
                            } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                graphics2D.drawRect(n7 - n23, n5 - this.barHeight, n23, this.barHeight);
                                graphics2D.drawRect(n7 - n23 + 1, n5 - this.barHeight + 1, n23 - 2, this.barHeight - 2);
                            } else {
                                graphics2D.setColor(Color.black);
                                graphics2D.drawRect(n7 - n23, n5 - this.barHeight, n23, this.barHeight);
                            }
                        } else {
                            if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                            } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            } else {
                                color = this.tmpSMWThreadDataElement.getMappingColor();
                                graphics2D.setColor(color);
                            }
                            graphics2D.fillRect(n7 - n23, n5 - this.barHeight, n23, this.barHeight);
                        }
                        graphics2D.setColor(Color.black);
                        String string = new String(Double.toString(d12));
                        n12 = fontMetrics.stringWidth(string);
                        int n24 = n7 - n23 - n12 - 5;
                        graphics2D.drawString(Double.toString(d12), n24, n5);
                        string = this.tmpSMWThreadDataElement.getMappingName();
                        graphics2D.drawString(string, n7 + 5, n5);
                        n12 = n7 + fontMetrics.stringWidth(string) + 5;
                        if (n6 < n12) {
                            n6 = n12 + 15;
                        }
                        this.tmpSMWThreadDataElement.setTDWDrawCoords(n24, n12, n5 - this.barHeight, n5);
                        ++n;
                    }
                } else if (this.tDWindow.getMetric().equals("Per Call Value")) {
                    n = n10;
                    while (n <= n11) {
                        this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n);
                        n5 += this.barSpacing;
                        double d14 = this.tmpSMWThreadDataElement.getUserSecPerCall();
                        double d15 = d14 / this.maxUserSecPerCall;
                        int n25 = (int)(d15 * (double)this.defaultBarLength);
                        if (n25 == 0) {
                            n25 = 1;
                        }
                        Color color = this.tmpSMWThreadDataElement.getMappingColor();
                        graphics2D.setColor(color);
                        if (n25 > 2 && this.barHeight > 2) {
                            graphics2D.fillRect(n7 - n25 + 1, n5 - this.barHeight + 1, n25 - 1, this.barHeight - 1);
                            if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                graphics2D.drawRect(n7 - n25, n5 - this.barHeight, n25, this.barHeight);
                                graphics2D.drawRect(n7 - n25 + 1, n5 - this.barHeight + 1, n25 - 2, this.barHeight - 2);
                            } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                graphics2D.drawRect(n7 - n25, n5 - this.barHeight, n25, this.barHeight);
                                graphics2D.drawRect(n7 - n25 + 1, n5 - this.barHeight + 1, n25 - 2, this.barHeight - 2);
                            } else {
                                graphics2D.setColor(Color.black);
                                graphics2D.drawRect(n7 - n25, n5 - this.barHeight, n25, this.barHeight);
                            }
                        } else {
                            if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                            } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            } else {
                                color = this.tmpSMWThreadDataElement.getMappingColor();
                                graphics2D.setColor(color);
                            }
                            graphics2D.fillRect(n7 - n25, n5 - this.barHeight, n25, this.barHeight);
                        }
                        graphics2D.setColor(Color.black);
                        String string = new String(Double.toString(UtilFncs.adjustDoublePresision(d14, n2)));
                        n12 = fontMetrics.stringWidth(string);
                        int n26 = n7 - n25 - n12 - 5;
                        graphics2D.drawString(Double.toString(d14), n26, n5);
                        string = this.tmpSMWThreadDataElement.getMappingName();
                        graphics2D.drawString(string, n7 + 5, n5);
                        n12 = n7 + fontMetrics.stringWidth(string) + 5;
                        if (n6 < n12) {
                            n6 = n12 + 15;
                        }
                        this.tmpSMWThreadDataElement.setTDWDrawCoords(n26, n12, n5 - this.barHeight, n5);
                        ++n;
                    }
                }
            }
            n = 0;
            if (n6 > 550) {
                this.xPanelSize = n6 + 1;
                n = 1;
            }
            if (this.newYPanelSize > 550) {
                this.yPanelSize = this.newYPanelSize + 1;
                n = 1;
            }
            if (n != 0) {
                this.revalidate();
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            jRacy.systemError(exception, null, "TDWP03");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            SMWThreadDataElement sMWThreadDataElement = null;
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        this.trial.getColorChooser().setHighlightColorMappingID(sMWThreadDataElement.getMappingID());
                        MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, sMWThreadDataElement.getMappingID(), this.sMWData);
                        this.trial.getSystemEvents().addObserver(mappingDataWindow);
                        mappingDataWindow.show();
                    }
                } else if (string.equals("Change Function Color")) {
                    int n = -1;
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        n = ((SMWThreadDataElement)this.clickedOnObject).getMappingID();
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                    Color color = globalMappingElement.getMappingColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        globalMappingElement.setSpecificColor(color);
                        globalMappingElement.setColorFlag(true);
                        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    int n = -1;
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        n = ((SMWThreadDataElement)this.clickedOnObject).getMappingID();
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                    globalMappingElement.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TDWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            Enumeration enumeration = this.tmpThreadDataElementList.elements();
            while (enumeration.hasMoreElements()) {
                this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration.nextElement();
                if (n2 > this.tmpSMWThreadDataElement.getTDWYEnd()) continue;
                if (n2 >= this.tmpSMWThreadDataElement.getTDWYBeg() && n >= this.tmpSMWThreadDataElement.getTDWXBeg() && n <= this.tmpSMWThreadDataElement.getTDWXEnd()) {
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        this.clickedOnObject = this.tmpSMWThreadDataElement;
                        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                        return;
                    }
                    if (this.trial.getColorChooser().getHighlightColorMappingID() == -1) {
                        this.trial.getColorChooser().setHighlightColorMappingID(this.tmpSMWThreadDataElement.getMappingID());
                    } else if (this.trial.getColorChooser().getHighlightColorMappingID() != this.tmpSMWThreadDataElement.getMappingID()) {
                        this.trial.getColorChooser().setHighlightColorMappingID(this.tmpSMWThreadDataElement.getMappingID());
                    } else {
                        this.trial.getColorChooser().setHighlightColorMappingID(-1);
                    }
                    return;
                }
                return;
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TDWP05");
            System.out.println("Please email Robert Bell at: bertie@cs.uoregon.edu");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void changeInMultiples() {
        this.computeDefaultBarLength();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }

    public void computeDefaultBarLength() {
        try {
            double d = this.tDWindow.getSliderValue();
            double d2 = this.tDWindow.getSliderMultiple();
            double d3 = 250.0 * d * d2;
            this.defaultBarLength = (int)d3;
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "FDWP06");
        }
    }
}

