/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.MeanTotalStatWindowPanel;
import jRacy.StaticMainWindowData;
import jRacy.Trial;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MeanTotalStatWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer {
    private Trial trial = null;
    private MeanTotalStatWindowPanel meanTotalStatWindowPanelRef;
    private StaticMainWindowData sMWData = null;
    private JMenuItem mappingGroupLedgerItem;
    private JMenuItem userEventLedgerItem;
    ButtonGroup sortGroup;
    ButtonGroup sortOrderGroup;
    private ButtonGroup metricGroup = null;
    JRadioButtonMenuItem mappingIDButton;
    JRadioButtonMenuItem nameButton;
    JRadioButtonMenuItem millisecondButton;
    JRadioButtonMenuItem ascendingButton;
    JRadioButtonMenuItem descendingButton;
    private JRadioButtonMenuItem inclusiveRadioButton = new JRadioButtonMenuItem("Inclusive", false);
    private JRadioButtonMenuItem exclusiveRadioButton = new JRadioButtonMenuItem("Exclusive", true);
    private JRadioButtonMenuItem numOfCallsRadioButton = new JRadioButtonMenuItem("Number of Calls", false);
    private JRadioButtonMenuItem numOfSubRoutinesRadioButton = new JRadioButtonMenuItem("Number of Subroutines", false);
    private JRadioButtonMenuItem userSecPerCallRadioButton = new JRadioButtonMenuItem("Per Call Value", false);
    private String metric = "Exclusive";
    boolean sortByMappingID = false;
    boolean sortByName = false;
    boolean sortByMillisecond = true;
    boolean descendingOrder = true;
    boolean inclusive = false;
    String lastSorting = "";
    Vector lastList;

    public MeanTotalStatWindow() {
        try {
            ((Component)this).setLocation(new Point(0, 0));
            ((Component)this).setSize(new Dimension(800, 600));
            this.setTitle("Wrong constructor used!");
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MTSW01");
        }
    }

    public MeanTotalStatWindow(Trial trial, StaticMainWindowData staticMainWindowData) {
        try {
            this.trial = trial;
            this.sMWData = staticMainWindowData;
            ((Component)this).setLocation(new Point(0, 0));
            ((Component)this).setSize(new Dimension(800, 600));
            this.setTitle("Mean Total Stat Window: " + this.trial.getProfilePathName());
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MeanTotalStatWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (jRacy.helpWindow.isVisible()) {
                jRacy.helpWindow.clearText();
                jRacy.helpWindow.writeText("This is the mean total mapping statistics window.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("This window shows you the mean total statistics for all mappings.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Right click on any mapping within this window to bring up a popup");
                jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                jRacy.helpWindow.writeText("for the mapping, or to show more details about the mapping.");
                jRacy.helpWindow.writeText("You can also left click any mapping to hightlight it in the system.");
            }
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit Racy!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Options");
            JMenu jMenu3 = new JMenu("Sort by ...");
            this.sortGroup = new ButtonGroup();
            this.mappingIDButton = new JRadioButtonMenuItem("function ID", false);
            this.mappingIDButton.addActionListener(this);
            this.nameButton = new JRadioButtonMenuItem("name", false);
            this.nameButton.addActionListener(this);
            this.millisecondButton = new JRadioButtonMenuItem("millisecond", true);
            this.millisecondButton.addActionListener(this);
            this.sortGroup.add(this.mappingIDButton);
            this.sortGroup.add(this.nameButton);
            this.sortGroup.add(this.millisecondButton);
            jMenu3.add(this.mappingIDButton);
            jMenu3.add(this.nameButton);
            jMenu3.add(this.millisecondButton);
            jMenu2.add(jMenu3);
            JMenu jMenu4 = new JMenu("Sort Order");
            this.sortOrderGroup = new ButtonGroup();
            this.ascendingButton = new JRadioButtonMenuItem("Ascending", false);
            this.ascendingButton.addActionListener(this);
            this.descendingButton = new JRadioButtonMenuItem("Descending", true);
            this.descendingButton.addActionListener(this);
            this.sortOrderGroup.add(this.ascendingButton);
            this.sortOrderGroup.add(this.descendingButton);
            jMenu4.add(this.ascendingButton);
            jMenu4.add(this.descendingButton);
            jMenu2.add(jMenu4);
            JMenu jMenu5 = new JMenu("Select Metric");
            this.metricGroup = new ButtonGroup();
            this.inclusiveRadioButton.addActionListener(this);
            this.exclusiveRadioButton.addActionListener(this);
            this.numOfCallsRadioButton.addActionListener(this);
            this.numOfSubRoutinesRadioButton.addActionListener(this);
            this.userSecPerCallRadioButton.addActionListener(this);
            this.metricGroup.add(this.inclusiveRadioButton);
            this.metricGroup.add(this.exclusiveRadioButton);
            this.metricGroup.add(this.numOfCallsRadioButton);
            this.metricGroup.add(this.numOfSubRoutinesRadioButton);
            this.metricGroup.add(this.userSecPerCallRadioButton);
            jMenu5.add(this.inclusiveRadioButton);
            jMenu5.add(this.exclusiveRadioButton);
            jMenu5.add(this.numOfCallsRadioButton);
            jMenu5.add(this.numOfSubRoutinesRadioButton);
            jMenu5.add(this.userSecPerCallRadioButton);
            jMenu2.add(jMenu5);
            JMenuItem jMenuItem3 = new JMenuItem("Adjust Racy Colors");
            jMenuItem3.addActionListener(this);
            jMenu2.add(jMenuItem3);
            JMenu jMenu6 = new JMenu("Windows");
            jMenu6.addMenuListener(this);
            JMenuItem jMenuItem4 = new JMenuItem("Show Function Ledger");
            jMenuItem4.addActionListener(this);
            jMenu6.add(jMenuItem4);
            this.mappingGroupLedgerItem = new JMenuItem("Show Group Ledger");
            this.mappingGroupLedgerItem.addActionListener(this);
            jMenu6.add(this.mappingGroupLedgerItem);
            this.userEventLedgerItem = new JMenuItem("Show User Event Ledger");
            this.userEventLedgerItem.addActionListener(this);
            jMenu6.add(this.userEventLedgerItem);
            JMenuItem jMenuItem5 = new JMenuItem("Close All Sub-Windows");
            jMenuItem5.addActionListener(this);
            jMenu6.add(jMenuItem5);
            JMenu jMenu7 = new JMenu("Help");
            JMenuItem jMenuItem6 = new JMenuItem("About Racy");
            jMenuItem6.addActionListener(this);
            jMenu7.add(jMenuItem6);
            JMenuItem jMenuItem7 = new JMenuItem("Show Help Window");
            jMenuItem7.addActionListener(this);
            jMenu7.add(jMenuItem7);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu6);
            jMenuBar.add(jMenu7);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.meanTotalStatWindowPanelRef = new MeanTotalStatWindowPanel(this.trial, this);
            JScrollPane jScrollPane = new JScrollPane(this.meanTotalStatWindowPanelRef);
            jScrollPane.setBorder(border);
            jScrollPane.setPreferredSize(new Dimension(500, 450));
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(jScrollPane, gridBagConstraints, 0, 0, 1, 1);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MTSW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit Racy!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("Adjust Racy Colors")) {
                    this.trial.getColorChooser().showColorChooser();
                } else if (string.equals("function ID")) {
                    if (this.mappingIDButton.isSelected()) {
                        this.sortByMappingID = true;
                        this.sortByName = false;
                        this.sortByMillisecond = false;
                        this.meanTotalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("name")) {
                    if (this.nameButton.isSelected()) {
                        this.sortByMappingID = false;
                        this.sortByName = true;
                        this.sortByMillisecond = false;
                        this.meanTotalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("millisecond")) {
                    if (this.millisecondButton.isSelected()) {
                        this.sortByMappingID = false;
                        this.sortByName = false;
                        this.sortByMillisecond = true;
                        this.meanTotalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Descending")) {
                    if (this.descendingButton.isSelected()) {
                        this.descendingOrder = true;
                        this.meanTotalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Ascending")) {
                    if (this.ascendingButton.isSelected()) {
                        this.descendingOrder = false;
                        this.meanTotalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Inclusive")) {
                    if (this.inclusiveRadioButton.isSelected()) {
                        this.metric = "Inclusive";
                        this.meanTotalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Exclusive")) {
                    if (this.exclusiveRadioButton.isSelected()) {
                        this.metric = "Exclusive";
                        this.meanTotalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Number of Calls")) {
                    if (this.numOfCallsRadioButton.isSelected()) {
                        this.metric = "Number of Calls";
                        this.meanTotalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Number of Subroutines")) {
                    if (this.numOfSubRoutinesRadioButton.isSelected()) {
                        this.metric = "Number of Subroutines";
                        this.meanTotalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Per Call Value")) {
                    if (this.userSecPerCallRadioButton.isSelected()) {
                        this.metric = "Per Call Value";
                        this.meanTotalStatWindowPanelRef.repaint();
                    }
                } else if (string.equals("Show Function Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(0);
                } else if (string.equals("Show Group Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(1);
                } else if (string.equals("Show User Event Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(2);
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, jRacy.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    jRacy.helpWindow.clearText();
                    jRacy.helpWindow.show();
                    jRacy.helpWindow.writeText("This is the mean total mapping statistics window.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("This window shows you the mean total statistics for all mappings.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Right click on any mapping within this window to bring up a popup");
                    jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                    jRacy.helpWindow.writeText("for the mapping, or to show more details about the mapping.");
                    jRacy.helpWindow.writeText("You can also left click any mapping to hightlight it in the system.");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MTSW03");
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.trial.groupNamesPresent()) {
                this.mappingGroupLedgerItem.setEnabled(true);
            } else {
                this.mappingGroupLedgerItem.setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.userEventLedgerItem.setEnabled(true);
            } else {
                this.userEventLedgerItem.setEnabled(false);
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "SMW03");
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.meanTotalStatWindowPanelRef.repaint();
            } else if (string.equals("colorEvent")) {
                this.meanTotalStatWindowPanelRef.repaint();
            } else if (string.equals("dataEvent")) {
                this.lastSorting = "";
                this.meanTotalStatWindowPanelRef.repaint();
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MTSW04");
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MTSW05");
        }
    }

    public Vector getStaticMainWindowSystemData() {
        try {
            if (this.sortByMappingID) {
                if (this.metric.equals("Inclusive")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("FIdDI");
                    }
                    return this.sMWData.getSMWMeanData("FIdAI");
                }
                if (this.metric.equals("Exclusive")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("FIdDE");
                    }
                    return this.sMWData.getSMWMeanData("FIdAE");
                }
                if (this.metric.equals("Number of Calls")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("FIdDNC");
                    }
                    return this.sMWData.getSMWMeanData("FIdANC");
                }
                if (this.metric.equals("Number of Subroutines")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("FIdDNS");
                    }
                    return this.sMWData.getSMWMeanData("FIdANS");
                }
                if (this.metric.equals("Per Call Value")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("FIdDUS");
                    }
                    return this.sMWData.getSMWMeanData("FIdAUS");
                }
            } else if (this.sortByName) {
                if (this.metric.equals("Inclusive")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("NDI");
                    }
                    return this.sMWData.getSMWMeanData("NAI");
                }
                if (this.metric.equals("Exclusive")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("NDE");
                    }
                    return this.sMWData.getSMWMeanData("NAE");
                }
                if (this.metric.equals("Number of Calls")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("NDNC");
                    }
                    return this.sMWData.getSMWMeanData("NANC");
                }
                if (this.metric.equals("Number of Subroutines")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("NDNS");
                    }
                    return this.sMWData.getSMWMeanData("NANS");
                }
                if (this.metric.equals("Per Call Value")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("NDUS");
                    }
                    return this.sMWData.getSMWMeanData("NAUS");
                }
            } else if (this.sortByMillisecond) {
                if (this.metric.equals("Inclusive")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("MDI");
                    }
                    return this.sMWData.getSMWMeanData("MAI");
                }
                if (this.metric.equals("Exclusive")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("MDE");
                    }
                    return this.sMWData.getSMWMeanData("MAE");
                }
                if (this.metric.equals("Number of Calls")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("MDNC");
                    }
                    return this.sMWData.getSMWMeanData("MANC");
                }
                if (this.metric.equals("Number of Subroutines")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("MDNS");
                    }
                    return this.sMWData.getSMWMeanData("MANS");
                }
                if (this.metric.equals("Per Call Value")) {
                    if (this.descendingOrder) {
                        return this.sMWData.getSMWMeanData("MDUS");
                    }
                    return this.sMWData.getSMWMeanData("MAUS");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MTSW06");
        }
        return null;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (jRacy.debugIsOn) {
                System.out.println("------------------------");
                System.out.println("The Mean Total Stat Window is closing");
                System.out.println("Clearing resourses for this window.");
            }
            ((Component)this).setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MTSW07");
        }
    }
}

