/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.util.Hashtable;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLContentModel;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.schema.TraverseSchema;

public class SchemaGrammar
extends Grammar {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private XMLContentSpec fTempContentSpecNode = new XMLContentSpec();
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    private int[][] fScopeDefinedByElement = new int[4][];
    private String[][] fFromAnotherSchemaURI = new String[4][];
    private TraverseSchema.ComplexTypeInfo[][] fComplexTypeInfo = new TraverseSchema.ComplexTypeInfo[4][];
    private int[][] fElementDeclDefaultType = new int[4][];
    private String[][] fElementDeclDefaultValue = new String[4][];
    private String[][] fElementDeclSubstitutionGroupFullName = new String[4][];
    private int[][] fElementDeclBlockSet = new int[4][];
    private int[][] fElementDeclFinalSet = new int[4][];
    private int[][] fElementDeclMiscFlags = new int[4][];
    private Hashtable fComplexTypeRegistry = null;
    private Hashtable fAttributeDeclRegistry = null;
    private DatatypeValidatorFactoryImpl fDatatypeRegistry = null;
    Hashtable topLevelGroupDecls = new Hashtable();
    Hashtable topLevelNotationDecls = new Hashtable();
    Hashtable topLevelAttrDecls = new Hashtable();
    Hashtable topLevelAttrGrpDecls = new Hashtable();
    private NamespacesScope fNamespacesScope = null;
    private String fTargetNamespaceURI = "";

    public NamespacesScope getNamespacesScope() {
        return this.fNamespacesScope;
    }

    public String getTargetNamespaceURI() {
        return this.fTargetNamespaceURI;
    }

    public Hashtable getAttirubteDeclRegistry() {
        return this.fAttributeDeclRegistry;
    }

    public Hashtable getComplexTypeRegistry() {
        return this.fComplexTypeRegistry;
    }

    public DatatypeValidatorFactoryImpl getDatatypeRegistry() {
        return this.fDatatypeRegistry;
    }

    public int getElementDefinedScope(int n) {
        if (n < -1) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fScopeDefinedByElement[n2][n3];
    }

    public int getElementDefaultTYpe(int n) {
        if (n < -1) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclDefaultType[n2][n3];
    }

    public int getElementDeclBlockSet(int n) {
        if (n < -1) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclBlockSet[n2][n3];
    }

    public int getElementDeclFinalSet(int n) {
        if (n < -1) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclFinalSet[n2][n3];
    }

    public int getElementDeclMiscFlags(int n) {
        if (n < -1) {
            return -1;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclMiscFlags[n2][n3];
    }

    public String getElementFromAnotherSchemaURI(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fFromAnotherSchemaURI[n2][n3];
    }

    public String getElementDefaultValue(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclDefaultValue[n2][n3];
    }

    public String getElementDeclSubstitutionGroupElementFullName(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fElementDeclSubstitutionGroupFullName[n2][n3];
    }

    public TraverseSchema.ComplexTypeInfo getElementComplexTypeInfo(int n) {
        if (n < -1) {
            return null;
        }
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        return this.fComplexTypeInfo[n2][n3];
    }

    protected void setAttributeDeclRegistry(Hashtable hashtable) {
        this.fAttributeDeclRegistry = hashtable;
    }

    protected void setComplexTypeRegistry(Hashtable hashtable) {
        this.fComplexTypeRegistry = hashtable;
    }

    protected void setDatatypeRegistry(DatatypeValidatorFactoryImpl datatypeValidatorFactoryImpl) {
        this.fDatatypeRegistry = datatypeValidatorFactoryImpl;
    }

    protected void setNamespacesScope(NamespacesScope namespacesScope) {
        this.fNamespacesScope = namespacesScope;
    }

    protected void setTargetNamespaceURI(String string) {
        this.fTargetNamespaceURI = string;
    }

    protected int createElementDecl() {
        return super.createElementDecl();
    }

    protected void setElementDecl(int n, XMLElementDecl xMLElementDecl) {
        super.setElementDecl(n, xMLElementDecl);
    }

    protected int createContentSpec() {
        return super.createContentSpec();
    }

    protected void setContentSpec(int n, XMLContentSpec xMLContentSpec) {
        super.setContentSpec(n, xMLContentSpec);
    }

    protected int createAttributeDecl() {
        return super.createAttributeDecl();
    }

    protected void setAttributeDecl(int n, int n2, XMLAttributeDecl xMLAttributeDecl) {
        super.setAttributeDecl(n, n2, xMLAttributeDecl);
    }

    protected void setElementDefinedScope(int n, int n2) {
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.ensureElementDeclCapacity(n3);
        if (n > -1) {
            this.fScopeDefinedByElement[n3][n4] = n2;
        }
    }

    protected void setElementFromAnotherSchemaURI(int n, String string) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.ensureElementDeclCapacity(n2);
        if (n > -1) {
            this.fFromAnotherSchemaURI[n2][n3] = string;
        }
    }

    protected void setElementComplexTypeInfo(int n, TraverseSchema.ComplexTypeInfo complexTypeInfo) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.ensureElementDeclCapacity(n2);
        if (n > -1) {
            this.fComplexTypeInfo[n2][n3] = complexTypeInfo;
        }
    }

    protected void setElementDefault(int n, int n2, String string) {
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.ensureElementDeclCapacity(n3);
        if (n > -1) {
            this.fElementDeclDefaultType[n3][n4] = n2;
            this.fElementDeclDefaultValue[n3][n4] = string;
        }
    }

    protected void setElementDeclBlockSet(int n, int n2) {
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.ensureElementDeclCapacity(n3);
        if (n > -1) {
            this.fElementDeclBlockSet[n3][n4] = n2;
        }
    }

    protected void setElementDeclFinalSet(int n, int n2) {
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.ensureElementDeclCapacity(n3);
        if (n > -1) {
            this.fElementDeclFinalSet[n3][n4] = n2;
        }
    }

    protected void setElementDeclMiscFlags(int n, int n2) {
        int n3 = n >> 8;
        int n4 = n & 0xFF;
        this.ensureElementDeclCapacity(n3);
        if (n > -1) {
            this.fElementDeclMiscFlags[n3][n4] = n2;
        }
    }

    protected void setElementDeclSubstitutionGroupElementFullName(int n, String string) {
        int n2 = n >> 8;
        int n3 = n & 0xFF;
        this.ensureElementDeclCapacity(n2);
        if (n > -1) {
            this.fElementDeclSubstitutionGroupFullName[n2][n3] = string;
        }
    }

    protected int addElementDecl(QName qName, int n, int n2, int n3, int n4, int n5, DatatypeValidator datatypeValidator) {
        int n6 = this.getElementDeclIndex(qName, n);
        if (n6 == -1) {
            if (n < -1 || n2 < -1) {
                // empty if block
            }
            this.fTempElementDecl.name.setValues(qName);
            this.fTempElementDecl.enclosingScope = n;
            this.fTempElementDecl.type = n3;
            this.fTempElementDecl.contentSpecIndex = n4;
            this.fTempElementDecl.datatypeValidator = datatypeValidator;
            n6 = this.createElementDecl();
            this.setElementDecl(n6, this.fTempElementDecl);
            this.setFirstAttributeDeclIndex(n6, n5);
            this.setElementDefinedScope(n6, n2);
        }
        return n6;
    }

    protected void addAttDef(int n, QName qName, int n2, int n3, int n4, String string, DatatypeValidator datatypeValidator, boolean bl) {
        int n5 = this.createAttributeDecl();
        this.fTempAttributeDecl.name.setValues(qName);
        this.fTempAttributeDecl.datatypeValidator = datatypeValidator;
        this.fTempAttributeDecl.type = n2;
        this.fTempAttributeDecl.defaultType = n4;
        this.fTempAttributeDecl.defaultValue = string;
        this.fTempAttributeDecl.list = bl;
        this.fTempAttributeDecl.enumeration = n3;
        super.setAttributeDecl(n, n5, this.fTempAttributeDecl);
    }

    public int getAttributeDeclIndex(int n, QName qName) {
        if (n == -1) {
            return -1;
        }
        int n2 = this.getFirstAttributeDeclIndex(n);
        while (n2 != -1) {
            this.getAttributeDecl(n2, this.fTempAttributeDecl);
            if (this.fTempAttributeDecl.name.localpart == qName.localpart && this.fTempAttributeDecl.name.uri == qName.uri) {
                return n2;
            }
            n2 = this.getNextAttributeDeclIndex(n2);
        }
        return -1;
    }

    protected int addContentSpecNode(int n, int n2, int n3, boolean bl) {
        this.fTempContentSpecNode.type = n;
        this.fTempContentSpecNode.value = n2;
        this.fTempContentSpecNode.otherValue = n3;
        int n4 = this.createContentSpec();
        this.setContentSpec(n4, this.fTempContentSpecNode);
        return n4;
    }

    private boolean ensureElementDeclCapacity(int n) {
        try {
            return this.fScopeDefinedByElement[n][0] == -2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.fScopeDefinedByElement = this.resize(this.fScopeDefinedByElement, this.fScopeDefinedByElement.length * 2);
            this.fFromAnotherSchemaURI = this.resize(this.fFromAnotherSchemaURI, this.fFromAnotherSchemaURI.length * 2);
            this.fComplexTypeInfo = this.resize(this.fComplexTypeInfo, this.fComplexTypeInfo.length * 2);
            this.fElementDeclDefaultType = this.resize(this.fElementDeclDefaultType, this.fElementDeclDefaultType.length * 2);
            this.fElementDeclDefaultValue = this.resize(this.fElementDeclDefaultValue, this.fElementDeclDefaultValue.length * 2);
            this.fElementDeclBlockSet = this.resize(this.fElementDeclBlockSet, this.fElementDeclBlockSet.length * 2);
            this.fElementDeclFinalSet = this.resize(this.fElementDeclFinalSet, this.fElementDeclFinalSet.length * 2);
            this.fElementDeclMiscFlags = this.resize(this.fElementDeclMiscFlags, this.fElementDeclMiscFlags.length * 2);
            this.fElementDeclSubstitutionGroupFullName = this.resize(this.fElementDeclSubstitutionGroupFullName, this.fElementDeclSubstitutionGroupFullName.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fScopeDefinedByElement[n] = new int[256];
        int n2 = 0;
        while (n2 < 256) {
            this.fScopeDefinedByElement[n][n2] = -2;
            ++n2;
        }
        this.fFromAnotherSchemaURI[n] = new String[256];
        this.fComplexTypeInfo[n] = new TraverseSchema.ComplexTypeInfo[256];
        this.fElementDeclDefaultType[n] = new int[256];
        this.fElementDeclDefaultValue[n] = new String[256];
        this.fElementDeclSubstitutionGroupFullName[n] = new String[256];
        this.fElementDeclBlockSet[n] = new int[256];
        this.fElementDeclFinalSet[n] = new int[256];
        this.fElementDeclMiscFlags[n] = new int[256];
        return true;
    }

    private int[][] resize(int[][] nArray, int n) {
        int[][] nArrayArray = new int[n][];
        System.arraycopy(nArray, 0, nArrayArray, 0, nArray.length);
        return nArrayArray;
    }

    private DatatypeValidator[][] resize(DatatypeValidator[][] datatypeValidatorArray, int n) {
        return datatypeValidatorArray;
    }

    private XMLContentModel[][] resize(XMLContentModel[][] xMLContentModelArray, int n) {
        return xMLContentModelArray;
    }

    private QName[][] resize(QName[][] qNameArray, int n) {
        return qNameArray;
    }

    private String[][] resize(String[][] stringArray, int n) {
        String[][] stringArray2 = new String[n][];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private TraverseSchema.ComplexTypeInfo[][] resize(TraverseSchema.ComplexTypeInfo[][] complexTypeInfoArray, int n) {
        TraverseSchema.ComplexTypeInfo[][] complexTypeInfoArray2 = new TraverseSchema.ComplexTypeInfo[n][];
        System.arraycopy(complexTypeInfoArray, 0, complexTypeInfoArray2, 0, complexTypeInfoArray.length);
        return complexTypeInfoArray2;
    }
}

