/*
 * Decompiled with CFR 0.152.
 */
package viewer.timelines;

import base.drawable.Drawable;
import base.drawable.Method;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BoundedRangeModel;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import logformat.slog2.LineIDMap;
import logformat.slog2.LineIDMapList;
import logformat.slog2.input.InputLog;
import logformat.slog2.input.TreeNode;
import logformat.slog2.input.TreeTrunk;
import viewer.common.Const;
import viewer.common.Dialogs;
import viewer.timelines.CanvasTimeline;
import viewer.timelines.PreviewStateComboBox;
import viewer.timelines.TimelineToolBar;
import viewer.timelines.TreeTrunkPanel;
import viewer.zoomable.Debug;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ModelTimePanel;
import viewer.zoomable.RowAdjustments;
import viewer.zoomable.RulerTime;
import viewer.zoomable.ScrollbarTime;
import viewer.zoomable.ViewportTime;
import viewer.zoomable.ViewportTimePanel;
import viewer.zoomable.ViewportTimeYaxis;
import viewer.zoomable.YaxisMaps;
import viewer.zoomable.YaxisTree;

public class TimelinePanel
extends JPanel {
    private Window root_window;
    private InputLog slog_ins;
    private TreeTrunk treetrunk;
    private TreeNode treeroot;
    private TimelineToolBar toolbar;
    private TreeTrunkPanel treetrunk_panel;
    private BoundedRangeModel y_model;
    private YaxisMaps y_maps;
    private YaxisTree y_tree;
    private Method[] methods;
    private JScrollPane y_scroller;
    private JScrollBar y_scrollbar;
    private ModelTime time_model;
    private ScrollbarTime time_scrollbar;
    private ModelTimePanel time_display_panel;
    private RulerTime time_ruler;
    private ViewportTime time_ruler_vport;
    private ViewportTimePanel time_ruler_panel;
    private CanvasTimeline time_canvas;
    private ViewportTimeYaxis time_canvas_vport;
    private ViewportTimePanel time_canvas_panel;
    private PreviewStateComboBox preview_state_combobox;
    private RowAdjustments row_adjs;
    private String err_msg;

    public TimelinePanel(Window window, InputLog inputLog, int n) {
        this.root_window = window;
        this.slog_ins = inputLog;
        Dimension dimension = (Dimension)UIManager.get("ScrollBar.minimumThumbSize");
        dimension.width = 4;
        UIManager.put("ScrollBar.minimumThumbSize", dimension);
        LineIDMapList lineIDMapList = this.slog_ins.getLineIDMapList();
        LineIDMap lineIDMap = (LineIDMap)lineIDMapList.get(n);
        String[] stringArray = lineIDMap.getColumnLabels();
        this.y_maps = new YaxisMaps(lineIDMap);
        this.y_tree = new YaxisTree(this.y_maps.getTreeRoot());
        this.y_maps.setTreeView(this.y_tree);
        this.methods = lineIDMap.getMethods();
        this.y_scroller = new JScrollPane(this.y_tree, 22, 32);
        this.y_scrollbar = this.y_scroller.getVerticalScrollBar();
        this.y_model = this.y_scrollbar.getModel();
        this.treetrunk = new TreeTrunk(this.slog_ins, Drawable.INCRE_STARTTIME_ORDER);
        this.treetrunk.initFromTreeTop();
        this.treeroot = this.treetrunk.getTreeRoot();
        this.time_model = new ModelTime(this.root_window, this.treeroot.getEarliestTime(), this.treeroot.getLatestTime());
        this.time_model.setTimeZoomFactor(this.treetrunk.getTimeZoomFactor());
        System.out.println("slog_ins.tZoomFtr = " + this.time_model.getTimeZoomFactor());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.time_ruler = new RulerTime(this.time_model);
        this.time_ruler_vport = new ViewportTime(this.time_model);
        this.time_ruler_vport.setView(this.time_ruler);
        this.time_ruler_panel = new ViewportTimePanel(this.time_ruler_vport);
        this.time_ruler_panel.setBorderTitle(" Time (seconds) ", 3, 5, Const.FONT, Color.red);
        this.time_ruler_vport.initLeftMouseToZoom(false);
        this.time_model.addTimeListener(this.time_ruler_vport);
        Insets insets = this.time_ruler_panel.getInsets();
        int n2 = insets.top + this.time_ruler.getJComponentHeight() + insets.bottom;
        this.time_ruler_panel.setPreferredSize(new Dimension(100, n2));
        this.time_canvas = new CanvasTimeline(this.time_model, this.treetrunk, this.y_model, this.y_maps, stringArray, this.methods);
        this.time_canvas_vport = new ViewportTimeYaxis(this.time_model, this.y_model, this.y_tree);
        this.time_canvas_vport.setView(this.time_canvas);
        this.time_canvas_panel = new ViewportTimePanel(this.time_canvas_vport);
        this.time_canvas_panel.setBorderTitle(" TimeLines ", 3, 2, null, Color.blue);
        this.time_canvas_vport.initLeftMouseToZoom(true);
        this.time_model.addTimeListener(this.time_canvas_vport);
        this.time_display_panel = new ModelTimePanel(this.time_model);
        this.time_model.setParamDisplay(this.time_display_panel);
        this.time_display_panel.addViewportTime(this.time_ruler_vport);
        this.time_display_panel.addViewportTime(this.time_canvas_vport);
        JPanel jPanel2 = this.time_canvas_vport.createLeftMouseModePanel(0);
        jPanel2.setToolTipText("Operation for left mouse button click on Timeline canvas");
        this.time_display_panel.add(jPanel2);
        this.time_scrollbar = new ScrollbarTime(this.time_model);
        this.time_scrollbar.setEnabled(true);
        this.time_model.setScrollBar(this.time_scrollbar);
        jPanel.add(this.time_display_panel);
        jPanel.add(this.time_canvas_panel);
        jPanel.add(this.time_scrollbar);
        jPanel.add(this.time_ruler_panel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.treetrunk_panel = new TreeTrunkPanel(this.treetrunk);
        this.treetrunk_panel.setAlignmentX(0.5f);
        this.time_canvas.addChangeListener(this.treetrunk_panel);
        Insets insets2 = this.time_canvas_panel.getInsets();
        this.preview_state_combobox = new PreviewStateComboBox();
        this.preview_state_combobox.setMinimumSize(new Dimension(0, insets2.top));
        this.preview_state_combobox.setMaximumSize(new Dimension(Short.MAX_VALUE, insets2.top));
        this.preview_state_combobox.setPreferredSize(new Dimension(20, insets2.top));
        this.preview_state_combobox.setAlignmentX(0.5f);
        this.y_scroller.setAlignmentX(0.5f);
        this.y_scrollbar.addAdjustmentListener(this.time_canvas_vport);
        int n3 = n2 + insets2.bottom;
        JTextArea jTextArea = new JTextArea();
        StringBuffer stringBuffer = new StringBuffer(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            jTextArea.append(stringBuffer.toString() + "@ " + stringArray[i] + "\n");
            stringBuffer.append("    ");
        }
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 32);
        jScrollPane.setMinimumSize(new Dimension(0, n3));
        jScrollPane.setMaximumSize(new Dimension(Short.MAX_VALUE, n3));
        jScrollPane.setPreferredSize(new Dimension(20, n3));
        jPanel3.add(this.treetrunk_panel);
        jPanel3.add(this.preview_state_combobox);
        jPanel3.add(this.y_scroller);
        jPanel3.add(jScrollPane);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this.row_adjs = new RowAdjustments(this.time_canvas_vport, this.y_tree);
        JPanel jPanel5 = this.row_adjs.getComboBoxPanel();
        jPanel5.setMinimumSize(new Dimension(0, insets2.top));
        jPanel5.setMaximumSize(new Dimension(Short.MAX_VALUE, insets2.top));
        jPanel5.setPreferredSize(new Dimension(20, insets2.top));
        jPanel5.setAlignmentX(0.5f);
        JPanel jPanel6 = this.row_adjs.getTextFieldPanel();
        jPanel6.setAlignmentX(0.5f);
        JPanel jPanel7 = this.row_adjs.getSliderPanel();
        JScrollPane jScrollPane2 = new JScrollPane(jPanel7, 21, 32);
        jScrollPane2.setAlignmentX(0.5f);
        JPanel jPanel8 = this.row_adjs.getMiscPanel();
        jPanel8.setAlignmentX(0.5f);
        JPanel jPanel9 = this.time_ruler_vport.createLeftMouseModePanel(0);
        jPanel9.setToolTipText("Operation for left mouse button click on Time Ruler");
        jPanel9.setAlignmentX(0.0f);
        jPanel8.add(jPanel9);
        JScrollPane jScrollPane3 = new JScrollPane(jPanel8, 20, 30);
        jScrollPane3.setMinimumSize(new Dimension(0, n3));
        jScrollPane3.setMaximumSize(new Dimension(Short.MAX_VALUE, n3));
        jScrollPane3.setPreferredSize(new Dimension(20, n3));
        jPanel4.add(jPanel5);
        jPanel4.add(jPanel6);
        jPanel4.add(jScrollPane2);
        jPanel4.add(jScrollPane3);
        JSplitPane jSplitPane = new JSplitPane(1, false, jPanel3, jPanel);
        JSplitPane jSplitPane2 = new JSplitPane(1, false, jSplitPane, jPanel4);
        jSplitPane2.setOneTouchExpandable(true);
        this.err_msg = null;
        try {
            jSplitPane.setOneTouchExpandable(true);
            jSplitPane2.setResizeWeight(1.0);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.err_msg = "Method JSplitPane.setResizeWeight() cannot be found.\nThis indicates you are running an older Java2 RunTime,\nlike the one in J2SDK 1.2.2 or older. If this is the case,\nsome features in Timeline window may not work correctly,\nFor instance, automatic resize of the Timeline canvas\nduring window resizing and auto-update of the canvas\nafter adjustment of the slider's knob may fail silently,\nmanuel refresh of the canvas will be needed.";
        }
        this.add((Component)jSplitPane2, "Center");
        this.toolbar = new TimelineToolBar(this.root_window, this.time_canvas_vport, this.y_scrollbar, this.y_tree, this.y_maps, this.time_scrollbar, this.time_model, this.row_adjs);
        this.add((Component)this.toolbar, "North");
        this.y_tree.init();
        this.row_adjs.initYLabelTreeSize();
        this.preview_state_combobox.addRedrawListener(this.toolbar.getPropertyRefreshButton());
    }

    public void init() {
        this.toolbar.init();
        this.row_adjs.initSlidersAndTextFields();
        this.preview_state_combobox.init();
        if (this.err_msg != null) {
            Dialogs.error(this.root_window, this.err_msg);
        }
        if (Debug.isActive()) {
            Debug.println("TimelinePanel.init(): time_model = " + this.time_model);
            Debug.println("TimelinePanel.init(): time_scrollbar = " + this.time_scrollbar);
            Debug.println("TimelinePanel.init(): time_ruler = " + this.time_ruler);
        }
    }
}

