/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.vis.GLUT;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BufferUtils {
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_INT = 4;
    private static Map bufferOffsetCache = Collections.synchronizedMap(new HashMap());

    public static DoubleBuffer newDoubleBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 8);
        return byteBuffer.asDoubleBuffer();
    }

    public static FloatBuffer newFloatBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 4);
        return byteBuffer.asFloatBuffer();
    }

    public static IntBuffer newIntBuffer(int n) {
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n * 4);
        return byteBuffer.asIntBuffer();
    }

    public static ByteBuffer newByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    public static DoubleBuffer copyDoubleBuffer(DoubleBuffer doubleBuffer) {
        DoubleBuffer doubleBuffer2 = BufferUtils.newDoubleBuffer(doubleBuffer.capacity());
        doubleBuffer.rewind();
        doubleBuffer2.put(doubleBuffer);
        return doubleBuffer2;
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer floatBuffer) {
        FloatBuffer floatBuffer2 = BufferUtils.newFloatBuffer(floatBuffer.capacity());
        floatBuffer.rewind();
        floatBuffer2.put(floatBuffer);
        return floatBuffer2;
    }

    public static IntBuffer copyIntBuffer(IntBuffer intBuffer) {
        IntBuffer intBuffer2 = BufferUtils.newIntBuffer(intBuffer.capacity());
        intBuffer.rewind();
        intBuffer2.put(intBuffer);
        return intBuffer2;
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = BufferUtils.newByteBuffer(byteBuffer.capacity());
        byteBuffer.rewind();
        byteBuffer2.put(byteBuffer);
        return byteBuffer2;
    }

    public static ByteBuffer bufferOffset(int n) {
        Integer n2 = new Integer(n);
        ByteBuffer byteBuffer = (ByteBuffer)bufferOffsetCache.get(n2);
        if (byteBuffer == null) {
            byteBuffer = BufferUtils.bufferOffset0(n);
            bufferOffsetCache.put(n2, byteBuffer);
        }
        return byteBuffer;
    }

    private static native ByteBuffer bufferOffset0(int var0);
}

