/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Searcher;
import edu.uoregon.tau.paraprof.ThreadDataWindow;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.interfaces.ImageExport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ThreadDataWindowPanel
extends JPanel
implements Printable,
ImageExport,
MouseListener {
    private int xPanelSize = 640;
    private int yPanelSize = 480;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int baseBarLength = 250;
    private int barLength = 0;
    private int textOffset = 60;
    private int maxRightSideStringPixelWidth = 0;
    private ParaProfTrial ppTrial = null;
    private ThreadDataWindow window = null;
    private Thread thread = null;
    private List list = new ArrayList();
    private int lastHeaderEndPosition = 0;
    private Searcher searcher;

    public ThreadDataWindowPanel(ParaProfTrial paraProfTrial, Thread thread, ThreadDataWindow threadDataWindow) {
        this.thread = thread;
        this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
        this.setBackground(Color.white);
        this.searcher = new Searcher(this, threadDataWindow);
        this.addMouseListener(this.searcher);
        this.addMouseMotionListener(this.searcher);
        this.addMouseListener(this);
        this.ppTrial = paraProfTrial;
        this.window = threadDataWindow;
        this.barLength = this.baseBarLength;
        this.setAutoscrolls(true);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.export((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public void resetStringSize() {
        this.maxRightSideStringPixelWidth = 0;
        this.searcher.setSearchLines(null);
    }

    private void setSearchLines() {
        if (this.searcher.getSearchLines() == null && this.list != null) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < this.list.size()) {
                PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.list.get(n);
                vector.add(pPFunctionProfile.getFunctionName());
                ++n;
            }
            this.searcher.setSearchLines(vector);
        }
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        int n;
        this.list = this.window.getData();
        int n2 = this.barLength + this.textOffset;
        PPFunctionProfile pPFunctionProfile = null;
        if (this.list.size() == 0) {
            return;
        }
        this.ppTrial.getPreferencesWindow().setBarDetails(graphics2D);
        this.barSpacing = this.ppTrial.getPreferencesWindow().getBarSpacing();
        this.barHeight = this.ppTrial.getPreferencesWindow().getBarHeight();
        this.searcher.setLineHeight(this.barSpacing);
        Font font = new Font(this.ppTrial.getPreferencesWindow().getParaProfFont(), this.ppTrial.getPreferencesWindow().getFontStyle(), this.barHeight);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        this.searcher.setMaxDescent(fontMetrics.getMaxDescent());
        if (this.maxRightSideStringPixelWidth == 0) {
            int n3 = 0;
            while (n3 < this.list.size()) {
                pPFunctionProfile = (PPFunctionProfile)this.list.get(n3);
                this.maxRightSideStringPixelWidth = Math.max(this.maxRightSideStringPixelWidth, fontMetrics.stringWidth(pPFunctionProfile.getFunctionName() + 5));
                ++n3;
            }
        }
        this.setSearchLines();
        double d = this.window.getDataSorter().getValueType().getThreadMaxValue(this.window.getPPThread().getThread(), this.window.getDataSorter().getSelectedMetricID());
        if (this.window.isPercent()) {
            n = fontMetrics.stringWidth(UtilFncs.getOutputString((int)0, (double)d, (int)6) + "%");
            n2 += n;
        } else {
            n = fontMetrics.stringWidth(UtilFncs.getOutputString((int)this.window.units(), (double)d, (int)ParaProf.defaultNumberPrecision));
            n2 += n;
        }
        n = 0;
        int[] nArray = ParaProfUtils.computeClipping(graphics2D.getClipBounds(), this.window.getViewRect(), bl, bl2, this.list.size(), this.barSpacing, n);
        int n4 = nArray[0];
        int n5 = nArray[1];
        n = nArray[2];
        if (this.resizePanel(fontMetrics, n2, this.list, n4, n5) && bl) {
            this.revalidate();
            return;
        }
        if (bl3) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Insets insets = this.getInsets();
            n += this.barSpacing;
            String string = this.window.getHeaderString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
            while (stringTokenizer.hasMoreTokens()) {
                AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                attributedString.addAttribute(TextAttribute.FONT, font);
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = this.getSize().width - insets.left - insets.right;
                float f2 = insets.left;
                float f3 = insets.right;
                while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                    textLayout.draw(graphics2D, f2, n += this.barSpacing);
                    f2 = insets.left;
                }
            }
            this.lastHeaderEndPosition = n;
        }
        this.searcher.setVisibleLines(n4, n5);
        this.searcher.setG2d(graphics2D);
        this.searcher.setXOffset(n2 + 5);
        int n6 = n4;
        while (n6 <= n5) {
            pPFunctionProfile = (PPFunctionProfile)this.list.get(n6);
            double d2 = pPFunctionProfile.getValue();
            this.drawBar(graphics2D, fontMetrics, d, n2, n += this.barSpacing, this.barHeight, pPFunctionProfile, n6, bl);
            ++n6;
        }
    }

    private void drawBar(Graphics2D graphics2D, FontMetrics fontMetrics, double d, int n, int n2, int n3, PPFunctionProfile pPFunctionProfile, int n4, boolean bl) {
        String string;
        double d2 = pPFunctionProfile.getValue();
        Function function = pPFunctionProfile.getFunction();
        String string2 = string = pPFunctionProfile.getFunctionName();
        boolean bl2 = pPFunctionProfile.isGroupMember(this.ppTrial.getHighlightedGroup());
        double d3 = d2 / d;
        int n5 = (int)(d3 * (double)this.barLength);
        if (n5 == 0) {
            n5 = 1;
        }
        if (n5 > 2 && n3 > 2) {
            graphics2D.setColor(pPFunctionProfile.getColor());
            graphics2D.fillRect(n - n5 + 1, n2 - n3 + 1, n5 - 1, n3 - 1);
            if (function == this.ppTrial.getHighlightedFunction()) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getHighlightColor());
                graphics2D.drawRect(n - n5, n2 - n3, n5, n3);
                graphics2D.drawRect(n - n5 + 1, n2 - n3 + 1, n5 - 2, n3 - 2);
            } else if (bl2) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getGroupHighlightColor());
                graphics2D.drawRect(n - n5, n2 - n3, n5, n3);
                graphics2D.drawRect(n - n5 + 1, n2 - n3 + 1, n5 - 2, n3 - 2);
            } else {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n - n5, n2 - n3, n5, n3);
            }
        } else {
            if (function == this.ppTrial.getHighlightedFunction()) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getHighlightColor());
            } else if (bl2) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getGroupHighlightColor());
            } else {
                graphics2D.setColor(pPFunctionProfile.getColor());
            }
            graphics2D.fillRect(n - n5, n2 - n3, n5, n3);
        }
        graphics2D.setColor(Color.black);
        String string3 = this.window.getDataSorter().getValueType() == ValueType.EXCLUSIVE_PERCENT || this.window.getDataSorter().getValueType() == ValueType.INCLUSIVE_PERCENT ? UtilFncs.getOutputString((int)0, (double)d2, (int)6) + "%" : UtilFncs.getOutputString((int)this.window.units(), (double)d2, (int)ParaProf.defaultNumberPrecision);
        int n6 = fontMetrics.stringWidth(string3);
        int n7 = n - n5 - n6 - 5;
        graphics2D.drawString(string3, n7, n2);
        int n8 = n + 5;
        int n9 = n2;
        this.searcher.drawHighlights(graphics2D, n8, n9, n4);
        graphics2D.setPaint(Color.black);
        graphics2D.drawString(string, n8, n9);
    }

    public void setBarLength(int n) {
        this.barLength = Math.max(1, n);
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            PPFunctionProfile pPFunctionProfile = null;
            int n4 = n2 / this.ppTrial.getPreferencesWindow().getBarSpacing();
            if (this.list != null && n4 < this.list.size()) {
                pPFunctionProfile = (PPFunctionProfile)this.list.get(n4);
                if (ParaProfUtils.rightClick(mouseEvent)) {
                    JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(this.ppTrial, pPFunctionProfile.getFunction(), this);
                    jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
                this.ppTrial.toggleHighlightedFunction(pPFunctionProfile.getFunction());
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.window.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n, List list, int n2, int n3) {
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        PPFunctionProfile pPFunctionProfile = null;
        int n7 = n2;
        while (n7 <= n3) {
            pPFunctionProfile = (PPFunctionProfile)list.get(n7);
            this.maxRightSideStringPixelWidth = Math.max(this.maxRightSideStringPixelWidth, fontMetrics.stringWidth(pPFunctionProfile.getFunctionName() + 5));
            ++n7;
        }
        n6 = n + 5 + this.maxRightSideStringPixelWidth;
        n4 = Math.max(n4, n6);
        n5 = this.barSpacing + (list.size() - 1) * this.barSpacing;
        if (n5 != this.yPanelSize || n4 != this.xPanelSize) {
            this.yPanelSize = n5;
            this.xPanelSize = n4;
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            bl = false;
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }
}

