/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.CallPathUtilFuncs;
import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.CallPathDrawObject;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Searcher;
import edu.uoregon.tau.paraprof.interfaces.ImageExport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class CallPathTextWindowPanel
extends JPanel
implements MouseListener,
Printable,
ImageExport {
    private int xPanelSize = 800;
    private int yPanelSize = 600;
    private boolean calculatePanelSize = true;
    private Thread thread;
    private ParaProfTrial ppTrial = null;
    private CallPathTextWindow window = null;
    private int windowType = 0;
    private Font monoFont = null;
    private FontMetrics fontMetrics = null;
    private Vector drawObjectsComplete = null;
    private Vector drawObjects = null;
    private int spacing = 0;
    private int base = 20;
    private int startPosition = 0;
    private int stringWidth = 0;
    private int numCallsWidth = 0;
    private int excPos = 0;
    private int incPos = 0;
    private int callsPos1 = 0;
    private int namePos = 0;
    private int yHeightNeeded = 0;
    private int xWidthNeeded = 0;
    private Object clickedOnObject = null;
    private int lastHeaderEndPosition = 0;
    private Searcher searcher;
    private String normalHeader = "      Exclusive        Inclusive      Calls/Tot.Calls     Name[id]";
    private String normalDashString = "      --------------------------------------------------------------------------------";
    private JPopupMenu popup;

    public CallPathTextWindowPanel(ParaProfTrial paraProfTrial, Thread thread, CallPathTextWindow callPathTextWindow, int n) {
        this.thread = thread;
        this.ppTrial = paraProfTrial;
        this.window = callPathTextWindow;
        this.windowType = n;
        this.setAutoscrolls(true);
        this.searcher = new Searcher(this, callPathTextWindow);
        this.addMouseListener(this.searcher);
        this.addMouseMotionListener(this.searcher);
        this.setBackground(Color.white);
        this.addMouseListener(this);
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.export((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    private void createDrawObjectsComplete() {
        this.drawObjectsComplete = new Vector();
        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        ListIterator listIterator = this.window.getDataIterator();
        while (listIterator.hasNext()) {
            Iterator iterator;
            Object object;
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
            if (pPFunctionProfile.isCallPathObject()) continue;
            Iterator iterator2 = pPFunctionProfile.getParentProfiles();
            while (iterator2.hasNext()) {
                Object object2;
                object = (FunctionProfile)iterator2.next();
                iterator = pPFunctionProfile.getFunctionProfile().getParentProfileCallPathIterator((FunctionProfile)object);
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                while (iterator.hasNext()) {
                    object2 = (FunctionProfile)iterator.next();
                    d += object2.getExclusive(this.ppTrial.getDefaultMetricID());
                    d2 += object2.getInclusive(this.ppTrial.getDefaultMetricID());
                    d3 += object2.getNumCalls();
                }
                object2 = new CallPathDrawObject(object.getFunction(), true, false, false);
                ((CallPathDrawObject)object2).setExclusiveValue(d);
                ((CallPathDrawObject)object2).setInclusiveValue(d2);
                ((CallPathDrawObject)object2).setNumberOfCallsFromCallPathObjects(d3);
                ((CallPathDrawObject)object2).setNumberOfCalls(pPFunctionProfile.getNumberOfCalls());
                this.drawObjectsComplete.add(object2);
            }
            object = new CallPathDrawObject(pPFunctionProfile.getFunction(), false, false, false);
            ((CallPathDrawObject)object).setExclusiveValue(pPFunctionProfile.getExclusiveValue());
            ((CallPathDrawObject)object).setInclusiveValue(pPFunctionProfile.getInclusiveValue());
            ((CallPathDrawObject)object).setNumberOfCalls(pPFunctionProfile.getNumberOfCalls());
            this.drawObjectsComplete.add(object);
            iterator = pPFunctionProfile.getChildProfiles();
            while (iterator.hasNext()) {
                FunctionProfile functionProfile = (FunctionProfile)iterator.next();
                double d = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                Iterator iterator3 = pPFunctionProfile.getFunctionProfile().getChildProfileCallPathIterator(functionProfile);
                while (iterator3.hasNext()) {
                    FunctionProfile functionProfile2 = (FunctionProfile)iterator3.next();
                    d += functionProfile2.getExclusive(this.ppTrial.getDefaultMetricID());
                    d4 += functionProfile2.getInclusive(this.ppTrial.getDefaultMetricID());
                    d5 += functionProfile2.getNumCalls();
                }
                object = new CallPathDrawObject(functionProfile.getFunction(), false, true, false);
                ((CallPathDrawObject)object).setExclusiveValue(d);
                ((CallPathDrawObject)object).setInclusiveValue(d4);
                ((CallPathDrawObject)object).setNumberOfCallsFromCallPathObjects(d5);
                ((CallPathDrawObject)object).setNumberOfCalls(functionProfile.getNumCalls());
                this.drawObjectsComplete.add(object);
            }
            this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
            this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        }
    }

    private void createDrawObjects() {
        this.drawObjects = new Vector();
        Vector<CallPathDrawObject> vector = new Vector<CallPathDrawObject>();
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        if (this.window.showCollapsedView()) {
            Enumeration enumeration = this.drawObjectsComplete.elements();
            while (enumeration.hasMoreElements()) {
                CallPathDrawObject callPathDrawObject = (CallPathDrawObject)enumeration.nextElement();
                n = callPathDrawObject.isSpacer() ? 0 : (callPathDrawObject.isParent() ? (bl ? 1 : 2) : (callPathDrawObject.isChild() ? (bl ? 3 : 4) : (bl ? 5 : 6)));
                switch (n) {
                    case 0: {
                        this.drawObjects.add(callPathDrawObject);
                        break;
                    }
                    case 1: {
                        bl = false;
                        vector.add(callPathDrawObject);
                        break;
                    }
                    case 2: {
                        vector.add(callPathDrawObject);
                        break;
                    }
                    case 3: {
                        this.drawObjects.add(callPathDrawObject);
                        break;
                    }
                    case 5: {
                        n2 = vector.size();
                        int n3 = 0;
                        while (n3 < n2) {
                            this.drawObjects.add(vector.elementAt(n3));
                            ++n3;
                        }
                        vector.clear();
                        this.drawObjects.add(callPathDrawObject);
                        if (callPathDrawObject.isExpanded()) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 6: {
                        if (callPathDrawObject.isExpanded()) {
                            n2 = vector.size();
                            int n4 = 0;
                            while (n4 < n2) {
                                this.drawObjects.add(vector.elementAt(n4));
                                ++n4;
                            }
                            vector.clear();
                            bl = true;
                        } else {
                            vector.clear();
                        }
                        this.drawObjects.add(callPathDrawObject);
                        break;
                    }
                }
            }
        } else {
            this.drawObjects = this.drawObjectsComplete;
        }
    }

    private void createDrawObjectsCompleteStupid() {
        this.drawObjectsComplete = new Vector();
        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        Iterator iterator = this.thread.getFunctionProfileIterator();
        while (iterator.hasNext()) {
            CallPathDrawObject callPathDrawObject;
            Object object;
            FunctionProfile functionProfile = (FunctionProfile)iterator.next();
            if (functionProfile.isCallPathFunction()) continue;
            Iterator iterator2 = functionProfile.getParentProfiles();
            while (iterator2.hasNext()) {
                object = (FunctionProfile)iterator2.next();
                callPathDrawObject = new CallPathDrawObject(object.getFunction(), true, false, false);
                this.drawObjectsComplete.add(callPathDrawObject);
            }
            object = new CallPathDrawObject(functionProfile.getFunction(), false, false, false);
            this.drawObjectsComplete.add(object);
            iterator2 = functionProfile.getChildProfiles();
            while (iterator2.hasNext()) {
                callPathDrawObject = (FunctionProfile)iterator2.next();
                object = new CallPathDrawObject(callPathDrawObject.getFunction(), false, true, false);
                this.drawObjectsComplete.add(object);
            }
            this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
            this.drawObjectsComplete.add(new CallPathDrawObject(null, false, false, true));
        }
    }

    private void createDrawObjectsStupid() {
        this.drawObjects = new Vector();
        Vector<CallPathDrawObject> vector = new Vector<CallPathDrawObject>();
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        if (this.window.showCollapsedView()) {
            Enumeration enumeration = this.drawObjectsComplete.elements();
            while (enumeration.hasMoreElements()) {
                CallPathDrawObject callPathDrawObject = (CallPathDrawObject)enumeration.nextElement();
                n = callPathDrawObject.isSpacer() ? 0 : (callPathDrawObject.isParent() ? (bl ? 1 : 2) : (callPathDrawObject.isChild() ? (bl ? 3 : 4) : (bl ? 5 : 6)));
                switch (n) {
                    case 0: {
                        this.drawObjects.add(callPathDrawObject);
                        break;
                    }
                    case 1: {
                        bl = false;
                        vector.add(callPathDrawObject);
                        break;
                    }
                    case 2: {
                        vector.add(callPathDrawObject);
                        break;
                    }
                    case 3: {
                        this.drawObjects.add(callPathDrawObject);
                        break;
                    }
                    case 5: {
                        n2 = vector.size();
                        int n3 = 0;
                        while (n3 < n2) {
                            this.drawObjects.add(vector.elementAt(n3));
                            ++n3;
                        }
                        vector.clear();
                        this.drawObjects.add(callPathDrawObject);
                        if (callPathDrawObject.isExpanded()) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 6: {
                        if (callPathDrawObject.isExpanded()) {
                            n2 = vector.size();
                            int n4 = 0;
                            while (n4 < n2) {
                                this.drawObjects.add(vector.elementAt(n4));
                                ++n4;
                            }
                            vector.clear();
                            bl = true;
                        } else {
                            vector.clear();
                        }
                        this.drawObjects.add(callPathDrawObject);
                        break;
                    }
                }
            }
        } else {
            this.drawObjects = this.drawObjectsComplete;
        }
    }

    private void setSearchLines() {
        if (this.searcher.getSearchLines() == null) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < this.drawObjects.size()) {
                Function function;
                String string;
                CallPathDrawObject callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(n);
                if (n == 1) {
                    string = this.normalHeader;
                } else if (n == 2) {
                    string = this.normalDashString;
                } else if (!callPathDrawObject.isParentChild() && !callPathDrawObject.isSpacer()) {
                    function = callPathDrawObject.getFunction();
                    string = "--> " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getExclusiveValue(), (int)11) + "      " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getInclusiveValue(), (int)11) + "      " + UtilFncs.formatDouble((double)callPathDrawObject.getNumberOfCalls(), (int)7, (boolean)false);
                    string = UtilFncs.pad((String)string, (int)58) + callPathDrawObject.getName() + "[" + function.getID() + "]";
                } else if (callPathDrawObject.isSpacer()) {
                    string = " ";
                } else {
                    function = callPathDrawObject.getFunction();
                    string = "    " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getExclusiveValue(), (int)11) + "      " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getInclusiveValue(), (int)11) + "      " + UtilFncs.formatDouble((double)callPathDrawObject.getNumberOfCallsFromCallPathObjects(), (int)7, (boolean)false) + "/" + UtilFncs.formatDouble((double)callPathDrawObject.getNumberOfCalls(), (int)7, (boolean)false);
                    string = UtilFncs.pad((String)string, (int)58) + callPathDrawObject.getName() + "[" + function.getID() + "]";
                }
                vector.add(string);
                ++n;
            }
            this.searcher.setSearchLines(vector);
        }
    }

    private void setSearchLinesStupid() {
        if (this.searcher.getSearchLines() == null) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < this.drawObjects.size()) {
                Function function;
                String string;
                CallPathDrawObject callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(n);
                if (n == 1) {
                    string = "    Name[id]";
                } else if (n == 2) {
                    string = "    --------------------------------------------------------------------------------";
                } else if (!callPathDrawObject.isParentChild() && !callPathDrawObject.isSpacer()) {
                    function = callPathDrawObject.getFunction();
                    string = "--> " + callPathDrawObject.getName() + "[" + function.getID() + "]";
                } else if (callPathDrawObject.isSpacer()) {
                    string = " ";
                } else {
                    function = callPathDrawObject.getFunction();
                    string = "    " + callPathDrawObject.getName() + "[" + function.getID() + "]";
                }
                vector.add(string);
                ++n;
            }
            this.searcher.setSearchLines(vector);
        }
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        block43: {
            String string;
            Object object;
            int n;
            int n2;
            block42: {
                Object object2;
                int n3;
                int n4 = ParaProf.defaultNumberPrecision;
                n2 = 0;
                int n5 = this.ppTrial.getPreferencesWindow().getBarHeight();
                this.spacing = this.ppTrial.getPreferencesWindow().getBarSpacing();
                this.monoFont = new Font("Monospaced", this.ppTrial.getPreferencesWindow().getFontStyle(), n5);
                this.fontMetrics = graphics2D.getFontMetrics(this.monoFont);
                int n6 = this.fontMetrics.getMaxAscent();
                int n7 = this.fontMetrics.getMaxDescent();
                graphics2D.setFont(this.monoFont);
                if (this.spacing <= n6 + n7) {
                    ++this.spacing;
                }
                this.searcher.setXOffset(this.base);
                this.searcher.setG2d(graphics2D);
                this.searcher.setLineHeight(this.spacing);
                if (this.windowType != 0) break block42;
                Object var10_10 = null;
                Object var11_12 = null;
                Object var12_14 = null;
                Object var13_16 = null;
                List list = null;
                Object var15_20 = null;
                CallPathDrawObject callPathDrawObject = null;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                CallPathUtilFuncs.buildThreadRelations((DataSource)this.ppTrial.getDataSource(), (Thread)this.thread);
                list = this.thread.getFunctionProfiles();
                if (this.drawObjectsComplete == null) {
                    this.createDrawObjectsComplete();
                }
                if (this.drawObjects == null) {
                    this.createDrawObjects();
                    this.searcher.setSearchLines(null);
                    this.setSearchLines();
                }
                if (this.calculatePanelSize) {
                    int n8 = 0;
                    Enumeration enumeration = this.drawObjects.elements();
                    while (enumeration.hasMoreElements()) {
                        callPathDrawObject = (CallPathDrawObject)enumeration.nextElement();
                        this.yHeightNeeded += this.spacing;
                        if (callPathDrawObject.isSpacer()) continue;
                        n8 = Math.max(n8, callPathDrawObject.getName().length());
                    }
                    n3 = this.fontMetrics.stringWidth("A");
                    this.startPosition = this.fontMetrics.stringWidth("--> ") + this.base;
                    this.excPos = this.base + n3 * 4;
                    this.incPos = this.excPos + n3 * 17;
                    this.callsPos1 = this.incPos + n3 * 17;
                    this.namePos = this.callsPos1 + n3 * 20;
                    this.xWidthNeeded = n8 * n3 + this.namePos + 30;
                    boolean bl4 = false;
                    if (this.xWidthNeeded > this.xPanelSize) {
                        this.xPanelSize = this.xWidthNeeded + 10;
                        bl4 = true;
                    }
                    if (this.yHeightNeeded > this.yPanelSize) {
                        this.yPanelSize = this.yHeightNeeded + 10;
                        bl4 = true;
                    }
                    if (bl4 && bl) {
                        this.revalidate();
                    }
                    this.calculatePanelSize = false;
                }
                int[] nArray = ParaProfUtils.computeClipping(graphics2D.getClipBounds(), this.window.getViewRect(), bl, bl2, this.drawObjects.size(), this.spacing, n2);
                int n9 = nArray[0];
                n3 = nArray[1];
                n2 = nArray[2];
                graphics2D.setColor(Color.black);
                if (bl3) {
                    n2 += this.spacing;
                    String string2 = this.window.getHeaderString();
                    object2 = new StringTokenizer(string2, "'\n'");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        graphics2D.drawString(((StringTokenizer)object2).nextToken(), 15, n2);
                        n2 += this.spacing;
                    }
                    this.lastHeaderEndPosition = n2;
                }
                n2 += this.spacing;
                int n10 = n9;
                while (n10 <= n3) {
                    Function function;
                    this.searcher.drawHighlights(graphics2D, this.base, n2, n10);
                    graphics2D.setColor(Color.black);
                    callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(n10);
                    if (n10 == 1) {
                        object2 = this.normalHeader;
                        graphics2D.drawString((String)object2, this.base, n2);
                    } else if (n10 == 2) {
                        object2 = this.normalDashString;
                        graphics2D.drawString((String)object2, this.base, n2);
                    } else if (!callPathDrawObject.isParentChild() && !callPathDrawObject.isSpacer()) {
                        object2 = "--> " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getExclusiveValue(), (int)11) + "      " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getInclusiveValue(), (int)11) + "      " + UtilFncs.formatDouble((double)callPathDrawObject.getNumberOfCalls(), (int)7, (boolean)false);
                        graphics2D.drawString((String)object2, this.base, n2);
                        function = callPathDrawObject.getFunction();
                        if (this.ppTrial.getHighlightedFunction() == function) {
                            graphics2D.setColor(Color.red);
                        }
                        graphics2D.drawString(callPathDrawObject.getName() + "[" + function.getID() + "]", this.namePos, n2);
                    } else if (!callPathDrawObject.isSpacer()) {
                        object2 = "    " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getExclusiveValue(), (int)11) + "      " + UtilFncs.getOutputString((int)this.window.units(), (double)callPathDrawObject.getInclusiveValue(), (int)11) + "      " + UtilFncs.formatDouble((double)callPathDrawObject.getNumberOfCallsFromCallPathObjects(), (int)7, (boolean)false) + "/" + UtilFncs.formatDouble((double)callPathDrawObject.getNumberOfCalls(), (int)7, (boolean)false);
                        function = callPathDrawObject.getFunction();
                        if (this.ppTrial.getHighlightedFunction() == function) {
                            graphics2D.setColor(Color.red);
                        }
                        String string3 = callPathDrawObject.getName() + "[" + function.getID() + "]";
                        object2 = UtilFncs.pad((String)object2, (int)58) + string3;
                        graphics2D.drawString((String)object2, this.base, n2);
                    }
                    n2 += this.spacing;
                    ++n10;
                }
                break block43;
            }
            if (this.windowType != 1) break block43;
            Object var10_11 = null;
            Object var11_13 = null;
            Object var12_15 = null;
            CallPathDrawObject callPathDrawObject = null;
            Object var14_19 = null;
            CallPathUtilFuncs.buildThreadRelations((DataSource)this.ppTrial.getDataSource(), (Thread)this.thread);
            if (this.drawObjectsComplete == null) {
                this.createDrawObjectsCompleteStupid();
            }
            if (this.drawObjects == null) {
                this.createDrawObjectsStupid();
                this.searcher.setSearchLines(null);
                this.setSearchLinesStupid();
            }
            if (this.calculatePanelSize) {
                int n11 = 0;
                Enumeration enumeration = this.drawObjects.elements();
                while (enumeration.hasMoreElements()) {
                    callPathDrawObject = (CallPathDrawObject)enumeration.nextElement();
                    this.yHeightNeeded += this.spacing;
                    if (callPathDrawObject.isSpacer()) continue;
                    n11 = Math.max(n11, callPathDrawObject.getName().length());
                }
                this.startPosition = this.fontMetrics.stringWidth("--> ") + this.base;
                n = this.fontMetrics.stringWidth("A");
                this.xWidthNeeded = n11 * n + this.startPosition + 30;
                boolean bl5 = false;
                if (this.xWidthNeeded > this.xPanelSize) {
                    this.xPanelSize = this.xWidthNeeded + 10;
                    bl5 = true;
                }
                if (this.yHeightNeeded > this.yPanelSize) {
                    this.yPanelSize = this.yHeightNeeded + 10;
                    bl5 = true;
                }
                if (bl5 && bl) {
                    this.revalidate();
                }
                this.calculatePanelSize = false;
            }
            int[] nArray = ParaProfUtils.computeClipping(graphics2D.getClipBounds(), this.window.getViewRect(), bl, bl2, this.drawObjects.size(), this.spacing, n2);
            int n12 = nArray[0];
            n = nArray[1];
            n2 = nArray[2];
            graphics2D.setColor(Color.black);
            if (bl3) {
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                object = this.getInsets();
                n2 += this.spacing;
                string = this.window.getHeaderString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
                while (stringTokenizer.hasMoreTokens()) {
                    AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                    attributedString.addAttribute(TextAttribute.FONT, this.monoFont);
                    AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                    LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                    float f = this.getSize().width - ((Insets)object).left - ((Insets)object).right;
                    float f2 = ((Insets)object).left;
                    float f3 = ((Insets)object).right;
                    while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                        TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                        textLayout.draw(graphics2D, f2, n2 += this.spacing);
                        f2 = ((Insets)object).left;
                    }
                }
                this.lastHeaderEndPosition = n2;
            }
            n2 += this.spacing;
            int n13 = n12;
            while (n13 <= n) {
                this.searcher.drawHighlights(graphics2D, this.base, n2, n13);
                callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(n13);
                graphics2D.setColor(Color.black);
                if (n13 == 1) {
                    object = "    Name[id]";
                } else if (n13 == 2) {
                    object = "    --------------------------------------------------------------------------------";
                } else if (!callPathDrawObject.isParentChild() && !callPathDrawObject.isSpacer()) {
                    string = callPathDrawObject.getFunction();
                    if (this.ppTrial.getHighlightedFunction() == string) {
                        graphics2D.setColor(Color.red);
                    }
                    object = "--> " + callPathDrawObject.getName() + "[" + string.getID() + "]";
                } else if (callPathDrawObject.isSpacer()) {
                    object = "";
                } else {
                    string = callPathDrawObject.getFunction();
                    if (this.ppTrial.getHighlightedFunction() == string) {
                        graphics2D.setColor(Color.red);
                    }
                    object = "    " + callPathDrawObject.getName() + "[" + string.getID() + "]";
                }
                if (object != "") {
                    graphics2D.drawString((String)object, this.base, n2);
                }
                n2 += this.spacing;
                ++n13;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            CallPathDrawObject callPathDrawObject;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            int n4 = (n2 - 1) / this.ppTrial.getPreferencesWindow().getBarSpacing();
            if (n4 < this.drawObjects.size() && !(callPathDrawObject = (CallPathDrawObject)this.drawObjects.elementAt(n4)).isSpacer()) {
                if (ParaProfUtils.rightClick(mouseEvent)) {
                    JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(this.ppTrial, callPathDrawObject.getFunction(), this);
                    JMenuItem jMenuItem = new JMenuItem("Goto Function");
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                Function function = callPathDrawObject.getFunction();
                                int n = CallPathTextWindowPanel.this.drawObjects.size();
                                int n2 = 0;
                                while (n2 < n) {
                                    CallPathDrawObject callPathDrawObject2 = (CallPathDrawObject)CallPathTextWindowPanel.this.drawObjects.elementAt(n2);
                                    if (callPathDrawObject2.getFunction() == function && !callPathDrawObject2.isParentChild()) {
                                        Dimension dimension = CallPathTextWindowPanel.this.window.getViewportSize();
                                        CallPathTextWindowPanel.this.window.setVerticalScrollBarPosition(n2 * CallPathTextWindowPanel.this.ppTrial.getPreferencesWindow().getBarSpacing() - (int)dimension.getHeight() / 2);
                                        CallPathTextWindowPanel.this.ppTrial.setHighlightedFunction(function);
                                        return;
                                    }
                                    ++n2;
                                }
                            }
                            catch (Exception exception) {
                                ParaProfUtils.handleException(exception);
                            }
                        }
                    });
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    if (n < this.startPosition) {
                        if (!callPathDrawObject.isParentChild()) {
                            if (callPathDrawObject.isExpanded()) {
                                callPathDrawObject.setExpanded(false);
                            } else {
                                callPathDrawObject.setExpanded(true);
                            }
                        }
                        this.drawObjects = null;
                    }
                    this.ppTrial.toggleHighlightedFunction(callPathDrawObject.getFunction());
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.window.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    public void resetAllDrawObjects() {
        this.drawObjectsComplete.clear();
        this.drawObjectsComplete = null;
        this.drawObjects.clear();
        this.drawObjects = null;
        this.searcher.setSearchLines(null);
        this.calculatePanelSize = true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }

    public Searcher getSearcher() {
        return this.searcher;
    }
}

