/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.CallPathUtilFuncs;
import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.DataSourceException;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.dms.dss.UserEventProfile;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;

public class PackedProfileDataSource
extends DataSource {
    private File file;
    private volatile boolean abort = false;
    private volatile long totalBytes = 0L;
    private volatile long bytesRead = 0L;
    private volatile TrackerInputStream tracker;

    public PackedProfileDataSource(File file) {
        this.file = file;
    }

    public void cancelLoad() {
        this.abort = true;
    }

    public int getProgress() {
        if (this.totalBytes != 0L) {
            return (int)((float)this.tracker.byteCount() / (float)this.totalBytes * 100.0f);
        }
        return 0;
    }

    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
        int n;
        int n2;
        UserEvent[] userEventArray;
        int n3;
        int n4;
        Group[] groupArray;
        int n5;
        long l = System.currentTimeMillis();
        FileInputStream fileInputStream = new FileInputStream(this.file);
        this.tracker = new TrackerInputStream(fileInputStream);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(this.tracker);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(gZIPInputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        this.totalBytes = this.file.length();
        char c = dataInputStream.readChar();
        char c2 = dataInputStream.readChar();
        char c3 = dataInputStream.readChar();
        if (c != 'P' || c2 != 'P' || c3 != 'K') {
            throw new DataSourceException("This doesn't look like a packed profile");
        }
        int n6 = dataInputStream.readInt();
        int n7 = dataInputStream.readInt();
        if (n7 != 1) {
            throw new DataSourceException("This packed profile is not compatible, please upgrade\nVersion: " + n7 + " > " + "1");
        }
        int n8 = dataInputStream.readInt();
        dataInputStream.skipBytes(n8);
        int n9 = dataInputStream.readInt();
        for (n5 = 0; n5 < n9; ++n5) {
            groupArray = dataInputStream.readUTF();
            this.addMetric((String)groupArray);
        }
        n5 = dataInputStream.readInt();
        if (n5 != 0) {
            this.setGroupNamesPresent(true);
        }
        groupArray = new Group[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            groupArray[n4] = this.addGroup(dataInputStream.readUTF());
        }
        n4 = dataInputStream.readInt();
        Function[] functionArray = new Function[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            Function function;
            userEventArray = dataInputStream.readUTF();
            functionArray[n3] = function = this.addFunction((String)userEventArray, n9);
            int n10 = dataInputStream.readInt();
            for (int i = 0; i < n10; ++i) {
                n2 = dataInputStream.readInt();
                function.addGroup(groupArray[n2]);
            }
        }
        n3 = dataInputStream.readInt();
        userEventArray = new UserEvent[n3];
        for (n = 0; n < n3; ++n) {
            UserEvent userEvent;
            String string = dataInputStream.readUTF();
            userEventArray[n] = userEvent = this.addUserEvent(string);
        }
        n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n11;
            int n12;
            int n13 = dataInputStream.readInt();
            n2 = dataInputStream.readInt();
            int n14 = dataInputStream.readInt();
            Node node = this.addNode(n13);
            Context context = node.addContext(n2);
            Thread thread = context.addThread(n14, n9);
            int n15 = dataInputStream.readInt();
            for (n12 = 0; n12 < n15; ++n12) {
                n11 = dataInputStream.readInt();
                FunctionProfile functionProfile = new FunctionProfile(functionArray[n11], n9);
                functionProfile.setNumCalls(dataInputStream.readDouble());
                functionProfile.setNumSubr(dataInputStream.readDouble());
                for (int j = 0; j < n9; ++j) {
                    functionProfile.setExclusive(j, dataInputStream.readDouble());
                    functionProfile.setInclusive(j, dataInputStream.readDouble());
                }
                thread.addFunctionProfile(functionProfile);
            }
            n12 = dataInputStream.readInt();
            for (n11 = 0; n11 < n12; ++n11) {
                int n16 = dataInputStream.readInt();
                UserEventProfile userEventProfile = new UserEventProfile(userEventArray[n16]);
                userEventProfile.setUserEventNumberValue(dataInputStream.readInt());
                userEventProfile.setUserEventMinValue(dataInputStream.readDouble());
                userEventProfile.setUserEventMaxValue(dataInputStream.readDouble());
                userEventProfile.setUserEventMeanValue(dataInputStream.readDouble());
                userEventProfile.setUserEventSumSquared(dataInputStream.readDouble());
                userEventProfile.updateMax();
                thread.addUserEvent(userEventProfile);
            }
        }
        dataInputStream.close();
        gZIPInputStream.close();
        this.tracker.close();
        fileInputStream.close();
        if (n3 > 0) {
            this.setUserEventsPresent(true);
        }
        this.generateDerivedData();
        if (CallPathUtilFuncs.checkCallPathsPresent(this.getFunctions())) {
            this.setCallPathDataPresent(true);
        }
    }

    class TrackerInputStream
    extends FilterInputStream {
        private int count;

        public TrackerInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public int byteCount() {
            return this.count;
        }

        public int read() throws IOException {
            ++this.count;
            return super.read();
        }

        public int read(byte[] byArray) throws IOException {
            this.count += byArray.length;
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            if (n3 > 0) {
                this.count += n3;
            }
            return n3;
        }
    }
}

