/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.DataSourceException;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UserEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class DataSource {
    private static boolean meanIncludeNulls = true;
    private boolean userEventsPresent = false;
    private boolean callPathDataPresent = false;
    private boolean groupNamesPresent = false;
    private List metrics = null;
    protected Thread meanData = null;
    protected Thread totalData = null;
    protected Thread stddevData = null;
    private Map nodes = new TreeMap();
    private Map functions = new TreeMap();
    private Map groups = new TreeMap();
    private Map userEvents = new TreeMap();
    private List allThreads;
    private int[] maxNCT = null;

    public abstract void load() throws FileNotFoundException, IOException, DataSourceException, SQLException;

    public abstract int getProgress();

    public abstract void cancelLoad();

    public Thread getMeanData() {
        return this.meanData;
    }

    public Thread getStdDevData() {
        return this.stddevData;
    }

    public Thread getTotalData() {
        return this.totalData;
    }

    protected void setCallPathDataPresent(boolean bl) {
        this.callPathDataPresent = bl;
    }

    public boolean getCallPathDataPresent() {
        return this.callPathDataPresent;
    }

    protected void setGroupNamesPresent(boolean bl) {
        this.groupNamesPresent = bl;
    }

    public boolean getGroupNamesPresent() {
        return this.groupNamesPresent;
    }

    protected void setUserEventsPresent(boolean bl) {
        this.userEventsPresent = bl;
    }

    public boolean getUserEventsPresent() {
        return this.userEventsPresent;
    }

    public Function addFunction(String string) {
        return this.addFunction(string, this.getNumberOfMetrics());
    }

    public Function addFunction(String string, int n) {
        Object v = this.functions.get(string = string.trim());
        if (v != null) {
            return (Function)v;
        }
        Function function = new Function(string, this.functions.size(), n);
        this.functions.put(string, function);
        return function;
    }

    public Function getFunction(String string) {
        Function function = (Function)this.functions.get(string.trim());
        return (Function)this.functions.get(string.trim());
    }

    public int getNumFunctions() {
        return this.functions.size();
    }

    public Iterator getFunctions() {
        return this.functions.values().iterator();
    }

    public UserEvent addUserEvent(String string) {
        Object v = this.userEvents.get(string);
        if (v != null) {
            return (UserEvent)v;
        }
        UserEvent userEvent = new UserEvent(string, this.userEvents.size() + 1);
        this.userEvents.put(string, userEvent);
        return userEvent;
    }

    public UserEvent getUserEvent(String string) {
        return (UserEvent)this.userEvents.get(string);
    }

    public int getNumUserEvents() {
        return this.userEvents.size();
    }

    public Iterator getUserEvents() {
        return this.userEvents.values().iterator();
    }

    public Group addGroup(String string) {
        Object v = this.groups.get(string);
        if (v != null) {
            return (Group)v;
        }
        Group group = new Group(string, this.groups.size() + 1);
        this.groups.put(string, group);
        return group;
    }

    public int getNumGroups() {
        return this.groups.size();
    }

    public Iterator getGroups() {
        return this.groups.values().iterator();
    }

    public int[] getMaxNCTNumbers() {
        if (this.maxNCT == null) {
            this.maxNCT = new int[3];
            Iterator iterator = this.getNodes();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (node.getNodeID() > this.maxNCT[0]) {
                    this.maxNCT[0] = node.getNodeID();
                }
                Iterator iterator2 = node.getContexts();
                while (iterator2.hasNext()) {
                    Context context = (Context)iterator2.next();
                    if (context.getContextID() > this.maxNCT[1]) {
                        this.maxNCT[1] = context.getContextID();
                    }
                    Iterator iterator3 = context.getThreads();
                    while (iterator3.hasNext()) {
                        Thread thread = (Thread)iterator3.next();
                        if (thread.getThreadID() <= this.maxNCT[2]) continue;
                        this.maxNCT[2] = thread.getThreadID();
                    }
                }
            }
        }
        return this.maxNCT;
    }

    public int getNumThreads() {
        int n = 0;
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    iterator3.next();
                    ++n;
                }
            }
        }
        return n;
    }

    public void setMetrics(List list) {
        this.metrics = list;
    }

    public void addMetric(Metric metric) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        metric.setID(this.getNumberOfMetrics());
        this.metrics.add(metric);
    }

    public Metric addMetric(String string) {
        Object object;
        if (this.metrics != null) {
            object = this.metrics.iterator();
            while (object.hasNext()) {
                Metric metric = (Metric)object.next();
                if (!metric.getName().equals(string)) continue;
                return metric;
            }
        }
        object = new Metric();
        ((Metric)object).setName(string);
        this.addMetric((Metric)object);
        return object;
    }

    public List getMetrics() {
        return this.metrics;
    }

    public Metric getMetric(int n) {
        if (this.metrics != null && n < this.metrics.size()) {
            return (Metric)this.metrics.get(n);
        }
        return null;
    }

    public String getMetricName(int n) {
        if (this.metrics != null && n < this.metrics.size()) {
            return ((Metric)this.metrics.get(n)).getName();
        }
        return null;
    }

    public int getNumberOfMetrics() {
        if (this.metrics != null) {
            return this.metrics.size();
        }
        return -1;
    }

    public void generateDerivedData() {
        Iterator iterator = this.getAllThreads().iterator();
        while (iterator.hasNext()) {
            ((Thread)iterator.next()).setThreadDataAllMetrics();
        }
        this.generateStatistics(0, this.getNumberOfMetrics() - 1);
        this.meanData.setThreadDataAllMetrics();
        this.stddevData.setThreadDataAllMetrics();
    }

    public void generateStatistics(int n, int n2) {
        Comparable comparable;
        Object object;
        int n3 = this.getNumberOfMetrics();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        double[] dArray5 = new double[n3];
        if (this.meanData == null) {
            this.meanData = new Thread(-1, -1, -1, n3);
        }
        if (this.totalData == null) {
            this.totalData = new Thread(-2, -2, -2, n3);
        }
        if (this.stddevData == null) {
            this.stddevData = new Thread(-3, -3, -3, n3);
        }
        this.initAllThreadsList();
        for (int i = 0; i < n3; ++i) {
            object = this.allThreads.iterator();
            while (object.hasNext()) {
                comparable = (Thread)object.next();
                int n4 = i;
                dArray5[n4] = dArray5[n4] + ((Thread)comparable).getMaxInclusive(i);
            }
        }
        Iterator iterator = this.getFunctions();
        while (iterator.hasNext()) {
            int n5;
            int n6;
            object = (Function)iterator.next();
            comparable = this.meanData.getFunctionProfile((Function)object);
            if (comparable == null) {
                comparable = new FunctionProfile((Function)object, n3);
                this.meanData.addFunctionProfile((FunctionProfile)comparable);
            }
            ((Function)object).setMeanProfile((FunctionProfile)comparable);
            FunctionProfile functionProfile = this.totalData.getFunctionProfile((Function)object);
            if (functionProfile == null) {
                functionProfile = new FunctionProfile((Function)object, n3);
                this.totalData.addFunctionProfile(functionProfile);
            }
            ((Function)object).setTotalProfile(functionProfile);
            FunctionProfile functionProfile2 = this.stddevData.getFunctionProfile((Function)object);
            if (functionProfile2 == null) {
                functionProfile2 = new FunctionProfile((Function)object, n3);
                this.stddevData.addFunctionProfile(functionProfile2);
            }
            ((Function)object).setStddevProfile(functionProfile2);
            int n7 = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            for (n6 = 0; n6 < n3; ++n6) {
                dArray[n6] = 0.0;
                dArray2[n6] = 0.0;
                dArray3[n6] = 0.0;
                dArray4[n6] = 0.0;
            }
            n6 = this.allThreads.size();
            for (n5 = 0; n5 < n6; ++n5) {
                Thread thread = (Thread)this.allThreads.get(n5);
                FunctionProfile functionProfile3 = thread.getFunctionProfile((Function)object);
                if (functionProfile3 == null) continue;
                ++n7;
                for (int i = n; i <= n2; ++i) {
                    int n8 = i;
                    dArray[n8] = dArray[n8] + functionProfile3.getExclusive(i);
                    int n9 = i;
                    dArray2[n9] = dArray2[n9] + functionProfile3.getInclusive(i);
                    int n10 = i;
                    dArray3[n10] = dArray3[n10] + functionProfile3.getExclusive(i) * functionProfile3.getExclusive(i);
                    int n11 = i;
                    dArray4[n11] = dArray4[n11] + functionProfile3.getInclusive(i) * functionProfile3.getInclusive(i);
                    if (i != 0) continue;
                    d += functionProfile3.getNumCalls();
                    d2 += functionProfile3.getNumSubr();
                    d3 += functionProfile3.getNumCalls() * functionProfile3.getNumCalls();
                    d4 += functionProfile3.getNumSubr() * functionProfile3.getNumSubr();
                }
            }
            if (!meanIncludeNulls) {
                n6 = n7;
            }
            if (n == 0) {
                functionProfile.setNumCalls(d);
                functionProfile.setNumSubr(d2);
                ((FunctionProfile)comparable).setNumCalls(d / (double)n6);
                ((FunctionProfile)comparable).setNumSubr(d2 / (double)n6);
                double d5 = 0.0;
                if (n6 > 1) {
                    d5 = Math.sqrt(Math.abs(d3 / (double)(n6 - 1) - ((FunctionProfile)comparable).getNumCalls() * ((FunctionProfile)comparable).getNumCalls()));
                }
                functionProfile2.setNumCalls(d5);
                d5 = 0.0;
                if (n6 > 1) {
                    d5 = Math.sqrt(Math.abs(d4 / (double)(n6 - 1) - ((FunctionProfile)comparable).getNumSubr() * ((FunctionProfile)comparable).getNumSubr()));
                }
                functionProfile2.setNumSubr(d5);
            }
            for (n5 = n; n5 <= n2; ++n5) {
                functionProfile.setExclusive(n5, dArray[n5]);
                functionProfile.setInclusive(n5, dArray2[n5]);
                ((FunctionProfile)comparable).setExclusive(n5, dArray[n5] / (double)n6);
                ((FunctionProfile)comparable).setInclusive(n5, dArray2[n5] / (double)n6);
                double d6 = 0.0;
                if (n6 > 1) {
                    d6 = Math.sqrt(Math.abs(dArray3[n5] / (double)n6 - ((FunctionProfile)comparable).getExclusive(n5) * ((FunctionProfile)comparable).getExclusive(n5)));
                }
                functionProfile2.setExclusive(n5, d6);
                d6 = 0.0;
                if (n6 > 1) {
                    d6 = Math.sqrt(Math.abs(dArray4[n5] / (double)(n6 - 1) - ((FunctionProfile)comparable).getInclusive(n5) * ((FunctionProfile)comparable).getInclusive(n5)));
                }
                functionProfile2.setInclusive(n5, d6);
                if (dArray5[n5] == 0.0) continue;
                functionProfile.setInclusivePercent(n5, functionProfile.getInclusive(n5) / dArray5[n5] * 100.0);
                functionProfile.setExclusivePercent(n5, functionProfile.getExclusive(n5) / dArray5[n5] * 100.0);
                ((FunctionProfile)comparable).setInclusivePercent(n5, functionProfile.getInclusivePercent(n5));
                ((FunctionProfile)comparable).setExclusivePercent(n5, functionProfile.getExclusivePercent(n5));
                if (((FunctionProfile)comparable).getInclusive(n5) != 0.0) {
                    functionProfile2.setInclusivePercent(n5, functionProfile2.getInclusive(n5) / ((FunctionProfile)comparable).getInclusive(n5) * 100.0);
                }
                if (((FunctionProfile)comparable).getExclusive(n5) == 0.0) continue;
                functionProfile2.setExclusivePercent(n5, functionProfile2.getExclusive(n5) / ((FunctionProfile)comparable).getExclusive(n5) * 100.0);
            }
        }
    }

    public Node addNode(int n) {
        Object v = this.nodes.get(new Integer(n));
        if (v != null) {
            return (Node)v;
        }
        Node node = new Node(n);
        this.nodes.put(new Integer(n), node);
        return node;
    }

    public Node getNode(int n) {
        return (Node)this.nodes.get(new Integer(n));
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public Iterator getNodes() {
        return this.nodes.values().iterator();
    }

    public int getTotalNumberOfContexts() {
        int n = -1;
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            n += node.getNumberOfContexts();
        }
        return n;
    }

    public int getNumberOfContexts(int n) {
        return this.getNode(n).getNumberOfContexts();
    }

    public Iterator getContexts(int n) {
        Node node = this.getNode(n);
        if (node != null) {
            return node.getContexts();
        }
        return null;
    }

    public Context getContext(int n, int n2) {
        Node node = this.getNode(n);
        if (node != null) {
            return node.getContext(n2);
        }
        return null;
    }

    public int getTotalNumberOfThreads() {
        int n = 0;
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                n += context.getNumberOfThreads();
            }
        }
        return n;
    }

    public int getNumberOfThreads(int n, int n2) {
        return this.getContext(n, n2).getNumberOfThreads();
    }

    public List getThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = (Thread)iterator3.next();
                    arrayList.add(thread);
                }
            }
        }
        return arrayList;
    }

    public Thread getThread(int n, int n2, int n3) {
        if (n == -1) {
            return this.getMeanData();
        }
        if (n == -3) {
            return this.getStdDevData();
        }
        Context context = this.getContext(n, n2);
        Thread thread = null;
        if (context != null) {
            thread = context.getThread(n3);
        }
        return thread;
    }

    private void initAllThreadsList() {
        this.allThreads = new ArrayList();
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = (Thread)iterator3.next();
                    this.allThreads.add(thread);
                }
            }
        }
    }

    public List getAllThreads() {
        if (this.allThreads == null) {
            this.initAllThreadsList();
        }
        return this.allThreads;
    }

    public static void setMeanIncludeNulls(boolean bl) {
        meanIncludeNulls = bl;
    }
}

