/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.paraprof.treetable.TreeTableNode;
import edu.uoregon.tau.paraprof.treetable.TreeTableWindow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CallPathModel
extends AbstractTreeTableModel {
    private List roots;
    private Thread thread;
    private DataSource dataSource;
    private ParaProfTrial ppTrial;
    private double[] maxValues;
    private int sortColumn;
    private boolean sortAscending;
    private TreeTableWindow window;
    static /* synthetic */ Class class$edu$uoregon$tau$paraprof$treetable$TreeTableModel;

    public CallPathModel(TreeTableWindow treeTableWindow, ParaProfTrial paraProfTrial, Thread thread) {
        super(null);
        this.root = new TreeTableNode(null, this, "root");
        this.window = treeTableWindow;
        this.dataSource = paraProfTrial.getDataSource();
        this.thread = thread;
        this.ppTrial = paraProfTrial;
        this.setupData();
    }

    private void setupData() {
        this.roots = new ArrayList();
        DataSorter dataSorter = new DataSorter(this.ppTrial);
        List list = dataSorter.getFunctionProfiles(this.thread);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.window.getTreeMode()) {
            Object object;
            FunctionProfile functionProfile;
            Object object2;
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                object2 = (PPFunctionProfile)iterator.next();
                functionProfile = ((PPFunctionProfile)object2).getFunctionProfile();
                if (functionProfile == null || !functionProfile.isCallPathFunction()) continue;
                object = functionProfile.getName();
                int n = ((String)object).indexOf("=>");
                String string = ((String)object).substring(0, n).trim();
                if (hashMap.get(hashMap) != null) continue;
                hashMap.put(string, "1");
            }
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                functionProfile = this.dataSource.getFunction((String)object2);
                if (functionProfile == null) {
                    object = new TreeTableNode(null, this, (String)object2);
                } else {
                    FunctionProfile functionProfile2 = this.thread.getFunctionProfile((Function)functionProfile);
                    object = new TreeTableNode(functionProfile2, this, null);
                }
                this.roots.add(object);
            }
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)iterator.next();
                FunctionProfile functionProfile = pPFunctionProfile.getFunctionProfile();
                if (functionProfile == null) continue;
                String string = functionProfile.getName();
                TreeTableNode treeTableNode = new TreeTableNode(functionProfile, this, null);
                this.roots.add(treeTableNode);
            }
        }
        Collections.sort(this.roots);
        this.computeMaximum();
    }

    public void computeMaximum() {
        int n = this.window.getPPTrial().getNumberOfMetrics();
        this.maxValues = new double[n];
        Iterator iterator = this.roots.iterator();
        while (iterator.hasNext()) {
            TreeTableNode treeTableNode = (TreeTableNode)iterator.next();
            if (treeTableNode.getFunctionProfile() == null) continue;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.maxValues[n2] = this.maxValues[n2] + treeTableNode.getFunctionProfile().getInclusive(i);
            }
        }
    }

    public int getColumnCount() {
        return 1 + this.window.getColumns().size();
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Name";
        }
        return this.window.getColumns().get(n - 1).toString();
    }

    public Object getValueAt(Object object, int n) {
        if (object == this.root) {
            return null;
        }
        TreeTableNode treeTableNode = (TreeTableNode)object;
        return treeTableNode;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return class$edu$uoregon$tau$paraprof$treetable$TreeTableModel == null ? (class$edu$uoregon$tau$paraprof$treetable$TreeTableModel = CallPathModel.class$("edu.uoregon.tau.paraprof.treetable.TreeTableModel")) : class$edu$uoregon$tau$paraprof$treetable$TreeTableModel;
        }
        return this.window.getColumns().get(n - 1).getClass();
    }

    public int getChildCount(Object object) {
        if (object == this.root) {
            return this.roots.size();
        }
        if (this.window.getTreeMode()) {
            TreeTableNode treeTableNode = (TreeTableNode)object;
            return treeTableNode.getNumChildren();
        }
        return 0;
    }

    public Object getChild(Object object, int n) {
        if (object == this.root) {
            return this.roots.get(n);
        }
        TreeTableNode treeTableNode = (TreeTableNode)object;
        return treeTableNode.getChildren().get(n);
    }

    public Thread getThread() {
        return this.thread;
    }

    public double[] getMaxValues() {
        return this.maxValues;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public boolean getSortAscending() {
        return this.sortAscending;
    }

    public void sortColumn(int n, boolean bl) {
        super.sortColumn(n, bl);
        this.sortColumn = n;
        this.sortAscending = bl;
        Collections.sort(this.roots);
        Iterator iterator = this.roots.iterator();
        while (iterator.hasNext()) {
            TreeTableNode treeTableNode = (TreeTableNode)iterator.next();
            treeTableNode.sortChildren();
        }
    }

    public TreeTableWindow getWindow() {
        return this.window;
    }

    public ParaProfTrial getPPTrial() {
        return this.ppTrial;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

