/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.paraprof.FunctionSelectorDialog;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.ThreeDeeSettings;
import edu.uoregon.tau.paraprof.ThreeDeeWindow;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.enums.VisType;
import edu.uoregon.tau.paraprof.vis.Plot;
import edu.uoregon.tau.paraprof.vis.VisRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ThreeDeeControlPanel
extends JPanel
implements ActionListener {
    private ThreeDeeSettings settings;
    private ThreeDeeWindow window;
    private ParaProfTrial ppTrial;
    private JComboBox heightValueBox;
    private JComboBox heightMetricBox;
    private JComboBox colorValueBox;
    private JComboBox colorMetricBox;
    private JPanel subPanel;
    private VisRenderer visRenderer;
    private JTextField heightValueField = new JTextField("");
    private JTextField colorValueField = new JTextField("");
    private int selectedTab;
    private JTabbedPane tabbedPane;

    public ThreeDeeControlPanel(ThreeDeeWindow threeDeeWindow, ThreeDeeSettings threeDeeSettings, ParaProfTrial paraProfTrial, VisRenderer visRenderer) {
        this.settings = threeDeeSettings;
        this.window = threeDeeWindow;
        this.ppTrial = paraProfTrial;
        this.visRenderer = visRenderer;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(VisType.TRIANGLE_MESH_PLOT.toString(), threeDeeSettings.getVisType() == VisType.TRIANGLE_MESH_PLOT);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        this.addCompItem(this, jRadioButton, gridBagConstraints, 0, 0, 1, 1);
        jRadioButton = new JRadioButton(VisType.BAR_PLOT.toString(), threeDeeSettings.getVisType() == VisType.BAR_PLOT);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        this.addCompItem(this, jRadioButton, gridBagConstraints, 0, 2, 1, 1);
        jRadioButton = new JRadioButton(VisType.SCATTER_PLOT.toString(), threeDeeSettings.getVisType() == VisType.SCATTER_PLOT);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        this.addCompItem(this, jRadioButton, gridBagConstraints, 0, 3, 1, 1);
        this.createSubPanel();
    }

    private void createSubPanel() {
        if (this.subPanel != null) {
            this.remove(this.subPanel);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.subPanel = this.settings.getVisType() == VisType.SCATTER_PLOT ? this.createScatterPanel() : this.createFullDataPanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this, this.subPanel, gridBagConstraints, 0, 5, 1, 1);
        this.revalidate();
        this.validate();
        this.setPreferredSize(this.getMinimumSize());
    }

    private JPanel createScatterSelectionPanel(String string, final int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        String string2 = "   <none>";
        if (this.settings.getScatterFunctions()[n] != null) {
            string2 = this.settings.getScatterFunctions()[n].getName();
        }
        final JTextField jTextField = new JTextField(string2);
        jTextField.setEditable(false);
        jTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        jTextField.setCaretPosition(0);
        String[] stringArray = new String[this.ppTrial.getNumberOfMetrics()];
        for (int i = 0; i < this.ppTrial.getNumberOfMetrics(); ++i) {
            stringArray[i] = this.ppTrial.getMetric(i).getName();
        }
        final JComboBox<ValueType> jComboBox = new JComboBox<ValueType>(ValueType.VALUES);
        final JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem(this.settings.getScatterValueTypes()[n]);
        jComboBox2.setSelectedIndex(this.settings.getScatterMetricIDs()[n]);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ThreeDeeControlPanel.this.settings.setScatterValueType((ValueType)jComboBox.getSelectedItem(), n);
                    ThreeDeeControlPanel.this.settings.setScatterMetricID(jComboBox2.getSelectedIndex(), n);
                    ThreeDeeControlPanel.this.window.redraw();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        jComboBox.addActionListener(actionListener);
        jComboBox2.addActionListener(actionListener);
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FunctionSelectorDialog functionSelectorDialog = new FunctionSelectorDialog(ThreeDeeControlPanel.this.window, true, ThreeDeeControlPanel.this.ppTrial.getDisplayedFunctions().iterator(), ThreeDeeControlPanel.this.settings.getScatterFunctions()[n], true);
                    if (functionSelectorDialog.choose()) {
                        Function function = (Function)functionSelectorDialog.getSelectedObject();
                        ThreeDeeControlPanel.this.settings.setScatterFunction(function, n);
                        String string = "   <none>";
                        if (ThreeDeeControlPanel.this.settings.getScatterFunctions()[n] != null) {
                            string = ParaProfUtils.getFunctionName(ThreeDeeControlPanel.this.settings.getScatterFunctions()[n]);
                        }
                        jTextField.setText(string);
                        ThreeDeeControlPanel.this.window.redraw();
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel2, jTextField, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.addCompItem(jPanel2, jButton, gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel, jPanel2, gridBagConstraints, 1, 0, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, jComboBox, gridBagConstraints, 1, 1, 1, 1);
        this.addCompItem(jPanel, jComboBox2, gridBagConstraints, 2, 1, 1, 1);
        return jPanel;
    }

    private JPanel createScatterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.addCompItem(jPanel, new JLabel("Width"), gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel, this.createScatterSelectionPanel("Width", 0), gridBagConstraints, 1, 0, 1, 1);
        this.addCompItem(jPanel, new JLabel("Depth"), gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel, this.createScatterSelectionPanel("Depth", 1), gridBagConstraints, 1, 1, 1, 1);
        this.addCompItem(jPanel, new JLabel("Height"), gridBagConstraints, 0, 2, 1, 1);
        this.addCompItem(jPanel, this.createScatterSelectionPanel("Height", 2), gridBagConstraints, 1, 2, 1, 1);
        this.addCompItem(jPanel, new JLabel("Color"), gridBagConstraints, 0, 3, 1, 1);
        this.addCompItem(jPanel, this.createScatterSelectionPanel("Color", 3), gridBagConstraints, 1, 3, 1, 1);
        this.tabbedPane = new JTabbedPane();
        Plot plot = this.window.getPlot();
        this.tabbedPane.addTab(plot.getName(), plot.getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Axes", plot.getAxes().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("ColorScale", this.window.getColorScale().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Render", this.visRenderer.getControlPanel());
        this.tabbedPane.setMinimumSize(new Dimension(300, 160));
        this.tabbedPane.setSelectedIndex(this.selectedTab);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, this.tabbedPane, gridBagConstraints, 0, 4, 2, 1);
        return jPanel;
    }

    private JPanel createSelectorPanel(int n, int n2, final List list, final int n3) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        final JScrollBar jScrollBar = new JScrollBar(0, this.settings.getSelections()[n3], 1, n, n2);
        jScrollBar.setBlockIncrement((n2 - n) / 10);
        final JTextField jTextField = new JTextField("<none>");
        jTextField.setHorizontalAlignment(0);
        if (this.settings.getSelections()[n3] >= 0 && list != null) {
            jTextField.setText((String)list.get(this.settings.getSelections()[n3]));
        }
        jTextField.setEditable(false);
        jTextField.setCaretPosition(0);
        jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                int n = jScrollBar.getValue();
                ThreeDeeControlPanel.this.settings.setSelection(n3, n);
                if (n >= 0 && list != null) {
                    jTextField.setText((String)list.get(n));
                } else {
                    jTextField.setText("<none>");
                }
                jTextField.setCaretPosition(0);
                ThreeDeeControlPanel.this.heightValueField.setText(ThreeDeeControlPanel.this.window.getSelectedHeightValue());
                ThreeDeeControlPanel.this.colorValueField.setText(ThreeDeeControlPanel.this.window.getSelectedColorValue());
                ThreeDeeControlPanel.this.window.redraw();
            }
        });
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        ParaProfUtils.addCompItem(jPanel, jTextField, gridBagConstraints, 1, 0, 1, 1);
        ParaProfUtils.addCompItem(jPanel, jScrollBar, gridBagConstraints, 1, 1, 1, 1);
        return jPanel;
    }

    private JPanel createFullDataPanel() {
        int n;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Plot plot = ThreeDeeControlPanel.this.window.getPlot();
                    ThreeDeeControlPanel.this.settings.setHeightMetricID(ThreeDeeControlPanel.this.heightMetricBox.getSelectedIndex());
                    ThreeDeeControlPanel.this.settings.setColorMetricID(ThreeDeeControlPanel.this.colorMetricBox.getSelectedIndex());
                    ThreeDeeControlPanel.this.settings.setHeightValue((ValueType)ThreeDeeControlPanel.this.heightValueBox.getSelectedItem());
                    ThreeDeeControlPanel.this.settings.setColorValue((ValueType)ThreeDeeControlPanel.this.colorValueBox.getSelectedItem());
                    ThreeDeeControlPanel.this.settings.setSize((int)plot.getWidth(), (int)plot.getDepth(), (int)plot.getHeight());
                    ThreeDeeControlPanel.this.settings.setRegularAim(ThreeDeeControlPanel.this.visRenderer.getAim());
                    ThreeDeeControlPanel.this.settings.setRegularEye(ThreeDeeControlPanel.this.visRenderer.getEye());
                    ThreeDeeControlPanel.this.heightValueField.setText(ThreeDeeControlPanel.this.window.getSelectedHeightValue());
                    ThreeDeeControlPanel.this.colorValueField.setText(ThreeDeeControlPanel.this.window.getSelectedColorValue());
                    ThreeDeeControlPanel.this.window.redraw();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        String[] stringArray = new String[this.ppTrial.getNumberOfMetrics()];
        for (n = 0; n < this.ppTrial.getNumberOfMetrics(); ++n) {
            stringArray[n] = this.ppTrial.getMetric(n).getName();
        }
        this.heightValueBox = new JComboBox<ValueType>(ValueType.VALUES);
        this.heightValueBox.setSelectedItem(this.settings.getHeightValue());
        this.heightValueBox.addActionListener(actionListener);
        this.heightMetricBox = new JComboBox<String>(stringArray);
        this.heightMetricBox.setSelectedIndex(this.settings.getHeightMetricID());
        this.heightMetricBox.addActionListener(actionListener);
        this.colorValueBox = new JComboBox<ValueType>(ValueType.VALUES);
        this.colorValueBox.setSelectedItem(this.settings.getColorValue());
        this.colorValueBox.addActionListener(actionListener);
        stringArray = new String[this.ppTrial.getNumberOfMetrics()];
        for (n = 0; n < this.ppTrial.getNumberOfMetrics(); ++n) {
            stringArray[n] = this.ppTrial.getMetric(n).getName();
        }
        this.colorMetricBox = new JComboBox<String>(stringArray);
        this.colorMetricBox.setSelectedIndex(this.settings.getColorMetricID());
        this.colorMetricBox.addActionListener(actionListener);
        this.tabbedPane = new JTabbedPane();
        Plot plot = this.window.getPlot();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.addTab(plot.getName(), plot.getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Axes", plot.getAxes().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("ColorScale", this.window.getColorScale().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Render", this.visRenderer.getControlPanel());
        this.tabbedPane.setMinimumSize(new Dimension(290, 160));
        this.tabbedPane.setSelectedIndex(this.selectedTab);
        JPanel jPanel2 = this.createSelectorPanel(-1, this.window.getFunctionNames().size(), this.window.getFunctionNames(), 0);
        JPanel jPanel3 = this.createSelectorPanel(0, this.ppTrial.getDataSource().getNumThreads(), this.window.getThreadNames(), 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jPanel, new JLabel("Height Metric"), gridBagConstraints, 0, 0, 2, 1);
        this.addCompItem(jPanel, this.heightValueBox, gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel, this.heightMetricBox, gridBagConstraints, 1, 1, 1, 1);
        this.addCompItem(jPanel, new JLabel("Color Metric"), gridBagConstraints, 0, 2, 2, 1);
        this.addCompItem(jPanel, this.colorValueBox, gridBagConstraints, 0, 3, 1, 1);
        this.addCompItem(jPanel, this.colorMetricBox, gridBagConstraints, 1, 3, 1, 1);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        this.heightValueField.setEditable(false);
        this.colorValueField.setEditable(false);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel4, new JLabel("Function"), gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel4, new JLabel("Thread"), gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel4, new JLabel("Height value"), gridBagConstraints, 0, 2, 1, 1);
        this.addCompItem(jPanel4, new JLabel("Color value"), gridBagConstraints, 0, 3, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.addCompItem(jPanel4, jPanel2, gridBagConstraints, 1, 0, 1, 1);
        this.addCompItem(jPanel4, jPanel3, gridBagConstraints, 1, 1, 1, 1);
        this.addCompItem(jPanel4, this.heightValueField, gridBagConstraints, 1, 2, 1, 1);
        this.addCompItem(jPanel4, this.colorValueField, gridBagConstraints, 1, 3, 1, 1);
        this.addCompItem(jPanel, jPanel4, gridBagConstraints, 0, 4, 2, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, this.tabbedPane, gridBagConstraints, 0, 5, 2, 1);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JRadioButton) {
                this.selectedTab = this.tabbedPane.getSelectedIndex();
                String string = actionEvent.getActionCommand();
                Plot plot = this.window.getPlot();
                if (this.settings.getVisType() == VisType.BAR_PLOT || this.settings.getVisType() == VisType.TRIANGLE_MESH_PLOT) {
                    this.settings.setSize((int)plot.getWidth(), (int)plot.getDepth(), (int)plot.getHeight());
                    this.settings.setRegularAim(this.visRenderer.getAim());
                    this.settings.setRegularEye(this.visRenderer.getEye());
                } else if (this.settings.getVisType() == VisType.SCATTER_PLOT) {
                    this.settings.setScatterAim(this.visRenderer.getAim());
                    this.settings.setScatterEye(this.visRenderer.getEye());
                }
                if (string.equals(VisType.BAR_PLOT.toString())) {
                    this.settings.setVisType(VisType.BAR_PLOT);
                } else if (string.equals(VisType.TRIANGLE_MESH_PLOT.toString())) {
                    this.settings.setVisType(VisType.TRIANGLE_MESH_PLOT);
                } else if (string.equals(VisType.SCATTER_PLOT.toString())) {
                    this.settings.setVisType(VisType.SCATTER_PLOT);
                }
                this.window.redraw();
                this.createSubPanel();
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void dataChanged() {
        this.window.redraw();
        this.createSubPanel();
        this.heightValueField.setText(this.window.getSelectedHeightValue());
        this.colorValueField.setText(this.window.getSelectedColorValue());
    }

    private void addCompItem(JPanel jPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }
}

