/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.DatabaseAPI;
import edu.uoregon.tau.dms.dss.FileList;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.Trial;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.paraprof.ColorChooser;
import edu.uoregon.tau.paraprof.FullDataWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTreeNodeUserObject;
import edu.uoregon.tau.paraprof.PreferencesWindow;
import edu.uoregon.tau.paraprof.SystemEvents;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ParaProfTrial
implements ParaProfTreeNodeUserObject {
    private Function highlightedFunction = null;
    private Group highlightedGroup = null;
    private UserEvent highlightedUserEvent = null;
    private DatabaseAPI dbAPI;
    private ParaProfExperiment experiment = null;
    private DefaultMutableTreeNode defaultMutableTreeNode = null;
    private TreePath treePath = null;
    private boolean dBTrial = false;
    private boolean upload = false;
    private boolean loading = false;
    private SystemEvents systemEvents = new SystemEvents();
    private FullDataWindow fullDataWindow = null;
    private ColorChooser clrChooser = ParaProf.colorChooser;
    private PreferencesWindow preferencesWindow = ParaProf.preferencesWindow;
    private String path = null;
    private String pathReverse = null;
    private int defaultMetricID = 0;
    private Vector observers = new Vector();
    private Trial trial;
    private Group selectedGroup;
    private int groupFilter = 0;

    public ParaProfTrial() {
        this.trial = new Trial();
        this.trial.setID(-1);
        this.trial.setExperimentID(-1);
        this.trial.setApplicationID(-1);
        this.trial.setName("");
    }

    public ParaProfTrial(Trial trial) {
        this.trial = new Trial(trial);
    }

    public Trial getTrial() {
        return this.trial;
    }

    public int getApplicationID() {
        return this.trial.getApplicationID();
    }

    public int getExperimentID() {
        return this.trial.getExperimentID();
    }

    public int getID() {
        return this.trial.getID();
    }

    public void setApplicationID(int n) {
        this.trial.setApplicationID(n);
    }

    public void setExperimentID(int n) {
        this.trial.setExperimentID(n);
    }

    public void setID(int n) {
        this.trial.setID(n);
    }

    public String getName() {
        return this.trial.getName();
    }

    public DataSource getDataSource() {
        return this.trial.getDataSource();
    }

    public void setExperiment(ParaProfExperiment paraProfExperiment) {
        this.experiment = paraProfExperiment;
    }

    public ParaProfExperiment getExperiment() {
        return this.experiment;
    }

    public void setDMTN(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.defaultMutableTreeNode = defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDMTN() {
        return this.defaultMutableTreeNode;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public void setDBTrial(boolean bl) {
        this.dBTrial = bl;
    }

    public boolean dBTrial() {
        return this.dBTrial;
    }

    public void setUpload(boolean bl) {
        this.upload = bl;
    }

    public boolean upload() {
        return this.upload;
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }

    public boolean loading() {
        return this.loading;
    }

    public String getIDString() {
        if (this.experiment != null) {
            return this.experiment.getIDString() + ":" + this.trial.getID();
        }
        return ":" + this.trial.getID();
    }

    public ColorChooser getColorChooser() {
        return this.clrChooser;
    }

    public PreferencesWindow getPreferencesWindow() {
        return this.preferencesWindow;
    }

    public String getTrialIdentifier(boolean bl) {
        if (this.path != null) {
            if (bl) {
                return this.pathReverse;
            }
            return this.path;
        }
        return "Application " + this.trial.getApplicationID() + ", Experiment " + this.trial.getExperimentID() + ", Trial " + this.trial.getID() + ".";
    }

    public void setPaths(String string) {
        this.path = string;
        this.pathReverse = FileList.getPathReverse((String)string);
    }

    public String getPath() {
        return this.path;
    }

    public String getPathReverse() {
        return this.pathReverse;
    }

    public String toString() {
        if (this.loading()) {
            return this.trial.getName() + " (Loading...)";
        }
        return this.trial.getName();
    }

    public void clearDefaultMutableTreeNodes() {
        this.setDMTN(null);
    }

    public FullDataWindow getFullDataWindow() {
        return this.fullDataWindow;
    }

    public void showMainWindow() {
        if (this.fullDataWindow == null) {
            this.fullDataWindow = new FullDataWindow(this);
            ParaProf.incrementNumWindows();
            this.fullDataWindow.setVisible(true);
        } else {
            ParaProf.incrementNumWindows();
            this.fullDataWindow.setVisible(true);
        }
    }

    public void closeStaticMainWindow() {
        if (this.fullDataWindow != null) {
            this.getSystemEvents().deleteObserver(this.fullDataWindow);
            this.fullDataWindow.setVisible(false);
        }
    }

    public SystemEvents getSystemEvents() {
        return this.systemEvents;
    }

    public void setDefaultMetricID(int n) {
        this.defaultMetricID = n;
    }

    public int getDefaultMetricID() {
        return this.defaultMetricID;
    }

    public boolean isTimeMetric() {
        String string = this.getMetricName(this.getDefaultMetricID());
        return (string = string.toUpperCase()).indexOf("TIME") != -1;
    }

    public boolean isDerivedMetric() {
        return this.getMetric(this.getDefaultMetricID()).getDerivedMetric();
    }

    public List getMetrics() {
        return this.trial.getDataSource().getMetrics();
    }

    public int getNumberOfMetrics() {
        return this.trial.getDataSource().getNumberOfMetrics();
    }

    public ParaProfMetric getMetric(int n) {
        return (ParaProfMetric)this.trial.getDataSource().getMetric(n);
    }

    public String getMetricName(int n) {
        return this.trial.getDataSource().getMetricName(n);
    }

    public ParaProfMetric addMetric() {
        ParaProfMetric paraProfMetric = new ParaProfMetric();
        this.trial.getDataSource().addMetric((Metric)paraProfMetric);
        return paraProfMetric;
    }

    public boolean groupNamesPresent() {
        return this.trial.getDataSource().getGroupNamesPresent();
    }

    public boolean userEventsPresent() {
        return this.trial.getDataSource().getUserEventsPresent();
    }

    public boolean callPathDataPresent() {
        return this.trial.getDataSource().getCallPathDataPresent();
    }

    public int[] getMaxNCTNumbers() {
        return this.trial.getDataSource().getMaxNCTNumbers();
    }

    public void setMeanData(int n) {
        this.trial.getDataSource().generateStatistics(n, n);
    }

    public List getDisplayedFunctions() {
        ArrayList<Function> arrayList = new ArrayList<Function>();
        Iterator iterator = this.getDataSource().getFunctions();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            if (!this.displayFunction(function)) continue;
            arrayList.add(function);
        }
        return arrayList;
    }

    public boolean displayFunction(Function function) {
        switch (this.groupFilter) {
            case 0: {
                return true;
            }
            case 1: {
                return function.isGroupMember(this.selectedGroup);
            }
            case 2: {
                return !function.isGroupMember(this.selectedGroup);
            }
        }
        return true;
    }

    public void setSelectedGroup(Group group) {
        this.selectedGroup = group;
    }

    public Group getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setGroupFilter(int n) {
        this.groupFilter = n;
    }

    public int getGroupFilter() {
        return this.groupFilter;
    }

    public void finishLoad() {
        ParaProfMetric paraProfMetric;
        int n;
        int n2 = this.trial.getDataSource().getNumberOfMetrics();
        Vector<ParaProfMetric> vector = new Vector<ParaProfMetric>();
        for (n = 0; n < n2; ++n) {
            paraProfMetric = new ParaProfMetric();
            paraProfMetric.setName(this.trial.getDataSource().getMetricName(n));
            paraProfMetric.setID(n);
            paraProfMetric.setPpTrial(this);
            vector.add(paraProfMetric);
        }
        this.trial.getDataSource().setMetrics(vector);
        for (n = 0; n < n2; ++n) {
            paraProfMetric = (ParaProfMetric)this.trial.getDataSource().getMetric(n);
            if (!paraProfMetric.isTimeMetric()) continue;
            this.setDefaultMetricID(n);
            break;
        }
        for (n = 0; n < n2; ++n) {
            paraProfMetric = (ParaProfMetric)this.trial.getDataSource().getMetric(n);
            if (!paraProfMetric.getName().equalsIgnoreCase("Time")) continue;
            this.setDefaultMetricID(n);
            break;
        }
        this.clrChooser.setColors(this, -1);
        this.setLoading(false);
    }

    public DatabaseAPI getDatabaseAPI() {
        return this.dbAPI;
    }

    public void setDatabaseAPI(DatabaseAPI databaseAPI) {
        this.dbAPI = databaseAPI;
    }

    public void setHighlightedFunction(Function function) {
        this.highlightedFunction = function;
        this.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public Function getHighlightedFunction() {
        return this.highlightedFunction;
    }

    public void toggleHighlightedFunction(Function function) {
        this.highlightedFunction = this.highlightedFunction == function ? null : function;
        this.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public void setHighlightedGroup(Group group) {
        this.highlightedGroup = group;
        this.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public Group getHighlightedGroup() {
        return this.highlightedGroup;
    }

    public void toggleHighlightedGroup(Group group) {
        this.highlightedGroup = this.highlightedGroup == group ? null : group;
        this.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public void setHighlightedUserEvent(UserEvent userEvent) {
        this.highlightedUserEvent = userEvent;
        this.getSystemEvents().updateRegisteredObjects("colorEvent");
    }

    public UserEvent getHighlightedUserEvent() {
        return this.highlightedUserEvent;
    }

    public void toggleHighlightedUserEvent(UserEvent userEvent) {
        this.highlightedUserEvent = this.highlightedUserEvent == userEvent ? null : userEvent;
        this.getSystemEvents().updateRegisteredObjects("colorEvent");
    }
}

