/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.GlobalMapping;
import jRacy.GlobalMappingElement;
import jRacy.GlobalThreadDataElement;
import jRacy.SMWThreadDataElement;
import jRacy.TotalStatUEWindow;
import jRacy.Trial;
import jRacy.UserEventWindow;
import jRacy.jRacy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class TotalStatUEWindowPanel
extends JPanel
implements ActionListener,
MouseListener {
    int xPanelSize = 800;
    int yPanelSize = 600;
    int newXPanelSize = 0;
    int newYPanelSize = 0;
    int startLocation = 0;
    int maxFontAscent = 0;
    int maxFontDescent = 0;
    int spacing = 0;
    int serverNumber;
    int contextNumber;
    int threadNumber;
    private Trial trial = null;
    TotalStatUEWindow tSUEWindow;
    Vector tmpThreadDataElementList;
    SMWThreadDataElement tmpSMWThreadDataElement;
    Font MonoFont = null;
    FontMetrics fmMonoFont = null;
    private JPopupMenu popup = new JPopupMenu();
    Object clickedOnObject = null;

    public TotalStatUEWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSUEWP01");
        }
    }

    public TotalStatUEWindowPanel(Trial trial, int n, int n2, int n3, TotalStatUEWindow totalStatUEWindow) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.serverNumber = n;
            this.contextNumber = n2;
            this.threadNumber = n3;
            this.trial = trial;
            this.tSUEWindow = totalStatUEWindow;
            this.addMouseListener(this);
            JMenuItem jMenuItem = new JMenuItem("Show User Event Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Change User Event Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Reset to Generic Color");
            jMenuItem3.addActionListener(this);
            this.popup.add(jMenuItem3);
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSUEWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            int n = 0;
            int n2 = this.trial.getPreferences().getBarHeight();
            this.spacing = this.trial.getPreferences().getBarSpacing();
            int n3 = 0;
            String string = null;
            String string2 = "";
            this.MonoFont = new Font("Monospaced", this.trial.getPreferences().getFontStyle(), n2);
            this.fmMonoFont = graphics.getFontMetrics(this.MonoFont);
            this.maxFontAscent = this.fmMonoFont.getMaxAscent();
            this.maxFontDescent = this.fmMonoFont.getMaxDescent();
            graphics.setFont(this.MonoFont);
            if (this.spacing <= this.maxFontAscent + this.maxFontDescent) {
                ++this.spacing;
            }
            this.tmpThreadDataElementList = this.tSUEWindow.getStaticMainWindowSystemData();
            if (this.tmpThreadDataElementList.size() == 0) {
                return;
            }
            Rectangle rectangle = graphics.getClipBounds();
            int n4 = (int)rectangle.getY();
            int n5 = (int)((double)n4 + rectangle.getHeight());
            int n6 = 0;
            int n7 = 0;
            n += this.spacing;
            String string3 = this.trial.getCounterName();
            if (string3 != null) {
                graphics.drawString("COUNTER NAME: " + string3, 5, n);
                n += this.spacing;
            }
            if (rectangle != null) {
                string = GlobalThreadDataElement.getUserEventStatStringHeading();
                int n8 = string.length();
                int n9 = 0;
                while (n9 < n8) {
                    string2 = string2 + "-";
                    ++n9;
                }
                graphics.setColor(Color.black);
                AttributedString attributedString = new AttributedString(string2);
                attributedString.addAttribute(TextAttribute.FONT, this.MonoFont);
                graphics.drawString(attributedString.getIterator(), 20, n += this.spacing);
                n = n + this.spacing + 10;
                AttributedString attributedString2 = new AttributedString(string);
                attributedString2.addAttribute(TextAttribute.FONT, this.MonoFont);
                graphics.drawString(attributedString2.getIterator(), 20, n);
                n = n + this.spacing + 10;
                graphics.drawString(attributedString.getIterator(), 20, n);
                this.startLocation = n;
                this.newYPanelSize = n + (this.tmpThreadDataElementList.size() + 1) * this.spacing;
                n6 = (n4 - n) / this.spacing - 1;
                n7 = (n5 - n) / this.spacing + 1;
                if (n > n4 || n > n5) {
                    if (n > n4) {
                        n6 = 0;
                    }
                    if (n > n5) {
                        n7 = 0;
                    }
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                if (n6 > this.tmpThreadDataElementList.size() - 1) {
                    n6 = this.tmpThreadDataElementList.size() - 1;
                }
                if (n7 > this.tmpThreadDataElementList.size() - 1) {
                    n7 = this.tmpThreadDataElementList.size() - 1;
                }
                n += n6 * this.spacing;
                int n10 = n6;
                while (n10 <= n7) {
                    this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n10);
                    string = this.tmpSMWThreadDataElement.getUserEventStatString();
                    n += this.spacing;
                    graphics.setColor(Color.black);
                    AttributedString attributedString3 = new AttributedString(string);
                    attributedString3.addAttribute(TextAttribute.FONT, this.MonoFont);
                    if (this.tmpSMWThreadDataElement.getUserEventID() == this.trial.getColorChooser().getUEHCMappingID()) {
                        attributedString3.addAttribute(TextAttribute.FOREGROUND, this.trial.getColorChooser().getUEHC(), GlobalThreadDataElement.getPositionOfUserEventName(), string.length());
                    } else {
                        attributedString3.addAttribute(TextAttribute.FOREGROUND, this.tmpSMWThreadDataElement.getUserEventMappingColor(), GlobalThreadDataElement.getPositionOfUserEventName(), string.length());
                    }
                    graphics.drawString(attributedString3.getIterator(), 20, n);
                    if (n3 < 2 * this.fmMonoFont.stringWidth(string)) {
                        n3 = 20 + 2 * this.fmMonoFont.stringWidth(string);
                    }
                    ++n10;
                }
                if (this.newYPanelSize >= this.yPanelSize || n3 >= this.xPanelSize) {
                    this.yPanelSize = this.newYPanelSize + 1;
                    this.xPanelSize = n3 + 1;
                    this.revalidate();
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSUEWP03");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            SMWThreadDataElement sMWThreadDataElement = null;
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show User Event Details")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        this.trial.getColorChooser().setUEHCMappingID(sMWThreadDataElement.getMappingID());
                        UserEventWindow userEventWindow = new UserEventWindow(this.trial, sMWThreadDataElement.getMappingID(), this.trial.getStaticMainWindow().getSMWData());
                        this.trial.getSystemEvents().addObserver(userEventWindow);
                        userEventWindow.show();
                    }
                } else if (string.equals("Change User Event Color")) {
                    int n = -1;
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        n = ((SMWThreadDataElement)this.clickedOnObject).getMappingID();
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 2);
                    Color color = globalMappingElement.getMappingColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        globalMappingElement.setSpecificColor(color);
                        globalMappingElement.setColorFlag(true);
                        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    int n = -1;
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        n = ((SMWThreadDataElement)this.clickedOnObject).getMappingID();
                    }
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 2);
                    globalMappingElement.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSUEWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.trial.getPreferences().getBarHeight();
            int n4 = mouseEvent.getClickCount();
            int n5 = n2 - this.startLocation;
            int n6 = n5 / this.spacing;
            int n7 = (n6 + 1) * this.spacing;
            int n8 = n7 - this.maxFontAscent;
            if (n5 >= n8 && n5 <= n7 && n6 < this.tmpThreadDataElementList.size()) {
                String string;
                int n9;
                this.tmpSMWThreadDataElement = (SMWThreadDataElement)this.tmpThreadDataElementList.elementAt(n6);
                if (this.fmMonoFont != null && n <= (n9 = this.fmMonoFont.stringWidth(string = this.tmpSMWThreadDataElement.getUserEventStatString()) + 20)) {
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        this.clickedOnObject = this.tmpSMWThreadDataElement;
                        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                    } else if (this.trial.getColorChooser().getUEHCMappingID() == -1) {
                        this.trial.getColorChooser().setUEHCMappingID(this.tmpSMWThreadDataElement.getMappingID());
                    } else if (this.trial.getColorChooser().getUEHCMappingID() != this.tmpSMWThreadDataElement.getMappingID()) {
                        this.trial.getColorChooser().setUEHCMappingID(this.tmpSMWThreadDataElement.getMappingID());
                    } else {
                        this.trial.getColorChooser().setUEHCMappingID(-1);
                    }
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TSUEWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }
}

