/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.MeanDataWindowPanel;
import jRacy.StaticMainWindowData;
import jRacy.Trial;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MeanDataWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener {
    private JMenu unitsMenu;
    private JMenu valuePercentMenu;
    private JMenuItem mappingGroupLedgerItem;
    private JMenuItem userEventLedgerItem;
    private ButtonGroup sortGroup;
    private ButtonGroup sortOrderGroup;
    private ButtonGroup metricGroup = null;
    private ButtonGroup valuePercentGroup;
    private ButtonGroup unitsGroup;
    private JRadioButtonMenuItem ascendingButton = new JRadioButtonMenuItem("Ascending", false);
    private JRadioButtonMenuItem descendingButton = new JRadioButtonMenuItem("Descending", true);
    private JRadioButtonMenuItem nameButton = new JRadioButtonMenuItem("name", false);
    private JRadioButtonMenuItem millisecondButton = new JRadioButtonMenuItem("Selected Metric", true);
    private JRadioButtonMenuItem inclusiveRadioButton = new JRadioButtonMenuItem("Inclusive", false);
    private JRadioButtonMenuItem exclusiveRadioButton = new JRadioButtonMenuItem("Exclusive", true);
    private JRadioButtonMenuItem numOfCallsRadioButton = new JRadioButtonMenuItem("Number of Calls", false);
    private JRadioButtonMenuItem numOfSubRoutinesRadioButton = new JRadioButtonMenuItem("Number of Subroutines", false);
    private JRadioButtonMenuItem userSecPerCallRadioButton = new JRadioButtonMenuItem("Per Call Value", false);
    private JRadioButtonMenuItem valueButton;
    private JRadioButtonMenuItem percentButton;
    private JRadioButtonMenuItem secondsButton;
    private JRadioButtonMenuItem millisecondsButton;
    private JRadioButtonMenuItem microsecondsButton;
    private JRadioButtonMenuItem showZeroMappingsItem;
    private JRadioButtonMenuItem displaySlidersButton;
    private JLabel sliderMultipleLabel = new JLabel("Slider Mulitiple");
    private JComboBox sliderMultiple;
    private JLabel barLengthLabel = new JLabel("Bar Mulitiple");
    private JSlider barLengthSlider = new JSlider(0, 40, 1);
    private Container contentPane = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;
    private JScrollPane meanDataWindowPanelScrollPane;
    private MeanDataWindowPanel meanDataWindowPanelRef;
    private Trial trial = null;
    private StaticMainWindowData sMWData = null;
    Vector currentSMWMeanData = null;
    private String metric = "Exclusive";
    private boolean sortByMappingID = false;
    private boolean sortByName = false;
    private boolean sortByMillisecond = true;
    private boolean descendingOrder = true;
    private boolean inclusive;
    private boolean percent;
    private String unitsString;

    public MeanDataWindow() {
        try {
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(700, 450));
            this.setTitle("Wrong constructor used!");
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW01");
        }
    }

    public MeanDataWindow(Trial trial, StaticMainWindowData staticMainWindowData) {
        try {
            this.trial = trial;
            this.sMWData = staticMainWindowData;
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(700, 450));
            this.currentSMWMeanData = null;
            this.inclusive = false;
            this.percent = true;
            this.unitsString = "milliseconds";
            this.setTitle("Mean Data Window: " + this.trial.getProfilePathName());
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MeanDataWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (jRacy.helpWindow.isVisible()) {
                jRacy.helpWindow.clearText();
                jRacy.helpWindow.writeText("This is the mean data window");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("This window shows you the mean values for all mappings.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Right click on any mapping within this window to bring up a popup");
                jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                jRacy.helpWindow.writeText("for the mapping, or to show more details about the mapping.");
                jRacy.helpWindow.writeText("You can also left click any mapping to hightlight it in the system.");
            }
            this.sortLocalData();
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit Racy!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Options");
            jMenu2.addMenuListener(this);
            JMenu jMenu3 = new JMenu("Sort by ...");
            this.sortGroup = new ButtonGroup();
            this.nameButton.addActionListener(this);
            this.millisecondButton.addActionListener(this);
            this.sortGroup.add(this.nameButton);
            this.sortGroup.add(this.millisecondButton);
            jMenu3.add(this.nameButton);
            jMenu3.add(this.millisecondButton);
            this.sortOrderGroup = new ButtonGroup();
            this.ascendingButton.addActionListener(this);
            this.descendingButton.addActionListener(this);
            this.sortOrderGroup.add(this.ascendingButton);
            this.sortOrderGroup.add(this.descendingButton);
            jMenu3.add(this.ascendingButton);
            jMenu3.add(this.descendingButton);
            jMenu3.insertSeparator(2);
            jMenu2.add(jMenu3);
            JMenu jMenu4 = new JMenu("Select Metric");
            this.metricGroup = new ButtonGroup();
            this.inclusiveRadioButton.addActionListener(this);
            this.exclusiveRadioButton.addActionListener(this);
            this.numOfCallsRadioButton.addActionListener(this);
            this.numOfSubRoutinesRadioButton.addActionListener(this);
            this.userSecPerCallRadioButton.addActionListener(this);
            this.metricGroup.add(this.inclusiveRadioButton);
            this.metricGroup.add(this.exclusiveRadioButton);
            this.metricGroup.add(this.numOfCallsRadioButton);
            this.metricGroup.add(this.numOfSubRoutinesRadioButton);
            this.metricGroup.add(this.userSecPerCallRadioButton);
            jMenu4.add(this.inclusiveRadioButton);
            jMenu4.add(this.exclusiveRadioButton);
            jMenu4.add(this.numOfCallsRadioButton);
            jMenu4.add(this.numOfSubRoutinesRadioButton);
            jMenu4.add(this.userSecPerCallRadioButton);
            jMenu2.add(jMenu4);
            this.valuePercentMenu = new JMenu("Select Value or Percent");
            this.valuePercentGroup = new ButtonGroup();
            this.percentButton = new JRadioButtonMenuItem("Percent", true);
            this.percentButton.addActionListener(this);
            this.valueButton = new JRadioButtonMenuItem("Value", false);
            this.valueButton.addActionListener(this);
            this.valuePercentGroup.add(this.percentButton);
            this.valuePercentGroup.add(this.valueButton);
            this.valuePercentMenu.add(this.percentButton);
            this.valuePercentMenu.add(this.valueButton);
            jMenu2.add(this.valuePercentMenu);
            this.unitsMenu = new JMenu("Select Units");
            this.unitsGroup = new ButtonGroup();
            this.secondsButton = new JRadioButtonMenuItem("Seconds", false);
            this.secondsButton.addActionListener(this);
            this.millisecondsButton = new JRadioButtonMenuItem("Milliseconds", false);
            this.millisecondsButton.addActionListener(this);
            this.microsecondsButton = new JRadioButtonMenuItem("Microseconds", true);
            this.microsecondsButton.addActionListener(this);
            this.unitsGroup.add(this.secondsButton);
            this.unitsGroup.add(this.millisecondsButton);
            this.unitsGroup.add(this.microsecondsButton);
            this.unitsMenu.add(this.secondsButton);
            this.unitsMenu.add(this.millisecondsButton);
            this.unitsMenu.add(this.microsecondsButton);
            jMenu2.add(this.unitsMenu);
            this.displaySlidersButton = new JRadioButtonMenuItem("Display Sliders", false);
            this.displaySlidersButton.addActionListener(this);
            jMenu2.add(this.displaySlidersButton);
            JMenu jMenu5 = new JMenu("Windows");
            jMenu5.addMenuListener(this);
            JMenuItem jMenuItem3 = new JMenuItem("Show Function Ledger");
            jMenuItem3.addActionListener(this);
            jMenu5.add(jMenuItem3);
            this.mappingGroupLedgerItem = new JMenuItem("Show Group Ledger");
            this.mappingGroupLedgerItem.addActionListener(this);
            jMenu5.add(this.mappingGroupLedgerItem);
            this.userEventLedgerItem = new JMenuItem("Show User Event Ledger");
            this.userEventLedgerItem.addActionListener(this);
            jMenu5.add(this.userEventLedgerItem);
            JMenuItem jMenuItem4 = new JMenuItem("Close All Sub-Windows");
            jMenuItem4.addActionListener(this);
            jMenu5.add(jMenuItem4);
            JMenu jMenu6 = new JMenu("Help");
            JMenuItem jMenuItem5 = new JMenuItem("About Racy");
            jMenuItem5.addActionListener(this);
            jMenu6.add(jMenuItem5);
            JMenuItem jMenuItem6 = new JMenuItem("Show Help Window");
            jMenuItem6.addActionListener(this);
            jMenu6.add(jMenuItem6);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu5);
            jMenuBar.add(jMenu6);
            this.setJMenuBar(jMenuBar);
            this.contentPane = this.getContentPane();
            this.gbl = new GridBagLayout();
            this.contentPane.setLayout(this.gbl);
            this.gbc = new GridBagConstraints();
            this.gbc.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.meanDataWindowPanelRef = new MeanDataWindowPanel(this.trial, this, this.sMWData);
            this.meanDataWindowPanelScrollPane = new JScrollPane(this.meanDataWindowPanelRef);
            this.meanDataWindowPanelScrollPane.setBorder(border);
            this.meanDataWindowPanelScrollPane.setPreferredSize(new Dimension(500, 450));
            String[] stringArray = new String[]{"1.00", "0.75", "0.50", "0.25", "0.10"};
            this.sliderMultiple = new JComboBox<String>(stringArray);
            this.sliderMultiple.addActionListener(this);
            this.barLengthSlider.setPaintTicks(true);
            this.barLengthSlider.setMajorTickSpacing(5);
            this.barLengthSlider.setMinorTickSpacing(1);
            this.barLengthSlider.setPaintLabels(true);
            this.barLengthSlider.setSnapToTicks(true);
            this.barLengthSlider.addChangeListener(this);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.meanDataWindowPanelScrollPane, this.gbc, 0, 0, 1, 1);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit Racy!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("name")) {
                    if (this.nameButton.isSelected()) {
                        this.sortByMappingID = false;
                        this.sortByName = true;
                        this.sortByMillisecond = false;
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Selected Metric")) {
                    if (this.millisecondButton.isSelected()) {
                        this.sortByMappingID = false;
                        this.sortByName = false;
                        this.sortByMillisecond = true;
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Descending")) {
                    if (this.descendingButton.isSelected()) {
                        this.descendingOrder = true;
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Ascending")) {
                    if (this.ascendingButton.isSelected()) {
                        this.descendingOrder = false;
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Inclusive")) {
                    if (this.inclusiveRadioButton.isSelected()) {
                        this.metric = "Inclusive";
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Exclusive")) {
                    if (this.exclusiveRadioButton.isSelected()) {
                        this.metric = "Exclusive";
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Number of Calls")) {
                    if (this.numOfCallsRadioButton.isSelected()) {
                        this.metric = "Number of Calls";
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Number of Subroutines")) {
                    if (this.numOfSubRoutinesRadioButton.isSelected()) {
                        this.metric = "Number of Subroutines";
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Per Call Value")) {
                    if (this.userSecPerCallRadioButton.isSelected()) {
                        this.metric = "Per Call Value";
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Percent")) {
                    if (this.percentButton.isSelected()) {
                        this.percent = true;
                        this.sortLocalData();
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Value")) {
                    if (this.valueButton.isSelected()) {
                        this.percent = false;
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Seconds")) {
                    if (this.secondsButton.isSelected()) {
                        this.unitsString = "Seconds";
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Microseconds")) {
                    if (this.microsecondsButton.isSelected()) {
                        this.unitsString = "Microseconds";
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Milliseconds")) {
                    if (this.millisecondsButton.isSelected()) {
                        this.unitsString = "Milliseconds";
                        this.meanDataWindowPanelRef.repaint();
                    }
                } else if (string.equals("Display Sliders")) {
                    if (this.displaySlidersButton.isSelected()) {
                        this.displaySiders(true);
                    } else {
                        this.displaySiders(false);
                    }
                } else if (string.equals("Show Function Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(0);
                } else if (string.equals("Show Group Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(1);
                } else if (string.equals("Show User Event Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(2);
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, jRacy.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    jRacy.helpWindow.clearText();
                    jRacy.helpWindow.show();
                    jRacy.helpWindow.writeText("This is the mean data window");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("This window shows you the mean values for all mappings.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Right click on any mapping within this window to bring up a popup");
                    jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                    jRacy.helpWindow.writeText("for the mapping, or to show more details about the mapping.");
                    jRacy.helpWindow.writeText("You can also left click any mapping to hightlight it in the system.");
                }
            } else if (object == this.sliderMultiple) {
                this.meanDataWindowPanelRef.changeInMultiples();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW03");
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.meanDataWindowPanelRef.changeInMultiples();
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            String string = this.trial.getCounterName();
            string = string.toUpperCase();
            boolean bl = false;
            boolean bl2 = false;
            if (string.equals("DEFAULT")) {
                bl = true;
            } else if (string.indexOf("TIME") != -1) {
                bl2 = true;
            }
            if (this.trial.groupNamesPresent()) {
                this.mappingGroupLedgerItem.setEnabled(true);
            } else {
                this.mappingGroupLedgerItem.setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.userEventLedgerItem.setEnabled(true);
            } else {
                this.userEventLedgerItem.setEnabled(false);
            }
            if (this.metric.equals("Number of Calls") || this.metric.equals("Number of Subroutines") || this.metric.equals("Per Call Value")) {
                this.valuePercentMenu.setEnabled(false);
                this.unitsMenu.setEnabled(false);
            } else if (this.percent) {
                this.valuePercentMenu.setEnabled(true);
                this.unitsMenu.setEnabled(false);
            } else {
                this.valuePercentMenu.setEnabled(true);
                this.unitsMenu.setEnabled(true);
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW04");
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.meanDataWindowPanelRef.repaint();
            } else if (string.equals("colorEvent")) {
                this.meanDataWindowPanelRef.repaint();
            } else if (string.equals("dataEvent")) {
                this.sortLocalData();
                this.meanDataWindowPanelRef.repaint();
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW05");
        }
    }

    private void sortLocalData() {
        try {
            if (this.sortByMappingID) {
                if (this.metric.equals("Inclusive")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("FIdDI") : this.sMWData.getSMWMeanData("FIdAI");
                } else if (this.metric.equals("Exclusive")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("FIdDE") : this.sMWData.getSMWMeanData("FIdAE");
                } else if (this.metric.equals("Number of Calls")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("FIdDNC") : this.sMWData.getSMWMeanData("FIdANC");
                } else if (this.metric.equals("Number of Subroutines")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("FIdDNS") : this.sMWData.getSMWMeanData("FIdANS");
                } else if (this.metric.equals("Per Call Value")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("FIdDUS") : this.sMWData.getSMWMeanData("FIdAUS");
                }
            } else if (this.sortByName) {
                if (this.metric.equals("Inclusive")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("NDI") : this.sMWData.getSMWMeanData("NAI");
                } else if (this.metric.equals("Exclusive")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("NDE") : this.sMWData.getSMWMeanData("NAE");
                } else if (this.metric.equals("Number of Calls")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("NDNC") : this.sMWData.getSMWMeanData("NANC");
                } else if (this.metric.equals("Number of Subroutines")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("NDNS") : this.sMWData.getSMWMeanData("NANS");
                } else if (this.metric.equals("Per Call Value")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("NDUS") : this.sMWData.getSMWMeanData("NAUS");
                }
            } else if (this.sortByMillisecond) {
                if (this.metric.equals("Inclusive")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("MDI") : this.sMWData.getSMWMeanData("MAI");
                } else if (this.metric.equals("Exclusive")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("MDE") : this.sMWData.getSMWMeanData("MAE");
                } else if (this.metric.equals("Number of Calls")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("MDNC") : this.sMWData.getSMWMeanData("MANC");
                } else if (this.metric.equals("Number of Subroutines")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("MDNS") : this.sMWData.getSMWMeanData("MANS");
                } else if (this.metric.equals("Per Call Value")) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("MDUS") : this.sMWData.getSMWMeanData("MAUS");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW06");
        }
    }

    public Vector getStaticMainWindowSystemData() {
        return this.currentSMWMeanData;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public String getMetric() {
        return this.metric;
    }

    public boolean isPercent() {
        return this.percent;
    }

    public String units() {
        return this.unitsString;
    }

    public int getSliderValue() {
        int n = -1;
        try {
            n = this.barLengthSlider.getValue();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW07");
        }
        return n;
    }

    public double getSliderMultiple() {
        String string = null;
        try {
            string = (String)this.sliderMultiple.getSelectedItem();
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW08");
            return 0.0;
        }
    }

    private void displaySiders(boolean bl) {
        if (bl) {
            this.contentPane.remove(this.meanDataWindowPanelScrollPane);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultipleLabel, this.gbc, 0, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultiple, this.gbc, 1, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, this.gbc, 2, 0, 1, 1);
            this.gbc.fill = 2;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.7;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, this.gbc, 3, 0, 1, 1);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.meanDataWindowPanelScrollPane, this.gbc, 0, 1, 4, 1);
        } else {
            this.contentPane.remove(this.sliderMultipleLabel);
            this.contentPane.remove(this.sliderMultiple);
            this.contentPane.remove(this.barLengthLabel);
            this.contentPane.remove(this.barLengthSlider);
            this.contentPane.remove(this.meanDataWindowPanelScrollPane);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.meanDataWindowPanelScrollPane, this.gbc, 0, 0, 1, 1);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW09");
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (jRacy.debugIsOn) {
                System.out.println("------------------------");
                System.out.println("The Mean Data Window is closing");
                System.out.println("Clearing resourses for this window.");
            }
            ((Component)this).setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW10");
        }
    }
}

