/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.GlobalMapping;
import jRacy.GlobalMappingElement;
import jRacy.MappingDataWindow;
import jRacy.SMWContext;
import jRacy.SMWServer;
import jRacy.SMWThread;
import jRacy.SMWThreadDataElement;
import jRacy.StaticMainWindowData;
import jRacy.Trial;
import jRacy.UtilFncs;
import jRacy.jRacy;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class MappingDataWindowPanel
extends JPanel
implements ActionListener,
MouseListener {
    int xPanelSize = 550;
    int yPanelSize = 550;
    private Vector staticNodeList;
    private int newXPanelSize = 0;
    private int newYPanelSize = 0;
    private String counterName = null;
    private int mappingID = -1;
    private String mappingName;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int defaultBarLength = 250;
    private int maxXLength = 0;
    private double maxInclusiveValue = 0.0;
    private double maxExclusiveValue = 0.0;
    private double maxInclusivePercentValue = 0.0;
    private double maxExclusivePercentValue = 0.0;
    private double maxNumberOfCalls = 0.0;
    private double maxNumberOfSubroutines = 0.0;
    private double maxUserSecPerCall = 0.0;
    private int serverNumber = -1;
    private int contextNumber = -1;
    private int threadNumber = -1;
    private Trial trial = null;
    private MappingDataWindow mDWindow = null;
    private StaticMainWindowData sMWData = null;
    private SMWServer tmpSMWServer = null;
    private SMWContext tmpSMWContext = null;
    private SMWThread tmpSMWThread = null;
    private SMWThreadDataElement tmpSMWThreadDataElement = null;
    private Vector tmpContextList = null;
    private Vector tmpThreadList = null;
    private Vector tmpThreadDataElementList = null;
    private JPopupMenu popup = new JPopupMenu();

    public MappingDataWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDWP01");
        }
    }

    public MappingDataWindowPanel(Trial trial, int n, MappingDataWindow mappingDataWindow) {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.trial = trial;
            GlobalMapping globalMapping = this.trial.getGlobalMapping();
            GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
            this.mappingName = globalMappingElement.getMappingName();
            this.mDWindow = mappingDataWindow;
            JMenuItem jMenuItem = new JMenuItem("Change Function Color");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Reset to Generic Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            this.repaint();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            int n;
            String string;
            Color color;
            double d;
            int n2;
            int n3;
            int n4;
            FontMetrics fontMetrics;
            Font font;
            super.paintComponent(graphics);
            Rectangle rectangle = graphics.getClipBounds();
            int n5 = (int)rectangle.getY();
            int n6 = (int)((double)n5 + rectangle.getHeight());
            n6 += this.barSpacing;
            if (!this.trial.getPreferences().areBarDetailsSet()) {
                font = new Font(this.trial.getPreferences().getJRacyFont(), this.trial.getPreferences().getFontStyle(), 12);
                graphics.setFont(font);
                fontMetrics = graphics.getFontMetrics(font);
                n4 = fontMetrics.getAscent();
                int n7 = fontMetrics.getMaxDescent();
                n3 = n4 + n7;
                this.trial.getPreferences().setBarDetails(n4, n3 + 5);
                this.trial.getPreferences().setSliders(n4, n3 + 5);
            }
            this.barSpacing = this.trial.getPreferences().getBarSpacing();
            this.barHeight = this.trial.getPreferences().getBarHeight();
            font = new Font(this.trial.getPreferences().getJRacyFont(), this.trial.getPreferences().getFontStyle(), 12);
            fontMetrics = graphics.getFontMetrics(font);
            n4 = fontMetrics.getAscent() + fontMetrics.getMaxDescent();
            Font font2 = new Font(this.trial.getPreferences().getJRacyFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
            graphics.setFont(font2);
            fontMetrics = graphics.getFontMetrics(font2);
            n3 = jRacy.defaultNumberPrecision;
            boolean bl = false;
            int n8 = 2 * n4 + 14;
            int n9 = 0;
            int n10 = this.defaultBarLength + 60;
            GlobalMapping globalMapping = this.trial.getGlobalMapping();
            GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(this.mappingName, 0);
            this.mappingID = globalMappingElement.getGlobalID();
            this.maxInclusiveValue = globalMappingElement.getMaxInclusiveValue(this.trial.getCurValLoc());
            this.maxExclusiveValue = globalMappingElement.getMaxExclusiveValue(this.trial.getCurValLoc());
            this.maxInclusivePercentValue = globalMappingElement.getMaxInclusivePercentValue(this.trial.getCurValLoc());
            this.maxExclusivePercentValue = globalMappingElement.getMaxExclusivePercentValue(this.trial.getCurValLoc());
            this.maxNumberOfCalls = globalMappingElement.getMaxNumberOfCalls();
            this.maxNumberOfSubroutines = globalMappingElement.getMaxNumberOfSubRoutines();
            this.maxUserSecPerCall = globalMappingElement.getMaxUserSecPerCall(this.trial.getCurValLoc());
            if (this.mDWindow.isInclusive()) {
                if (this.mDWindow.isPercent()) {
                    n2 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxInclusivePercentValue, n3) + "%");
                    n10 += n2;
                } else if (this.mDWindow.units().equals("Seconds")) {
                    n2 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxInclusiveValue / 1000000.0, n3));
                    n10 += n2;
                } else if (this.mDWindow.units().equals("Milliseconds")) {
                    n2 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxInclusiveValue / 1000.0, n3));
                    n10 += n2;
                } else {
                    n2 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxInclusiveValue, n3));
                    n10 += n2;
                }
            } else if (this.mDWindow.isPercent()) {
                n2 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxExclusivePercentValue, n3) + "%");
                n10 += n2;
            } else if (this.mDWindow.units().equals("Seconds")) {
                n2 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxExclusiveValue / 1000000.0, n3));
                n10 += n2;
            } else if (this.mDWindow.units().equals("Milliseconds")) {
                n2 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxExclusiveValue / 1000.0, n3));
                n10 += n2;
            } else {
                n2 = fontMetrics.stringWidth(UtilFncs.getTestString(this.maxExclusiveValue, n3));
                n10 += n2;
            }
            String string2 = "mean";
            if (n8 >= n5 && n8 <= n6) {
                int n11;
                double d2;
                if (this.mDWindow.getMetric().equals("Inclusive")) {
                    if (this.mDWindow.isPercent()) {
                        n8 += this.barSpacing;
                        d = globalMappingElement.getMeanInclusivePercentValue(this.trial.getCurValLoc());
                        d2 = d / this.maxInclusivePercentValue;
                        n11 = (int)(d2 * (double)this.defaultBarLength);
                        if (n11 == 0) {
                            n11 = 1;
                        }
                        color = globalMappingElement.getMappingColor();
                        graphics.setColor(color);
                        if (n11 > 2 && this.barHeight > 2) {
                            graphics.fillRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 1, this.barHeight - 1);
                            if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                                graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                            } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                                graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                            } else {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                            }
                        } else {
                            if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                            } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            } else {
                                color = globalMappingElement.getMappingColor();
                                graphics.setColor(color);
                            }
                            graphics.fillRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                        }
                        graphics.setColor(Color.black);
                        string = UtilFncs.adjustDoublePresision(d, n3) + "%";
                        n2 = fontMetrics.stringWidth(string);
                        n = n10 - n11 - n2 - 5;
                        graphics.drawString(string, n, n8);
                        string = string2;
                        graphics.drawString(string, n10 + 5, n8);
                        n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                        if (n9 < n2) {
                            n9 = n2 + 15;
                        }
                    } else {
                        n8 += this.barSpacing;
                        d = globalMappingElement.getMeanInclusiveValue(this.trial.getCurValLoc());
                        d2 = d / this.maxInclusiveValue;
                        n11 = (int)(d2 * (double)this.defaultBarLength);
                        if (n11 == 0) {
                            n11 = 1;
                        }
                        color = globalMappingElement.getMappingColor();
                        graphics.setColor(color);
                        if (n11 > 2 && this.barHeight > 2) {
                            graphics.fillRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 1, this.barHeight - 1);
                            if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                                graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                            } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                                graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                            } else {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                            }
                        } else {
                            if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                            } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            } else {
                                color = globalMappingElement.getMappingColor();
                                graphics.setColor(color);
                            }
                            graphics.fillRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                        }
                        graphics.setColor(Color.black);
                        if (this.mDWindow.units().equals("Seconds")) {
                            string = new String(Double.toString(UtilFncs.adjustDoublePresision(d / 1000000.0, n3)));
                            n2 = fontMetrics.stringWidth(string);
                            n = n10 - n11 - n2 - 5;
                            graphics.drawString(string, n, n8);
                        } else if (this.mDWindow.units().equals("Milliseconds")) {
                            string = new String(Double.toString(UtilFncs.adjustDoublePresision(d / 1000.0, n3)));
                            n2 = fontMetrics.stringWidth(string);
                            n = n10 - n11 - n2 - 5;
                            graphics.drawString(string, n, n8);
                        } else {
                            string = new String(Double.toString(UtilFncs.adjustDoublePresision(d, n3)));
                            n2 = fontMetrics.stringWidth(string);
                            n = n10 - n11 - n2 - 5;
                            graphics.drawString(string, n, n8);
                        }
                        string = string2;
                        graphics.drawString(string, n10 + 5, n8);
                        n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                        if (n9 < n2) {
                            n9 = n2 + 15;
                        }
                    }
                } else if (this.mDWindow.getMetric().equals("Exclusive")) {
                    if (this.mDWindow.isPercent()) {
                        n8 += this.barSpacing;
                        d = globalMappingElement.getMeanExclusivePercentValue(this.trial.getCurValLoc());
                        d2 = d / this.maxExclusivePercentValue;
                        n11 = (int)(d2 * (double)this.defaultBarLength);
                        if (n11 == 0) {
                            n11 = 1;
                        }
                        color = globalMappingElement.getMappingColor();
                        graphics.setColor(color);
                        if (n11 > 2 && this.barHeight > 2) {
                            graphics.fillRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 1, this.barHeight - 1);
                            if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                                graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                            } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                                graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                            } else {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                            }
                        } else {
                            if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                            } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            } else {
                                color = globalMappingElement.getMappingColor();
                                graphics.setColor(color);
                            }
                            graphics.fillRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                        }
                        graphics.setColor(Color.black);
                        string = UtilFncs.adjustDoublePresision(d, n3) + "%";
                        n2 = fontMetrics.stringWidth(string);
                        n = n10 - n11 - n2 - 5;
                        graphics.drawString(string, n, n8);
                        string = string2;
                        graphics.drawString(string, n10 + 5, n8);
                        n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                        if (n9 < n2) {
                            n9 = n2 + 15;
                        }
                    } else {
                        n8 += this.barSpacing;
                        d = globalMappingElement.getMeanExclusiveValue(this.trial.getCurValLoc());
                        d2 = d / this.maxExclusiveValue;
                        n11 = (int)(d2 * (double)this.defaultBarLength);
                        if (n11 == 0) {
                            n11 = 1;
                        }
                        color = globalMappingElement.getMappingColor();
                        graphics.setColor(color);
                        if (n11 > 2 && this.barHeight > 2) {
                            graphics.fillRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 1, this.barHeight - 1);
                            if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                                graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                            } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                                graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                            } else {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                            }
                        } else {
                            if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                            } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            } else {
                                color = globalMappingElement.getMappingColor();
                                graphics.setColor(color);
                            }
                            graphics.fillRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                        }
                        graphics.setColor(Color.black);
                        if (this.mDWindow.units().equals("Seconds")) {
                            string = new String(Double.toString(UtilFncs.adjustDoublePresision(d / 1000000.0, n3)));
                            n2 = fontMetrics.stringWidth(string);
                            n = n10 - n11 - n2 - 5;
                            graphics.drawString(string, n, n8);
                        } else if (this.mDWindow.units().equals("Milliseconds")) {
                            string = new String(Double.toString(UtilFncs.adjustDoublePresision(d / 1000.0, n3)));
                            n2 = fontMetrics.stringWidth(string);
                            n = n10 - n11 - n2 - 5;
                            graphics.drawString(string, n, n8);
                        } else {
                            string = new String(Double.toString(UtilFncs.adjustDoublePresision(d, n3)));
                            n2 = fontMetrics.stringWidth(string);
                            n = n10 - n11 - n2 - 5;
                            graphics.drawString(string, n, n8);
                        }
                        string = string2;
                        graphics.drawString(string, n10 + 5, n8);
                        n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                        if (n9 < n2) {
                            n9 = n2 + 15;
                        }
                    }
                } else if (this.mDWindow.getMetric().equals("Number of Calls")) {
                    n8 += this.barSpacing;
                    d = globalMappingElement.getMeanNumberOfCalls();
                    d2 = d / this.maxNumberOfCalls;
                    n11 = (int)(d2 * (double)this.defaultBarLength);
                    if (n11 == 0) {
                        n11 = 1;
                    }
                    color = globalMappingElement.getMappingColor();
                    graphics.setColor(color);
                    if (n11 > 2 && this.barHeight > 2) {
                        graphics.fillRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 1, this.barHeight - 1);
                        if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                            graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                            graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                        } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                            graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                        } else {
                            graphics.setColor(Color.black);
                            graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                        }
                    } else {
                        if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                        } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                        } else {
                            color = globalMappingElement.getMappingColor();
                            graphics.setColor(color);
                        }
                        graphics.fillRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                    }
                    graphics.setColor(Color.black);
                    string = new String(Double.toString(d));
                    n2 = fontMetrics.stringWidth(string);
                    n = n10 - n11 - n2 - 5;
                    graphics.drawString(Double.toString(d), n, n8);
                    string = string2;
                    graphics.drawString(string, n10 + 5, n8);
                    n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                    if (n9 < n2) {
                        n9 = n2 + 15;
                    }
                } else if (this.mDWindow.getMetric().equals("Number of Subroutines")) {
                    n8 += this.barSpacing;
                    d = globalMappingElement.getMeanNumberOfSubRoutines();
                    d2 = d / this.maxNumberOfSubroutines;
                    n11 = (int)(d2 * (double)this.defaultBarLength);
                    if (n11 == 0) {
                        n11 = 1;
                    }
                    color = globalMappingElement.getMappingColor();
                    graphics.setColor(color);
                    if (n11 > 2 && this.barHeight > 2) {
                        graphics.fillRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 1, this.barHeight - 1);
                        if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                            graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                            graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                        } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                            graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                        } else {
                            graphics.setColor(Color.black);
                            graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                        }
                    } else {
                        if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                        } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                        } else {
                            color = globalMappingElement.getMappingColor();
                            graphics.setColor(color);
                        }
                        graphics.fillRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                    }
                    graphics.setColor(Color.black);
                    string = new String(Double.toString(d));
                    n2 = fontMetrics.stringWidth(string);
                    n = n10 - n11 - n2 - 5;
                    graphics.drawString(Double.toString(d), n, n8);
                    string = string2;
                    graphics.drawString(string, n10 + 5, n8);
                    n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                    if (n9 < n2) {
                        n9 = n2 + 15;
                    }
                } else if (this.mDWindow.getMetric().equals("Per Call Value")) {
                    n8 += this.barSpacing;
                    d = globalMappingElement.getMeanUserSecPerCall(this.trial.getCurValLoc());
                    d2 = d / this.maxUserSecPerCall;
                    n11 = (int)(d2 * (double)this.defaultBarLength);
                    if (n11 == 0) {
                        n11 = 1;
                    }
                    color = globalMappingElement.getMappingColor();
                    graphics.setColor(color);
                    if (n11 > 2 && this.barHeight > 2) {
                        graphics.fillRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 1, this.barHeight - 1);
                        if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                            graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                            graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                        } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                            graphics.drawRect(n10 - n11 + 1, n8 - this.barHeight + 1, n11 - 2, this.barHeight - 2);
                        } else {
                            graphics.setColor(Color.black);
                            graphics.drawRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                        }
                    } else {
                        if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                        } else if (globalMappingElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                        } else {
                            color = globalMappingElement.getMappingColor();
                            graphics.setColor(color);
                        }
                        graphics.fillRect(n10 - n11, n8 - this.barHeight, n11, this.barHeight);
                    }
                    graphics.setColor(Color.black);
                    string = new String(Double.toString(UtilFncs.adjustDoublePresision(d, n3)));
                    n2 = fontMetrics.stringWidth(string);
                    n = n10 - n11 - n2 - 5;
                    graphics.drawString(string, n, n8);
                    string = string2;
                    graphics.drawString(string, n10 + 5, n8);
                    n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                    if (n9 < n2) {
                        n9 = n2 + 15;
                    }
                }
            }
            this.serverNumber = 0;
            Enumeration enumeration = this.mDWindow.getStaticMainWindowSystemData().elements();
            while (enumeration.hasMoreElements()) {
                this.tmpSMWServer = (SMWServer)enumeration.nextElement();
                this.contextNumber = 0;
                this.tmpContextList = this.tmpSMWServer.getContextList();
                Enumeration enumeration2 = this.tmpContextList.elements();
                while (enumeration2.hasMoreElements()) {
                    this.tmpSMWContext = (SMWContext)enumeration2.nextElement();
                    this.tmpThreadList = this.tmpSMWContext.getThreadList();
                    this.threadNumber = 0;
                    Enumeration enumeration3 = this.tmpThreadList.elements();
                    while (enumeration3.hasMoreElements()) {
                        int n12;
                        double d3;
                        Enumeration enumeration4;
                        string2 = "n,c,t   " + this.serverNumber + "," + this.contextNumber + "," + this.threadNumber;
                        this.tmpSMWThread = (SMWThread)enumeration3.nextElement();
                        this.tmpThreadDataElementList = this.tmpSMWThread.getThreadDataList();
                        if (this.mDWindow.getMetric().equals("Inclusive")) {
                            if (this.mDWindow.isPercent()) {
                                enumeration4 = this.tmpThreadDataElementList.elements();
                                while (enumeration4.hasMoreElements()) {
                                    this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                                    if (this.tmpSMWThreadDataElement.getMappingID() != this.mappingID || (n8 += this.barSpacing) < n5 || n8 > n6) continue;
                                    d = this.tmpSMWThreadDataElement.getInclusivePercentValue();
                                    d3 = d / this.maxInclusivePercentValue;
                                    n12 = (int)(d3 * (double)this.defaultBarLength);
                                    if (n12 == 0) {
                                        n12 = 1;
                                    }
                                    color = this.tmpSMWThreadDataElement.getMappingColor();
                                    graphics.setColor(color);
                                    if (n12 > 2 && this.barHeight > 2) {
                                        graphics.fillRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 1, this.barHeight - 1);
                                        if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                            graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                            graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                        } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                            graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                            graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                        } else {
                                            graphics.setColor(Color.black);
                                            graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                        }
                                    } else {
                                        if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                        } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                        } else {
                                            color = this.tmpSMWThreadDataElement.getMappingColor();
                                            graphics.setColor(color);
                                        }
                                        graphics.fillRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                    }
                                    graphics.setColor(Color.black);
                                    string = UtilFncs.adjustDoublePresision(d, n3) + "%";
                                    n2 = fontMetrics.stringWidth(string);
                                    n = n10 - n12 - n2 - 5;
                                    graphics.drawString(string, n, n8);
                                    string = string2;
                                    graphics.drawString(string, n10 + 5, n8);
                                    n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                                    if (n9 < n2) {
                                        n9 = n2 + 15;
                                    }
                                    this.tmpSMWThreadDataElement.setMDWDrawCoords(n, n2, n8 - this.barHeight, n8);
                                }
                            } else {
                                enumeration4 = this.tmpThreadDataElementList.elements();
                                while (enumeration4.hasMoreElements()) {
                                    this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                                    if (this.tmpSMWThreadDataElement.getMappingID() != this.mappingID || (n8 += this.barSpacing) < n5 || n8 > n6) continue;
                                    d = this.tmpSMWThreadDataElement.getInclusiveValue();
                                    d3 = d / this.maxInclusiveValue;
                                    n12 = (int)(d3 * (double)this.defaultBarLength);
                                    if (n12 == 0) {
                                        n12 = 1;
                                    }
                                    color = this.tmpSMWThreadDataElement.getMappingColor();
                                    graphics.setColor(color);
                                    if (n12 > 2 && this.barHeight > 2) {
                                        graphics.fillRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 1, this.barHeight - 1);
                                        if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                            graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                            graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                        } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                            graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                            graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                        } else {
                                            graphics.setColor(Color.black);
                                            graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                        }
                                    } else {
                                        if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                        } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                        } else {
                                            color = this.tmpSMWThreadDataElement.getMappingColor();
                                            graphics.setColor(color);
                                        }
                                        graphics.fillRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                    }
                                    graphics.setColor(Color.black);
                                    if (this.mDWindow.units().equals("Seconds")) {
                                        string = new String(Double.toString(UtilFncs.adjustDoublePresision(d / 1000000.0, n3)));
                                        n2 = fontMetrics.stringWidth(string);
                                        n = n10 - n12 - n2 - 5;
                                        graphics.drawString(string, n, n8);
                                    } else if (this.mDWindow.units().equals("Milliseconds")) {
                                        string = new String(Double.toString(UtilFncs.adjustDoublePresision(d / 1000.0, n3)));
                                        n2 = fontMetrics.stringWidth(string);
                                        n = n10 - n12 - n2 - 5;
                                        graphics.drawString(string, n, n8);
                                    } else {
                                        string = new String(Double.toString(UtilFncs.adjustDoublePresision(d, n3)));
                                        n2 = fontMetrics.stringWidth(string);
                                        n = n10 - n12 - n2 - 5;
                                        graphics.drawString(string, n, n8);
                                    }
                                    string = string2;
                                    graphics.drawString(string, n10 + 5, n8);
                                    n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                                    if (n9 < n2) {
                                        n9 = n2 + 15;
                                    }
                                    this.tmpSMWThreadDataElement.setMDWDrawCoords(n, n2, n8 - this.barHeight, n8);
                                }
                            }
                        } else if (this.mDWindow.getMetric().equals("Exclusive")) {
                            if (this.mDWindow.isPercent()) {
                                enumeration4 = this.tmpThreadDataElementList.elements();
                                while (enumeration4.hasMoreElements()) {
                                    this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                                    if (this.tmpSMWThreadDataElement.getMappingID() != this.mappingID || (n8 += this.barSpacing) < n5 || n8 > n6) continue;
                                    d = this.tmpSMWThreadDataElement.getExclusivePercentValue();
                                    d3 = d / this.maxExclusivePercentValue;
                                    n12 = (int)(d3 * (double)this.defaultBarLength);
                                    if (n12 == 0) {
                                        n12 = 1;
                                    }
                                    color = this.tmpSMWThreadDataElement.getMappingColor();
                                    graphics.setColor(color);
                                    if (n12 > 2 && this.barHeight > 2) {
                                        graphics.fillRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 1, this.barHeight - 1);
                                        if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                            graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                            graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                        } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                            graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                            graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                        } else {
                                            graphics.setColor(Color.black);
                                            graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                        }
                                    } else {
                                        if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                        } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                        } else {
                                            color = this.tmpSMWThreadDataElement.getMappingColor();
                                            graphics.setColor(color);
                                        }
                                        graphics.fillRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                    }
                                    graphics.setColor(Color.black);
                                    string = UtilFncs.adjustDoublePresision(d, n3) + "%";
                                    n2 = fontMetrics.stringWidth(string);
                                    n = n10 - n12 - n2 - 5;
                                    graphics.drawString(string, n, n8);
                                    string = string2;
                                    graphics.drawString(string, n10 + 5, n8);
                                    n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                                    if (n9 < n2) {
                                        n9 = n2 + 15;
                                    }
                                    this.tmpSMWThreadDataElement.setMDWDrawCoords(n, n2, n8 - this.barHeight, n8);
                                }
                            } else {
                                enumeration4 = this.tmpThreadDataElementList.elements();
                                while (enumeration4.hasMoreElements()) {
                                    this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                                    if (this.tmpSMWThreadDataElement.getMappingID() != this.mappingID || (n8 += this.barSpacing) < n5 || n8 > n6) continue;
                                    d = this.tmpSMWThreadDataElement.getExclusiveValue();
                                    d3 = d / this.maxExclusiveValue;
                                    n12 = (int)(d3 * (double)this.defaultBarLength);
                                    if (n12 == 0) {
                                        n12 = 1;
                                    }
                                    color = this.tmpSMWThreadDataElement.getMappingColor();
                                    graphics.setColor(color);
                                    if (n12 > 2 && this.barHeight > 2) {
                                        graphics.fillRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 1, this.barHeight - 1);
                                        if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                            graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                            graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                        } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                            graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                            graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                        } else {
                                            graphics.setColor(Color.black);
                                            graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                        }
                                    } else {
                                        if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                            graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                        } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                            graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                        } else {
                                            color = this.tmpSMWThreadDataElement.getMappingColor();
                                            graphics.setColor(color);
                                        }
                                        graphics.fillRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                    }
                                    graphics.setColor(Color.black);
                                    if (this.mDWindow.units().equals("Seconds")) {
                                        string = new String(Double.toString(UtilFncs.adjustDoublePresision(d / 1000000.0, n3)));
                                        n2 = fontMetrics.stringWidth(string);
                                        n = n10 - n12 - n2 - 5;
                                        graphics.drawString(string, n, n8);
                                    } else if (this.mDWindow.units().equals("Milliseconds")) {
                                        string = new String(Double.toString(UtilFncs.adjustDoublePresision(d / 1000.0, n3)));
                                        n2 = fontMetrics.stringWidth(string);
                                        n = n10 - n12 - n2 - 5;
                                        graphics.drawString(string, n, n8);
                                    } else {
                                        string = new String(Double.toString(UtilFncs.adjustDoublePresision(d, n3)));
                                        n2 = fontMetrics.stringWidth(string);
                                        n = n10 - n12 - n2 - 5;
                                        graphics.drawString(string, n, n8);
                                    }
                                    string = string2;
                                    graphics.drawString(string, n10 + 5, n8);
                                    n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                                    if (n9 < n2) {
                                        n9 = n2 + 15;
                                    }
                                    this.tmpSMWThreadDataElement.setMDWDrawCoords(n, n2, n8 - this.barHeight, n8);
                                }
                            }
                        } else if (this.mDWindow.getMetric().equals("Number of Calls")) {
                            enumeration4 = this.tmpThreadDataElementList.elements();
                            while (enumeration4.hasMoreElements()) {
                                this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                                if (this.tmpSMWThreadDataElement.getMappingID() != this.mappingID || (n8 += this.barSpacing) < n5 || n8 > n6) continue;
                                d = this.tmpSMWThreadDataElement.getNumberOfCalls();
                                d3 = d / this.maxNumberOfCalls;
                                n12 = (int)(d3 * (double)this.defaultBarLength);
                                if (n12 == 0) {
                                    n12 = 1;
                                }
                                color = this.tmpSMWThreadDataElement.getMappingColor();
                                graphics.setColor(color);
                                if (n12 > 2 && this.barHeight > 2) {
                                    graphics.fillRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 1, this.barHeight - 1);
                                    if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                        graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                        graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                        graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                    } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                        graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                        graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                        graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                    } else {
                                        graphics.setColor(Color.black);
                                        graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                    }
                                } else {
                                    if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                        graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                    } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                        graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                    } else {
                                        color = this.tmpSMWThreadDataElement.getMappingColor();
                                        graphics.setColor(color);
                                    }
                                    graphics.fillRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                }
                                graphics.setColor(Color.black);
                                string = new String(Double.toString(d));
                                n2 = fontMetrics.stringWidth(string);
                                n = n10 - n12 - n2 - 5;
                                graphics.drawString(Double.toString(d), n, n8);
                                string = string2;
                                graphics.drawString(string, n10 + 5, n8);
                                n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                                if (n9 < n2) {
                                    n9 = n2 + 15;
                                }
                                this.tmpSMWThreadDataElement.setMDWDrawCoords(n, n2, n8 - this.barHeight, n8);
                            }
                        } else if (this.mDWindow.getMetric().equals("Number of Subroutines")) {
                            enumeration4 = this.tmpThreadDataElementList.elements();
                            while (enumeration4.hasMoreElements()) {
                                this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                                if (this.tmpSMWThreadDataElement.getMappingID() != this.mappingID || (n8 += this.barSpacing) < n5 || n8 > n6) continue;
                                d = this.tmpSMWThreadDataElement.getNumberOfSubRoutines();
                                d3 = d / this.maxNumberOfSubroutines;
                                n12 = (int)(d3 * (double)this.defaultBarLength);
                                if (n12 == 0) {
                                    n12 = 1;
                                }
                                color = this.tmpSMWThreadDataElement.getMappingColor();
                                graphics.setColor(color);
                                if (n12 > 2 && this.barHeight > 2) {
                                    graphics.fillRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 1, this.barHeight - 1);
                                    if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                        graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                        graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                        graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                    } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                        graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                        graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                        graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                    } else {
                                        graphics.setColor(Color.black);
                                        graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                    }
                                } else {
                                    if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                        graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                    } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                        graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                    } else {
                                        color = this.tmpSMWThreadDataElement.getMappingColor();
                                        graphics.setColor(color);
                                    }
                                    graphics.fillRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                }
                                graphics.setColor(Color.black);
                                string = new String(Double.toString(d));
                                n2 = fontMetrics.stringWidth(string);
                                n = n10 - n12 - n2 - 5;
                                graphics.drawString(Double.toString(d), n, n8);
                                string = string2;
                                graphics.drawString(string, n10 + 5, n8);
                                n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                                if (n9 < n2) {
                                    n9 = n2 + 15;
                                }
                                this.tmpSMWThreadDataElement.setMDWDrawCoords(n, n2, n8 - this.barHeight, n8);
                            }
                        } else if (this.mDWindow.getMetric().equals("Per Call Value")) {
                            enumeration4 = this.tmpThreadDataElementList.elements();
                            while (enumeration4.hasMoreElements()) {
                                this.tmpSMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                                if (this.tmpSMWThreadDataElement.getMappingID() != this.mappingID || (n8 += this.barSpacing) < n5 || n8 > n6) continue;
                                d = this.tmpSMWThreadDataElement.getUserSecPerCall();
                                d3 = d / this.maxUserSecPerCall;
                                n12 = (int)(d3 * (double)this.defaultBarLength);
                                if (n12 == 0) {
                                    n12 = 1;
                                }
                                color = this.tmpSMWThreadDataElement.getMappingColor();
                                graphics.setColor(color);
                                if (n12 > 2 && this.barHeight > 2) {
                                    graphics.fillRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 1, this.barHeight - 1);
                                    if (this.tmpSMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                        graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                        graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                        graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                    } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                        graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                        graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                        graphics.drawRect(n10 - n12 + 1, n8 - this.barHeight + 1, n12 - 2, this.barHeight - 2);
                                    } else {
                                        graphics.setColor(Color.black);
                                        graphics.drawRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                    }
                                } else {
                                    if (this.mappingID == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                        graphics.setColor(this.trial.getColorChooser().getHighlightColor());
                                    } else if (this.tmpSMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                        graphics.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                    } else {
                                        color = this.tmpSMWThreadDataElement.getMappingColor();
                                        graphics.setColor(color);
                                    }
                                    graphics.fillRect(n10 - n12, n8 - this.barHeight, n12, this.barHeight);
                                }
                                graphics.setColor(Color.black);
                                string = new String(Double.toString(UtilFncs.adjustDoublePresision(d, n3)));
                                n2 = fontMetrics.stringWidth(string);
                                n = n10 - n12 - n2 - 5;
                                graphics.drawString(string, n, n8);
                                string = string2;
                                graphics.drawString(string, n10 + 5, n8);
                                n2 = n10 + fontMetrics.stringWidth(string2) + 5;
                                if (n9 < n2) {
                                    n9 = n2 + 15;
                                }
                                this.tmpSMWThreadDataElement.setMDWDrawCoords(n, n2, n8 - this.barHeight, n8);
                            }
                        }
                        ++this.threadNumber;
                    }
                    ++this.contextNumber;
                }
                ++this.serverNumber;
            }
            graphics.setColor(Color.white);
            graphics.fillRect(0, n5, n9, 2 * n4 + 12);
            graphics.setColor(Color.black);
            graphics.setFont(font);
            this.counterName = this.trial.getCounterName();
            if (this.counterName != null) {
                graphics.drawString("COUNTER NAME: " + this.counterName, 5, n5 + n4 + 3);
            }
            graphics.drawString("FUNCTION NAME: " + this.mappingName, 5, n5 + 2 * n4 + 6);
            n9 = fontMetrics.stringWidth(this.mappingName);
            boolean bl2 = false;
            if (n9 > 550) {
                this.xPanelSize = n9 + 1;
                bl2 = true;
            }
            if (n8 > 550) {
                this.yPanelSize = n8 + 1;
                bl2 = true;
            }
            if (bl2) {
                this.revalidate();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDWP03");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Change Function Color")) {
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(this.mappingID, 0);
                    Color color = globalMappingElement.getMappingColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        globalMappingElement.setSpecificColor(color);
                        globalMappingElement.setColorFlag(true);
                        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(this.mappingID, 0);
                    globalMappingElement.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            if ((mouseEvent.getModifiers() & 0x10) == 0) {
                this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void changeInMultiples() {
        this.computeDefaultBarLength();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize + 10);
    }

    public void computeDefaultBarLength() {
        try {
            double d = this.mDWindow.getSliderValue();
            double d2 = this.mDWindow.getSliderMultiple();
            double d3 = 250.0 * d * d2;
            this.defaultBarLength = (int)d3;
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDWP06");
        }
    }
}

