/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.loader;

import edu.uoregon.tau.dms.dss.Application;
import edu.uoregon.tau.dms.dss.DynaprofOutputSession;
import edu.uoregon.tau.dms.dss.Experiment;
import edu.uoregon.tau.dms.dss.FileList;
import edu.uoregon.tau.dms.dss.HPMToolkitDataSession;
import edu.uoregon.tau.dms.dss.MpiPOutputSession;
import edu.uoregon.tau.dms.dss.PSRunDataSession;
import edu.uoregon.tau.dms.dss.ParaProfDataSession;
import edu.uoregon.tau.dms.dss.ParaProfObserver;
import edu.uoregon.tau.dms.dss.PerfDMFSession;
import edu.uoregon.tau.dms.dss.TauOutputSession;
import edu.uoregon.tau.dms.dss.TauPprofOutputSession;
import edu.uoregon.tau.dms.dss.Trial;
import edu.uoregon.tau.dms.dss.XMLSupport;
import jargs.gnu.CmdLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class LoadTrial
implements ParaProfObserver {
    public static String USAGE = "USAGE: perfdmf_loadtrial [{-f, --filetype} file_type] [{-s,--sourcefile} sourcefilename] [{-e,--experimentid} experiment_id] [{-t, --trialid} trial_id] [{-n,--name} trial_name] [{-p,--problemfile} problem_file]\n\tWhere:\n\t\tfile_type = profiles (TAU), pprof (TAU), dynaprof, mpip, gprof, psrun, sddf (svpablo)\n";
    private File readPprof;
    private File writeXml;
    private String trialTime;
    private String sourceFile;
    private Application app;
    private Experiment exp;
    private int expID = 0;
    public int trialID = 0;
    private int fileType = 0;
    private ParaProfDataSession dataSession = null;
    public String trialName = new String();
    public String problemFile = new String();
    PerfDMFSession dbSession = null;
    Trial trial = null;

    public LoadTrial(String string, String string2) {
        this.sourceFile = string2;
        this.readPprof = new File(string2);
        this.dbSession = new PerfDMFSession();
        this.dbSession.initialize(string);
    }

    public boolean checkForExp(String string) {
        this.expID = Integer.parseInt(string);
        this.exp = this.dbSession.setExperiment(this.expID);
        if (this.exp == null) {
            System.err.println("Please enter a valid experiment ID.");
            System.err.println(USAGE);
            System.exit(-1);
            return false;
        }
        return true;
    }

    public boolean checkForTrial(String string) {
        Trial trial = this.dbSession.setTrial(Integer.parseInt(string));
        return trial != null;
    }

    public void loadTrial(int n) {
        this.trial = null;
        this.fileType = n;
        Vector vector = null;
        File[] fileArray = new File[1];
        FileList fileList = null;
        switch (n) {
            case 0: {
                fileArray[0] = new File(this.sourceFile);
                vector = new Vector();
                vector.add(fileArray);
                this.dataSession = new TauPprofOutputSession();
                break;
            }
            case 1: {
                fileList = new FileList();
                vector = fileList.getFileList(new File(System.getProperty("user.dir")), null, n, "profile", false);
                this.dataSession = new TauOutputSession();
                break;
            }
            case 2: {
                fileArray[0] = new File(this.sourceFile);
                vector = new Vector();
                vector.add(fileArray);
                this.dataSession = new DynaprofOutputSession();
                break;
            }
            case 3: {
                fileArray[0] = new File(this.sourceFile);
                vector = new Vector();
                vector.add(fileArray);
                this.dataSession = new MpiPOutputSession();
                break;
            }
            case 4: {
                if (this.fileExists()) {
                    fileArray[0] = new File(this.sourceFile);
                    vector = new Vector();
                    vector.add(fileArray);
                } else {
                    fileList = new FileList();
                    String[] stringArray = this.extractSourcePath();
                    vector = stringArray[0] != null ? fileList.getFileList(new File(stringArray[0]), null, n, stringArray[1], false) : fileList.getFileList(new File(System.getProperty("user.dir")), null, n, this.sourceFile, false);
                }
                this.dataSession = new HPMToolkitDataSession();
                break;
            }
            case 6: {
                if (this.fileExists()) {
                    fileArray[0] = new File(this.sourceFile);
                    vector = new Vector();
                    vector.add(fileArray);
                } else {
                    fileList = new FileList();
                    String[] stringArray = this.extractSourcePath();
                    vector = stringArray[0] != null ? fileList.getFileList(new File(stringArray[0]), null, n, stringArray[1], false) : fileList.getFileList(new File(System.getProperty("user.dir")), null, n, this.sourceFile, false);
                }
                this.dataSession = new PSRunDataSession();
                break;
            }
        }
        this.trial = new Trial();
        this.trial.setDataSession(this.dataSession);
        this.dataSession.addObserver(this);
        this.dataSession.initialize(vector);
    }

    public void writeTrial() {
        XMLSupport xMLSupport = new XMLSupport(this.trial);
        xMLSupport.writeXmlFiles(0, this.writeXml);
    }

    public void saveTrial() {
        int[] nArray = this.dataSession.getMaxNCTNumbers();
        this.trial.setNodeCount(nArray[0] + 1);
        this.trial.setNumContextsPerNode(nArray[1] + 1);
        this.trial.setNumThreadsPerContext(nArray[2] + 1);
        this.trial.setName(this.trialName);
        this.trial.setProblemDefinition(this.getProblemString());
        this.trial.setExperimentID(this.expID);
        this.dbSession.saveParaProfTrial(this.trial, -1);
        System.out.println("Done saving trial!");
    }

    public void appendToTrial() {
        this.trial.setID(this.trialID);
        this.dbSession.saveParaProfTrial(this.trial, 0);
        System.out.println("Done adding metric to trial!");
    }

    public String getProblemString() {
        if (this.problemFile == null) {
            return new String("");
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.problemFile));
        }
        catch (Exception exception) {
            System.out.println("Problem file not found!  Exiting...");
            System.exit(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            String string;
            try {
                string = bufferedReader.readLine();
            }
            catch (Exception exception) {
                string = null;
            }
            if (string == null) break;
            stringBuffer.append(string.replaceAll("'", "'"));
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public void update(Object object) {
        if (this.trialID == 0) {
            this.saveTrial();
        } else {
            this.appendToTrial();
        }
    }

    public void update() {
        this.saveTrial();
    }

    private boolean fileExists() {
        boolean bl = false;
        try {
            BufferedReader bufferedReader;
            InputStreamReader inputStreamReader;
            FileInputStream fileInputStream = new FileInputStream(this.sourceFile);
            if (fileInputStream != null && (inputStreamReader = new InputStreamReader(fileInputStream)) != null && (bufferedReader = new BufferedReader(inputStreamReader)) != null) {
                bl = true;
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private String[] extractSourcePath() {
        File file = new File(this.sourceFile);
        String[] stringArray = new String[2];
        stringArray[0] = new String(file.getParent());
        if (stringArray[0] != null) {
            stringArray[1] = new String(file.getName());
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        CmdLineParser cmdLineParser = new CmdLineParser();
        CmdLineParser.Option option = cmdLineParser.addBooleanOption('h', "help");
        CmdLineParser.Option option2 = cmdLineParser.addStringOption('g', "configfile");
        CmdLineParser.Option option3 = cmdLineParser.addStringOption('s', "sourcefile");
        CmdLineParser.Option option4 = cmdLineParser.addStringOption('e', "experimentid");
        CmdLineParser.Option option5 = cmdLineParser.addStringOption('n', "name");
        CmdLineParser.Option option6 = cmdLineParser.addStringOption('p', "problemfile");
        CmdLineParser.Option option7 = cmdLineParser.addStringOption('t', "trialid");
        CmdLineParser.Option option8 = cmdLineParser.addStringOption('f', "filetype");
        try {
            cmdLineParser.parse(stringArray);
        }
        catch (CmdLineParser.OptionException optionException) {
            System.err.println(optionException.getMessage());
            System.err.println(USAGE);
            System.exit(-1);
        }
        Boolean bl = (Boolean)cmdLineParser.getOptionValue(option);
        String string = (String)cmdLineParser.getOptionValue(option2);
        String string2 = (String)cmdLineParser.getOptionValue(option3);
        String string3 = (String)cmdLineParser.getOptionValue(option4);
        String string4 = (String)cmdLineParser.getOptionValue(option5);
        String string5 = (String)cmdLineParser.getOptionValue(option6);
        String string6 = (String)cmdLineParser.getOptionValue(option7);
        String string7 = (String)cmdLineParser.getOptionValue(option8);
        if (bl != null && bl.booleanValue()) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        if (string == null) {
            System.err.println("Please enter a valid config file.");
            System.err.println(USAGE);
            System.exit(-1);
        } else if (string2 == null) {
            System.err.println("Please enter a valid source file.");
            System.err.println(USAGE);
            System.exit(-1);
        } else if (string3 == null) {
            System.err.println("Please enter a valid experiment ID.");
            System.err.println(USAGE);
            System.exit(-1);
        }
        int n = 0;
        Object var19_20 = null;
        if (string7 != null) {
            if (string7.equals("pprof")) {
                n = 0;
            } else if (string7.equals("profiles")) {
                n = 1;
            } else if (string7.equals("dynaprof")) {
                n = 2;
            } else if (string7.equals("mpip")) {
                n = 3;
            } else if (string7.equals("hpm")) {
                n = 4;
            } else if (string7.equals("psrun")) {
                n = 6;
            } else {
                System.err.println("Please enter a valid file type.");
                System.err.println(USAGE);
                System.exit(-1);
            }
        }
        if (string4 == null) {
            string4 = new String("");
        }
        LoadTrial loadTrial = new LoadTrial(string, string2);
        loadTrial.checkForExp(string3);
        if (string6 != null) {
            loadTrial.checkForTrial(string6);
            loadTrial.trialID = Integer.parseInt(string6);
        }
        loadTrial.trialName = string4;
        loadTrial.problemFile = string5;
        loadTrial.loadTrial(n);
    }
}

