/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.PSRunLoadHandler;
import edu.uoregon.tau.dms.dss.ParaProfDataSession;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PSRunDataSession
extends ParaProfDataSession {
    private int metric = 0;
    private GlobalMappingElement globalMappingElement = null;
    private GlobalThreadDataElement globalThreadDataElement = null;
    private Node node = null;
    private Context context = null;
    private Thread thread = null;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private String inputString = null;
    private String s1 = null;
    private String s2 = null;
    private String tokenString;
    private String groupNamesString = null;
    private StringTokenizer genericTokenizer;
    private int mappingID = -1;
    private Vector v = null;
    private File[] files = null;
    private BufferedReader br = null;
    boolean initialized = false;
    private Hashtable nodeHash = new Hashtable();

    public PSRunDataSession() {
        this.setMetrics(new Vector());
    }

    public void run() {
        boolean bl = true;
        try {
            this.v = (Vector)this.initializeObject;
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            PSRunLoadHandler pSRunLoadHandler = new PSRunLoadHandler();
            xMLReader.setContentHandler(pSRunLoadHandler);
            xMLReader.setErrorHandler(pSRunLoadHandler);
            Enumeration enumeration = this.v.elements();
            while (enumeration.hasMoreElements()) {
                this.files = (File[])enumeration.nextElement();
                for (int i = 0; i < this.files.length; ++i) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    System.out.println("Processing data file, please wait ......");
                    long l = System.currentTimeMillis();
                    StringTokenizer stringTokenizer = new StringTokenizer(this.files[i].getName(), ".");
                    if (stringTokenizer.countTokens() == 3) {
                        ++this.nodeID;
                    } else {
                        object4 = stringTokenizer.nextToken();
                        object3 = stringTokenizer.nextToken();
                        this.threadID = Integer.parseInt((String)object3);
                        object2 = stringTokenizer.nextToken();
                        object = (Integer)this.nodeHash.get(object2);
                        if (object == null) {
                            this.nodeID = this.nodeHash.size();
                            this.nodeHash.put(object2, new Integer(this.nodeID));
                        } else {
                            this.nodeID = (Integer)object;
                        }
                    }
                    xMLReader.parse(new InputSource(new FileInputStream(this.files[i])));
                    this.initializeThread();
                    object4 = pSRunLoadHandler;
                    object3 = ((PSRunLoadHandler)object4).getMetricHash();
                    object2 = ((Hashtable)object3).keys();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        String string = (String)((Hashtable)object3).get(object);
                        this.processHardwareCounter((String)object, string);
                    }
                    this.setMeanDataAllMetrics(0, this.getNumberOfMetrics());
                    if (UtilFncs.debug) {
                        System.out.println("The total number of threads is: " + this.getNCT().getTotalNumberOfThreads());
                        System.out.println("The number of mappings is: " + this.getGlobalMapping().getNumberOfMappings(0));
                        System.out.println("The number of user events is: " + this.getGlobalMapping().getNumberOfMappings(2));
                    }
                    l = System.currentTimeMillis() - l;
                    System.out.println("Done processing data file!");
                    System.out.println("Time to process file (in milliseconds): " + l);
                }
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    PSRunDataSession.this.notifyObservers();
                }
            });
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "SSD01");
        }
    }

    private void initializeThread() {
        this.mappingID = this.getGlobalMapping().addGlobalMapping("Entire application", 0, 1);
        this.globalMappingElement = this.getGlobalMapping().getGlobalMappingElement(this.mappingID, 0);
        this.nodeID = this.nodeID == -1 ? 0 : this.nodeID;
        this.contextID = this.contextID == -1 ? 0 : this.contextID;
        this.threadID = this.threadID == -1 ? 0 : this.threadID;
        this.node = this.getNCT().getNode(this.nodeID);
        if (this.node == null) {
            this.node = this.getNCT().addNode(this.nodeID);
        }
        this.context = this.node.getContext(this.contextID);
        if (this.context == null) {
            this.context = this.node.addContext(this.contextID);
        }
        this.thread = this.context.getThread(this.threadID);
        if (this.thread == null) {
            this.thread = this.context.addThread(this.threadID);
            this.thread.initializeFunctionList(this.getGlobalMapping().getNumberOfMappings(0));
            this.thread.initializeUsereventList(this.getGlobalMapping().getNumberOfMappings(2));
        }
        this.globalThreadDataElement = this.thread.getFunction(this.mappingID);
        if (this.globalThreadDataElement == null) {
            this.globalThreadDataElement = new GlobalThreadDataElement(this.getGlobalMapping().getGlobalMappingElement(this.mappingID, 0), false);
            this.thread.addFunction(this.globalThreadDataElement, this.mappingID);
        }
    }

    private void processHardwareCounter(String string, String string2) {
        this.thread.incrementStorage();
        this.globalMappingElement.incrementStorage();
        this.globalThreadDataElement.incrementStorage();
        try {
            double d = 0.0;
            d = Double.parseDouble(string2);
            this.metric = this.getNumberOfMetrics();
            Metric metric = this.addMetric(string);
            if (this.metric < this.getNumberOfMetrics()) {
                this.getGlobalMapping().increaseVectorStorage();
            }
            this.metric = metric.getID();
            this.globalThreadDataElement.setExclusiveValue(this.metric, d);
            this.globalThreadDataElement.setInclusiveValue(this.metric, d);
            this.globalThreadDataElement.setUserSecPerCall(this.metric, d);
            this.globalThreadDataElement.setNumberOfCalls(1);
            this.globalThreadDataElement.setNumberOfSubRoutines(0);
            if (this.globalMappingElement.getMaxExclusiveValue(this.metric) < d) {
                this.globalMappingElement.setMaxExclusiveValue(this.metric, d);
                this.globalMappingElement.setMaxInclusiveValue(this.metric, d);
            }
            if (this.globalMappingElement.getMaxUserSecPerCall(this.metric) < d) {
                this.globalMappingElement.setMaxUserSecPerCall(this.metric, d);
            }
            this.globalMappingElement.setMaxNumberOfCalls(1);
            this.globalMappingElement.setMaxNumberOfSubRoutines(0);
        }
        catch (Exception exception) {
            System.out.println("An error occured while parsing the XML data!");
            exception.printStackTrace();
        }
    }
}

