/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.database;

import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.database.ParseConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DBConnector
implements DB {
    private Statement statement;
    private Connection conn = null;
    private ParseConfig parseConfig = null;
    private String dbaddress;
    private String dbUser;
    private String dbPassword;
    private String driverName;

    public DBConnector(ParseConfig parseConfig) throws SQLException {
        this.parseConfig = parseConfig;
        this.setJDBC(parseConfig);
        this.register();
    }

    public DBConnector(String string, String string2, ParseConfig parseConfig) throws SQLException {
        this.parseConfig = parseConfig;
        this.setJDBC(parseConfig);
        this.register();
        this.connect(string, string2);
    }

    public void setJDBC(ParseConfig parseConfig) {
        this.driverName = parseConfig.getJDBCDriver();
        this.dbaddress = parseConfig.getDBType().equals("db2") ? "jdbc:" + parseConfig.getDBType() + ":" + parseConfig.getDBName() : "jdbc:" + parseConfig.getDBType() + "://" + parseConfig.getDBHost() + ":" + parseConfig.getDBPort() + "/" + parseConfig.getDBName();
    }

    public void close() {
        try {
            if (this.conn.isClosed()) {
                return;
            }
            this.conn.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public boolean connect(String string, String string2) throws SQLException {
        String string3 = "";
        try {
            if (this.conn != null) {
                return true;
            }
            string3 = this.getConnectString();
            this.conn = DriverManager.getConnection(string3, string, string2);
            return true;
        }
        catch (SQLException sQLException) {
            System.err.println("Cannot connect to server.");
            System.err.println("Connection String: " + string3);
            throw sQLException;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (this.statement == null) {
            if (this.conn == null) {
                System.err.println("Database is closed for " + string);
                return null;
            }
            this.statement = this.conn.createStatement();
        }
        return this.statement.executeQuery(string.trim());
    }

    public boolean execute(String string) throws SQLException {
        if (this.statement == null) {
            if (this.conn == null) {
                System.err.println("Database is closed for " + string);
                return false;
            }
            this.statement = this.conn.createStatement();
        }
        return this.statement.execute(string.trim());
    }

    public int executeUpdate(String string) throws SQLException {
        try {
            if (this.statement == null) {
                if (this.conn == null) {
                    System.err.println("Database is closed for " + string);
                    return 0;
                }
                this.statement = this.conn.createStatement();
            }
            return this.statement.executeUpdate(string.trim());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return 0;
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getConnectString() {
        return this.dbaddress;
    }

    public String getDataItem(String string) {
        try {
            ResultSet resultSet = this.executeQuery(string);
            if (!resultSet.next()) {
                resultSet.close();
                return null;
            }
            String string2 = resultSet.getString(1);
            resultSet.close();
            return string2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    public boolean isClosed() {
        if (this.conn == null) {
            return true;
        }
        try {
            return this.conn.isClosed();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return true;
        }
    }

    public void register() {
        try {
            Class.forName(this.driverName).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setDBAddress(String string) {
        this.dbaddress = string;
    }

    public String getDBType() {
        return new String(this.parseConfig.getDBType());
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.getConnection().prepareStatement(string);
    }
}

